/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.model.baked.chiseled;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.security.InvalidParameterException;
import java.util.Collection;
import mod.chiselsandbits.api.blockinformation.BlockInformation;
import mod.chiselsandbits.api.multistate.accessor.IAreaAccessor;
import mod.chiselsandbits.api.multistate.accessor.IStateEntryInfo;
import mod.chiselsandbits.client.culling.ICullTest;
import mod.chiselsandbits.client.culling.MCCullTest;
import mod.chiselsandbits.client.model.baked.chiseled.VoxelType;
import mod.chiselsandbits.platforms.core.client.rendering.type.IRenderTypeManager;
import net.minecraft.client.renderer.RenderType;

public enum ChiselRenderType {
    SOLID(RenderType.m_110451_(), VoxelType.SOLID),
    SOLID_FLUID(RenderType.m_110451_(), VoxelType.FLUID),
    CUTOUT(RenderType.m_110463_(), VoxelType.UNKNOWN),
    CUTOUT_MIPPED(RenderType.m_110457_(), VoxelType.UNKNOWN),
    TRANSLUCENT(RenderType.m_110466_(), VoxelType.UNKNOWN),
    TRANSLUCENT_FLUID(RenderType.m_110466_(), VoxelType.FLUID),
    TRIPWIRE(RenderType.m_110503_(), VoxelType.UNKNOWN);

    public final RenderType layer;
    public final VoxelType type;
    private static final Multimap<VoxelType, ChiselRenderType> TYPED_RENDER_TYPES;

    private ChiselRenderType(RenderType layer, VoxelType type) {
        this.layer = layer;
        this.type = type;
    }

    public boolean isRequiredForRendering(IAreaAccessor accessor) {
        if (accessor == null) {
            return false;
        }
        return accessor.stream().anyMatch(this::isRequiredForRendering);
    }

    public boolean isRequiredForRendering(IStateEntryInfo stateEntryInfo) {
        return this.isRequiredForRendering(stateEntryInfo.getBlockInformation());
    }

    public boolean isRequiredForRendering(BlockInformation state) {
        if (!this.type.isValidBlockState(state)) {
            return false;
        }
        if (this.type.isFluid()) {
            return IRenderTypeManager.getInstance().canRenderInType(state.getBlockState().m_60819_(), this.layer);
        }
        return IRenderTypeManager.getInstance().canRenderInType(state.getBlockState(), this.layer);
    }

    public static ChiselRenderType fromLayer(RenderType layerInfo, boolean isFluid) {
        if (layerInfo == null) {
            layerInfo = RenderType.m_110451_();
        }
        if (ChiselRenderType.CUTOUT.layer.equals(layerInfo)) {
            return CUTOUT;
        }
        if (ChiselRenderType.CUTOUT_MIPPED.layer.equals(layerInfo)) {
            return CUTOUT_MIPPED;
        }
        if (ChiselRenderType.SOLID.layer.equals(layerInfo)) {
            return isFluid ? SOLID_FLUID : SOLID;
        }
        if (ChiselRenderType.TRANSLUCENT.layer.equals(layerInfo)) {
            return isFluid ? TRANSLUCENT_FLUID : TRANSLUCENT;
        }
        if (ChiselRenderType.TRIPWIRE.layer.equals(layerInfo)) {
            return TRIPWIRE;
        }
        throw new InvalidParameterException();
    }

    public static Collection<ChiselRenderType> getRenderTypes(VoxelType voxelType) {
        return TYPED_RENDER_TYPES.get((Object)voxelType);
    }

    public ICullTest getTest() {
        return new MCCullTest();
    }

    static {
        TYPED_RENDER_TYPES = HashMultimap.create();
        for (ChiselRenderType value : ChiselRenderType.values()) {
            TYPED_RENDER_TYPES.put((Object)value.type, (Object)value);
        }
    }
}

