/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.model.baked.bit;

import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import mod.chiselsandbits.api.blockinformation.BlockInformation;
import mod.chiselsandbits.client.model.baked.base.BaseBakedBlockModel;
import mod.chiselsandbits.client.model.baked.face.FaceManager;
import mod.chiselsandbits.client.model.baked.face.model.ModelQuadLayer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BitBlockBakedModel
extends BaseBakedBlockModel {
    public static final float PIXELS_PER_BLOCK = 16.0f;
    private static final float BIT_BEGIN = 6.0f;
    private static final float BIT_END = 10.0f;
    final List<BakedQuad> generic = new ArrayList<BakedQuad>(6);

    public BitBlockBakedModel(BlockInformation blockInformation) {
        FaceBakery faceBakery = new FaceBakery();
        Vector3f to = new Vector3f(6.0f, 6.0f, 6.0f);
        Vector3f from = new Vector3f(10.0f, 10.0f, 10.0f);
        BlockModelRotation mr = BlockModelRotation.X0_Y0;
        for (Direction myFace : Direction.values()) {
            for (RenderType layer : RenderType.m_110506_()) {
                ModelQuadLayer[] layers = FaceManager.getInstance().getCachedFace(blockInformation, myFace, layer, 0L);
                if (layers == null || layers.length == 0) continue;
                for (ModelQuadLayer quadLayer : layers) {
                    Vector3f toB;
                    BlockFaceUV uv = new BlockFaceUV(this.getFaceUvs(myFace), 0);
                    BlockElementFace bpf = new BlockElementFace(myFace, 0, "", uv);
                    this.generic.add(faceBakery.m_111600_(toB, switch (myFace) {
                        case Direction.UP -> {
                            toB = new Vector3f(to.m_122239_(), from.m_122260_(), to.m_122269_());
                            yield new Vector3f(from.m_122239_(), from.m_122260_(), from.m_122269_());
                        }
                        case Direction.EAST -> {
                            toB = new Vector3f(from.m_122239_(), to.m_122260_(), to.m_122269_());
                            yield new Vector3f(from.m_122239_(), from.m_122260_(), from.m_122269_());
                        }
                        case Direction.NORTH -> {
                            toB = new Vector3f(to.m_122239_(), to.m_122260_(), to.m_122269_());
                            yield new Vector3f(from.m_122239_(), from.m_122260_(), to.m_122269_());
                        }
                        case Direction.SOUTH -> {
                            toB = new Vector3f(to.m_122239_(), to.m_122260_(), from.m_122269_());
                            yield new Vector3f(from.m_122239_(), from.m_122260_(), from.m_122269_());
                        }
                        case Direction.DOWN -> {
                            toB = new Vector3f(to.m_122239_(), to.m_122260_(), to.m_122269_());
                            yield new Vector3f(from.m_122239_(), to.m_122260_(), from.m_122269_());
                        }
                        case Direction.WEST -> {
                            toB = new Vector3f(to.m_122239_(), to.m_122260_(), to.m_122269_());
                            yield new Vector3f(to.m_122239_(), from.m_122260_(), from.m_122269_());
                        }
                        default -> throw new NullPointerException();
                    }, bpf, quadLayer.getSprite(), myFace, (ModelState)mr, null, false, new ResourceLocation("chiselsandbits", "bit")));
                }
            }
        }
    }

    private float[] getFaceUvs(Direction face) {
        float[] fArray;
        int from_x = 7;
        int from_y = 7;
        int from_z = 7;
        int to_x = 8;
        int to_y = 8;
        int to_z = 8;
        switch (face) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case UP: 
            case DOWN: {
                float[] fArray2 = new float[4];
                fArray2[0] = 7.0f;
                fArray2[1] = 7.0f;
                fArray2[2] = 8.0f;
                fArray = fArray2;
                fArray2[3] = 8.0f;
                break;
            }
            case NORTH: 
            case SOUTH: {
                float[] fArray3 = new float[4];
                fArray3[0] = 7.0f;
                fArray3[1] = 8.0f;
                fArray3[2] = 8.0f;
                fArray = fArray3;
                fArray3[3] = 9.0f;
                break;
            }
            case EAST: 
            case WEST: {
                float[] fArray4 = new float[4];
                fArray4[0] = 7.0f;
                fArray4[1] = 8.0f;
                fArray4[2] = 8.0f;
                fArray = fArray4;
                fArray4[3] = 9.0f;
            }
        }
        float[] afloat = fArray;
        return afloat;
    }

    @NotNull
    public List<BakedQuad> m_6840_(@Nullable BlockState state, @Nullable Direction side, @NotNull Random rand) {
        if (side != null) {
            return Collections.emptyList();
        }
        return this.generic;
    }

    public boolean m_7547_() {
        return true;
    }

    @NotNull
    public TextureAtlasSprite m_6160_() {
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(MissingTextureAtlasSprite.m_118071_());
    }
}

