/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.block.entities.storage;

import com.google.common.collect.Maps;
import com.google.common.math.LongMath;
import com.mojang.datafixers.util.Pair;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.function.BiConsumer;
import mod.chiselsandbits.api.block.storage.IStateEntryStorage;
import mod.chiselsandbits.api.blockinformation.BlockInformation;
import mod.chiselsandbits.api.config.IServerConfiguration;
import mod.chiselsandbits.api.multistate.StateEntrySize;
import mod.chiselsandbits.api.util.BlockPosStreamProvider;
import mod.chiselsandbits.api.util.VectorUtils;
import mod.chiselsandbits.block.entities.storage.SimpleStateEntryPalette;
import mod.chiselsandbits.utils.ByteArrayUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class SimpleStateEntryStorage
implements IStateEntryStorage {
    private final int size;
    private final SimpleStateEntryPalette palette;
    private BitSet data = new BitSet();
    private int entryWidth = 0;
    private boolean isDeserializing = false;

    public SimpleStateEntryStorage() {
        this(IServerConfiguration.getInstance().getBitSize().get().getBitsPerBlockSide());
    }

    private SimpleStateEntryStorage(SimpleStateEntryStorage stateEntryStorage) {
        this.size = stateEntryStorage.size;
        this.palette = new SimpleStateEntryPalette(this::onPaletteResize, stateEntryStorage.palette);
        this.data = BitSet.valueOf(stateEntryStorage.getData().toLongArray());
        this.entryWidth = stateEntryStorage.entryWidth;
    }

    public SimpleStateEntryStorage(int size) {
        this.size = size;
        this.palette = new SimpleStateEntryPalette(this::onPaletteResize);
    }

    @Override
    public int getSize() {
        return this.size;
    }

    private int getTotalEntryCount() {
        return this.size * this.size * this.size;
    }

    @Override
    public void clear() {
        this.data = new BitSet();
        this.entryWidth = 0;
        this.palette.clear();
    }

    private void resetData() {
        this.data = new BitSet();
    }

    @Override
    public void initializeWith(BlockInformation currentState) {
        this.clear();
        if (currentState.getBlockState() == Blocks.f_50016_.m_49966_()) {
            return;
        }
        int blockStateId = this.palette.getIndex(currentState);
        this.data = ByteArrayUtils.fill(blockStateId, this.entryWidth, this.getTotalEntryCount());
    }

    @Override
    public void loadFromChunkSection(LevelChunkSection chunkSection) {
        if (this.size != StateEntrySize.ONE_SIXTEENTH.getBitsPerBlockSide()) {
            throw new IllegalStateException("Updating to the new storage format is only possible on the default 1/16th size.");
        }
        this.clear();
        BlockPosStreamProvider.getForRange(StateEntrySize.ONE_SIXTEENTH.getBitsPerBlockSide()).forEach(position -> this.setBlockInformation(position.m_123341_(), position.m_123342_(), position.m_123343_(), new BlockInformation(chunkSection.m_62982_(position.m_123341_(), position.m_123342_(), position.m_123343_()))));
    }

    @Override
    public BlockInformation getBlockInformation(int x, int y, int z) {
        int offSetIndex = this.doCalculatePositionIndex(x, y, z);
        int blockStateId = ByteArrayUtils.getValueAt(this.data, this.entryWidth, offSetIndex);
        return this.palette.getBlockState(blockStateId);
    }

    @Override
    public void setBlockInformation(int x, int y, int z, BlockInformation blockState) {
        int offSetIndex = this.doCalculatePositionIndex(x, y, z);
        int blockStateId = this.palette.getIndex(blockState);
        this.ensureCapacity();
        ByteArrayUtils.setValueAt(this.data, blockStateId, this.entryWidth, offSetIndex);
    }

    private void ensureCapacity() {
        int requiredSize = (int)Math.ceil((float)(this.getTotalEntryCount() * this.entryWidth) / 8.0f);
        if (this.data.length() < requiredSize) {
            byte[] rawData = this.getRawData();
            byte[] newData = new byte[requiredSize];
            System.arraycopy(rawData, 0, newData, 0, rawData.length);
            this.data = BitSet.valueOf(newData);
        }
    }

    private int doCalculatePositionIndex(int x, int y, int z) {
        return x * this.size * this.size + y * this.size + z;
    }

    private Vec3i doCalculatePosition(int index) {
        int x = index / (this.size * this.size);
        int y = (index - x * this.size * this.size) / this.size;
        int z = index - x * this.size * this.size - y * this.size;
        return new Vec3i(x, y, z);
    }

    @Override
    public void count(BiConsumer<BlockInformation, Integer> storageConsumer) {
        HashMap countMap = Maps.newHashMap();
        BlockPosStreamProvider.getForRange(this.getSize()).map(position -> this.getBlockInformation(position.m_123341_(), position.m_123342_(), position.m_123343_())).forEach(blockState -> countMap.compute(blockState, (state, count) -> count == null ? 1 : count + 1));
        countMap.forEach(storageConsumer);
    }

    public BitSet getData() {
        return this.data;
    }

    @Override
    public byte[] getRawData() {
        return this.data.toByteArray();
    }

    @Override
    public IStateEntryStorage createSnapshot() {
        return new SimpleStateEntryStorage(this);
    }

    @Override
    public void fillFromBottom(BlockInformation state, int entries) {
        this.clear();
        int loopCount = Math.max(0, Math.min(entries, StateEntrySize.current().getBitsPerBlock()));
        if (loopCount == 0) {
            return;
        }
        int count = 0;
        for (int y = 0; y < this.getSize(); ++y) {
            for (int x = 0; x < this.getSize(); ++x) {
                for (int z = 0; z < this.getSize(); ++z) {
                    this.setBlockInformation(x, y, z, state);
                    if (++count != loopCount) continue;
                    return;
                }
            }
        }
    }

    @Override
    public List<BlockInformation> getContainedPalette() {
        return this.palette.getStates();
    }

    @Override
    public void rotate(Direction.Axis axis, int rotationCount) {
        if (rotationCount == 0) {
            return;
        }
        IStateEntryStorage clone = this.createSnapshot();
        this.resetData();
        Vec3 centerVector = new Vec3(7.5, 7.5, 7.5);
        for (int x = 0; x < 16; ++x) {
            for (int y = 0; y < 16; ++y) {
                for (int z = 0; z < 16; ++z) {
                    Vec3 workingVector = new Vec3((double)x, (double)y, (double)z);
                    Vec3 rotatedVector = workingVector.m_82546_(centerVector);
                    for (int i = 0; i < rotationCount; ++i) {
                        rotatedVector = VectorUtils.rotate90Degrees(rotatedVector, axis);
                    }
                    BlockPos sourcePos = new BlockPos(workingVector);
                    Vec3 offsetPos = rotatedVector.m_82549_(centerVector).m_82542_(1000.0, 1000.0, 1000.0);
                    BlockPos targetPos = new BlockPos(new Vec3((double)Math.round(offsetPos.m_7096_()), (double)Math.round(offsetPos.m_7098_()), (double)Math.round(offsetPos.m_7094_())).m_82542_(0.001, 0.001, 0.001));
                    this.setBlockInformation(targetPos.m_123341_(), targetPos.m_123342_(), targetPos.m_123343_(), clone.getBlockInformation(sourcePos.m_123341_(), sourcePos.m_123342_(), sourcePos.m_123343_()));
                }
            }
        }
    }

    @Override
    public void mirror(Direction.Axis axis) {
        IStateEntryStorage clone = this.createSnapshot();
        this.resetData();
        for (int y = 0; y < this.getSize(); ++y) {
            for (int x = 0; x < this.getSize(); ++x) {
                for (int z = 0; z < this.getSize(); ++z) {
                    BlockInformation blockInformation = clone.getBlockInformation(x, y, z);
                    int mirroredX = axis == Direction.Axis.X ? this.getSize() - x - 1 : x;
                    int mirroredY = axis == Direction.Axis.Y ? this.getSize() - y - 1 : y;
                    int mirroredZ = axis == Direction.Axis.Z ? this.getSize() - z - 1 : z;
                    this.setBlockInformation(mirroredX, mirroredY, mirroredZ, blockInformation);
                }
            }
        }
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag result = new CompoundTag();
        result.m_128365_("palette", (Tag)this.palette.serializeNBT());
        result.m_128382_("data", this.getRawData());
        return result;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        this.clear();
        this.isDeserializing = true;
        this.palette.deserializeNBT((ListTag)nbt.m_128423_("palette"));
        this.data = BitSet.valueOf(nbt.m_128463_("data"));
        HashSet<BlockInformation> containedStates = new HashSet<BlockInformation>();
        for (int i = 0; i < this.getTotalEntryCount(); ++i) {
            Vec3i pos = this.doCalculatePosition(i);
            BlockInformation blockState = this.getBlockInformation(pos);
            containedStates.add(blockState);
        }
        ArrayList<BlockInformation> paletteStates = new ArrayList<BlockInformation>(this.palette.getStates());
        paletteStates.removeAll(containedStates);
        paletteStates.remove(new BlockInformation(Blocks.f_50016_.m_49966_()));
        this.isDeserializing = false;
        this.palette.sanitize(paletteStates);
    }

    @Override
    public void serializeInto(@NotNull FriendlyByteBuf packetBuffer) {
        this.palette.serializeInto(packetBuffer);
        packetBuffer.m_130087_(this.data.toByteArray());
    }

    @Override
    public void deserializeFrom(@NotNull FriendlyByteBuf packetBuffer) {
        this.clear();
        this.isDeserializing = true;
        this.palette.deserializeFrom(packetBuffer);
        this.data = BitSet.valueOf(packetBuffer.m_130052_());
        this.isDeserializing = false;
    }

    private void onPaletteResize(int newSize) {
        int currentEntryWidth = this.entryWidth;
        this.entryWidth = LongMath.log2((long)newSize, (RoundingMode)RoundingMode.CEILING);
        if (!this.isDeserializing && this.entryWidth != currentEntryWidth) {
            BitSet rawData = BitSet.valueOf(this.data.toLongArray());
            this.data = new BitSet(this.getTotalEntryCount() * this.entryWidth);
            BlockPosStreamProvider.getForRange(this.getSize()).mapToInt(pos -> this.doCalculatePositionIndex(pos.m_123341_(), pos.m_123342_(), pos.m_123343_())).mapToObj(index -> Pair.of((Object)index, (Object)ByteArrayUtils.getValueAt(rawData, currentEntryWidth, index))).forEach(pair -> ByteArrayUtils.setValueAt(this.data, (Integer)pair.getSecond(), this.entryWidth, (Integer)pair.getFirst()));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SimpleStateEntryStorage)) {
            return false;
        }
        SimpleStateEntryStorage that = (SimpleStateEntryStorage)o;
        if (this.entryWidth != that.entryWidth) {
            return false;
        }
        if (!this.palette.equals(that.palette)) {
            return false;
        }
        return this.getData().equals(that.getData());
    }

    public int hashCode() {
        int result = this.palette.hashCode();
        result = 31 * result + this.getData().hashCode();
        result = 31 * result + this.entryWidth;
        return result;
    }

    public String toString() {
        return "SimpleStateEntryStorage{palette=" + this.palette + ", data=" + this.data + ", entryWidth=" + this.entryWidth + "}";
    }
}

