/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.block;

import java.util.Objects;
import java.util.Optional;
import mod.chiselsandbits.ChiselsAndBits;
import mod.chiselsandbits.api.axissize.CollisionType;
import mod.chiselsandbits.api.block.IMultiStateBlock;
import mod.chiselsandbits.api.block.entity.IMultiStateBlockEntity;
import mod.chiselsandbits.api.blockinformation.BlockInformation;
import mod.chiselsandbits.api.change.IChangeTrackerManager;
import mod.chiselsandbits.api.chiseling.eligibility.IEligibilityManager;
import mod.chiselsandbits.api.config.IClientConfiguration;
import mod.chiselsandbits.api.config.IServerConfiguration;
import mod.chiselsandbits.api.exceptions.SpaceOccupiedException;
import mod.chiselsandbits.api.item.multistate.IMultiStateItemFactory;
import mod.chiselsandbits.api.item.multistate.IMultiStateItemStack;
import mod.chiselsandbits.api.multistate.StateEntrySize;
import mod.chiselsandbits.api.multistate.accessor.IAreaAccessor;
import mod.chiselsandbits.api.multistate.accessor.IStateEntryInfo;
import mod.chiselsandbits.api.multistate.mutator.IMutableStateEntryInfo;
import mod.chiselsandbits.api.multistate.mutator.batched.IBatchMutation;
import mod.chiselsandbits.api.multistate.snapshot.IMultiStateSnapshot;
import mod.chiselsandbits.api.util.ArrayUtils;
import mod.chiselsandbits.api.util.SingleBlockBlockReader;
import mod.chiselsandbits.api.util.SingleBlockWorldReader;
import mod.chiselsandbits.api.variant.state.IStateVariant;
import mod.chiselsandbits.api.variant.state.IStateVariantManager;
import mod.chiselsandbits.api.voxelshape.IVoxelShapeManager;
import mod.chiselsandbits.block.entities.ChiseledBlockEntity;
import mod.chiselsandbits.client.model.data.ChiseledBlockModelDataManager;
import mod.chiselsandbits.clipboard.CreativeClipboardUtils;
import mod.chiselsandbits.network.packets.NeighborBlockUpdatedPacket;
import mod.chiselsandbits.platforms.core.block.IBlockWithWorldlyProperties;
import mod.chiselsandbits.platforms.core.blockstate.ILevelBasedPropertyAccessor;
import mod.chiselsandbits.platforms.core.dist.Dist;
import mod.chiselsandbits.platforms.core.dist.DistExecutor;
import mod.chiselsandbits.platforms.core.entity.IPlayerInventoryManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChiseledBlock
extends Block
implements IMultiStateBlock,
SimpleWaterloggedBlock,
IBlockWithWorldlyProperties {
    public ChiseledBlock(BlockBehaviour.Properties properties) {
        super(properties.m_60971_(ChiseledBlock::isViewBlocking).m_60955_());
    }

    private static boolean isViewBlocking(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return false;
    }

    @Override
    public float getFriction(BlockState state, LevelReader levelReader, BlockPos pos, @Nullable Entity entity) {
        float frictionValue = ChiseledBlock.getBlockEntity((BlockGetter)levelReader, pos).map(multiStateBlockEntity -> Float.valueOf(multiStateBlockEntity.getStatistics().getSlipperiness())).orElse(Float.valueOf(0.0f)).floatValue();
        return Float.isNaN(frictionValue) || frictionValue <= 1.0E-4f ? 0.6f : frictionValue;
    }

    @Override
    public int getLightEmission(BlockState state, BlockGetter blockGetter, BlockPos pos) {
        return ChiseledBlock.getBlockEntity(blockGetter, pos).map(multiStateBlockEntity -> Float.valueOf((float)blockGetter.m_7469_() * multiStateBlockEntity.getStatistics().getLightEmissionFactor())).map(inertValue -> (double)inertValue.floatValue() * IServerConfiguration.getInstance().getLightFactorMultiplier().get()).map(consumedValue -> Math.max(consumedValue, 0.0)).map(consumedValue -> Math.min(consumedValue, (double)blockGetter.m_7469_())).orElse(0.0).intValue();
    }

    @Override
    public boolean canHarvestBlock(BlockState state, BlockGetter blockGetter, BlockPos pos, Player player) {
        return ChiseledBlock.getBlockEntity(blockGetter, pos).map(e -> {
            BlockInformation primaryState = e.getStatistics().getPrimaryState();
            return ILevelBasedPropertyAccessor.getInstance().canHarvestBlock(new SingleBlockBlockReader(primaryState, pos, blockGetter), pos, player);
        }).orElse(true);
    }

    @Override
    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter blockGetter, BlockPos pos, Player player) {
        if (!(target instanceof BlockHitResult)) {
            return ItemStack.f_41583_;
        }
        BlockHitResult blockRayTraceResult = (BlockHitResult)target;
        if (!IClientConfiguration.getInstance().getInvertPickBlockBehaviour().get().booleanValue() && player.m_6047_() || IClientConfiguration.getInstance().getInvertPickBlockBehaviour().get().booleanValue() && !player.m_6047_()) {
            return ChiseledBlock.getBlockEntity(blockGetter, pos).map(e -> {
                IMultiStateSnapshot snapshot = e.createSnapshot();
                IMultiStateItemStack multiStateItemStack = snapshot.toItemStack();
                DistExecutor.unsafeRunWhenOn(Dist.CLIENT, () -> () -> CreativeClipboardUtils.addPickedBlock(multiStateItemStack));
                return multiStateItemStack.toBlockStack();
            }).orElse(ItemStack.f_41583_);
        }
        return ChiseledBlock.getBlockEntity(blockGetter, pos).flatMap(e -> {
            Vec3 hitVec = blockRayTraceResult.m_82450_();
            BlockPos blockPos = blockRayTraceResult.m_82425_();
            Vec3 accuratePos = new Vec3((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_());
            Vec3 faceOffset = new Vec3((double)((float)blockRayTraceResult.m_82434_().m_122424_().m_122429_() * StateEntrySize.current().getSizePerHalfBit()), (double)((float)blockRayTraceResult.m_82434_().m_122424_().m_122430_() * StateEntrySize.current().getSizePerHalfBit()), (double)((float)blockRayTraceResult.m_82434_().m_122424_().m_122431_() * StateEntrySize.current().getSizePerHalfBit()));
            Vec3 hitDelta = hitVec.m_82546_(accuratePos).m_82549_(faceOffset);
            try {
                return e.getInAreaTarget(hitDelta);
            }
            catch (IllegalArgumentException exception) {
                return Optional.empty();
            }
        }).map(targetedStateEntry -> IMultiStateItemFactory.getInstance().createBlockFrom((IStateEntryInfo)targetedStateEntry)).orElseGet(() -> ChiseledBlock.getBlockEntity(blockGetter, pos).map(e -> {
            IMultiStateSnapshot snapshot = e.createSnapshot();
            return snapshot.toItemStack().toBlockStack();
        }).orElse(ItemStack.f_41583_));
    }

    @Override
    public BlockState rotate(BlockState state, LevelAccessor levelAccessor, BlockPos pos, Rotation rotation) {
        for (Direction.Axis axis : Direction.Axis.values()) {
            if (!rotation.m_55948_().m_56526_(axis)) continue;
            ChiseledBlock.getBlockEntity((BlockGetter)levelAccessor, pos).ifPresent(e -> e.rotate(axis));
            return state;
        }
        return state;
    }

    @Override
    public boolean shouldCheckWeakPower(BlockState state, LevelReader levelReader, BlockPos pos, Direction side) {
        return ChiseledBlock.getBlockEntity((BlockGetter)levelReader, pos).map(multiStateBlockEntity -> multiStateBlockEntity.getStatistics().shouldCheckWeakPower()).orElse(false);
    }

    @Override
    public boolean shouldDisplayFluidOverlay(BlockState state, BlockAndTintGetter blockAndTintGetter, BlockPos pos, FluidState fluidState) {
        return true;
    }

    @NotNull
    private static Optional<IMultiStateBlockEntity> getBlockEntity(BlockGetter worldIn, BlockPos pos) {
        BlockEntity tileEntity = worldIn.m_7702_(pos);
        if (!(tileEntity instanceof IMultiStateBlockEntity)) {
            return Optional.empty();
        }
        return Optional.of((IMultiStateBlockEntity)tileEntity);
    }

    public boolean m_7420_(@NotNull BlockState state, @NotNull BlockGetter reader, @NotNull BlockPos pos) {
        return ChiseledBlock.getBlockEntity(reader, pos).map(multiStateBlockEntity -> multiStateBlockEntity.getStatistics().canPropagateSkylight()).orElse(false);
    }

    public boolean m_7923_(@NotNull BlockState blockState) {
        return true;
    }

    public void m_6240_(@NotNull Level worldIn, @NotNull Player player, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable BlockEntity te, @NotNull ItemStack stack) {
        if (te instanceof IMultiStateBlockEntity) {
            IMultiStateBlockEntity multiStateBlockEntity = (IMultiStateBlockEntity)te;
            IMultiStateSnapshot snapshot = multiStateBlockEntity.createSnapshot();
            ChiseledBlock.m_49840_((Level)worldIn, (BlockPos)pos, (ItemStack)snapshot.toItemStack().toBlockStack());
        }
    }

    public void m_6402_(@NotNull Level worldIn, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity placer, @NotNull ItemStack stack) {
        ChiseledBlock.getBlockEntity((BlockGetter)worldIn, pos).ifPresent(multiStateBlockEntity -> {
            Direction placementDirection = placer == null ? Direction.NORTH : placer.m_6350_().m_122424_();
            int horizontalIndex = placementDirection.m_122416_();
            int rotationCount = horizontalIndex - 4;
            if (rotationCount < 0) {
                rotationCount += 4;
            }
            multiStateBlockEntity.rotate(Direction.Axis.Y, rotationCount);
            super.m_6402_(worldIn, pos, state, placer, stack);
        });
    }

    public void m_49811_(@NotNull CreativeModeTab group, @NotNull NonNullList<ItemStack> items) {
    }

    public boolean m_49967_() {
        return true;
    }

    @Override
    @NotNull
    public BlockInformation getPrimaryState(@NotNull BlockGetter world, @NotNull BlockPos pos) {
        return ChiseledBlock.getBlockEntity(world, pos).map(e -> e.getStatistics().getPrimaryState()).orElse(BlockInformation.AIR);
    }

    public void m_6810_(@NotNull BlockState state, @NotNull Level worldIn, @NotNull BlockPos pos, BlockState newState, boolean isMoving) {
        if (newState.m_60734_() instanceof ChiseledBlock) {
            return;
        }
        super.m_6810_(state, worldIn, pos, newState, isMoving);
    }

    @NotNull
    public PushReaction m_5537_(@NotNull BlockState state) {
        return PushReaction.BLOCK;
    }

    public boolean m_6864_(@NotNull BlockState state, BlockPlaceContext useContext) {
        return ChiseledBlock.getBlockEntity((BlockGetter)useContext.m_43725_(), useContext.m_8083_()).map(multiStateBlockEntity -> multiStateBlockEntity.getStatistics().isEmptyBlock()).orElse(true);
    }

    @NotNull
    public VoxelShape m_7947_(@NotNull BlockState state, @NotNull BlockGetter reader, @NotNull BlockPos pos) {
        VoxelShape shape = ChiseledBlock.getBlockEntity(reader, pos).map(multiStateBlockEntity -> IVoxelShapeManager.getInstance().get((IAreaAccessor)multiStateBlockEntity, CollisionType.COLLIDEABLE_ONLY)).orElse(Shapes.m_83040_());
        return shape.m_83281_() ? Shapes.m_83144_() : shape;
    }

    public float m_7749_(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos) {
        return ChiseledBlock.getBlockEntity(worldIn, pos).map(b -> b.getStatistics().isFullBlock()).map(f -> Float.valueOf(f != false ? 0.2f : 1.0f)).orElse(Float.valueOf(1.0f)).floatValue();
    }

    public int m_7753_(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos) {
        return ChiseledBlock.getBlockEntity(worldIn, pos).map(multiStateBlockEntity -> Float.valueOf(multiStateBlockEntity.getStatistics().getLightBlockingFactor())).map(consumedValue -> Float.valueOf(Math.max(consumedValue.floatValue(), 0.0f))).map(consumedValue -> Float.valueOf(Math.min(consumedValue.floatValue(), (float)worldIn.m_7469_()))).orElse(Float.valueOf(0.0f)).intValue();
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        VoxelShape shape = ChiseledBlock.getBlockEntity(worldIn, pos).map(multiStateBlockEntity -> IVoxelShapeManager.getInstance().get((IAreaAccessor)multiStateBlockEntity)).orElse(Shapes.m_83040_());
        return shape.m_83281_() ? Shapes.m_83144_() : shape;
    }

    @NotNull
    public VoxelShape m_5939_(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        VoxelShape shape = ChiseledBlock.getBlockEntity(worldIn, pos).map(multiStateBlockEntity -> IVoxelShapeManager.getInstance().get((IAreaAccessor)multiStateBlockEntity, CollisionType.COLLIDEABLE_ONLY)).orElse(Shapes.m_83040_());
        if (shape.m_83281_()) {
            boolean justFluids = ChiseledBlock.getBlockEntity(worldIn, pos).map(IAreaAccessor::stream).map(stream -> stream.allMatch(stateEntry -> stateEntry.getBlockInformation().isAir() || !stateEntry.getBlockInformation().getBlockState().m_60819_().m_76178_())).orElse(false);
            return justFluids ? shape : Shapes.m_83144_();
        }
        return shape;
    }

    @NotNull
    public VoxelShape m_5909_(@NotNull BlockState state, @NotNull BlockGetter reader, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return this.m_5940_(state, reader, pos, context);
    }

    public float m_5880_(@NotNull BlockState state, @NotNull Player player, @NotNull BlockGetter worldIn, @NotNull BlockPos pos) {
        return ChiseledBlock.getBlockEntity(worldIn, pos).map(multiStateBlockEntity -> Float.valueOf(multiStateBlockEntity.getStatistics().getRelativeBlockHardness(player))).orElse(Float.valueOf(1.0f)).floatValue();
    }

    public boolean m_6044_(@NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull BlockState state, Fluid fluidIn) {
        return IEligibilityManager.getInstance().canBeChiseled(fluidIn.m_76145_().m_76188_());
    }

    public boolean m_7361_(@NotNull LevelAccessor worldIn, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull FluidState fluidStateIn) {
        if (fluidStateIn == null || fluidStateIn.m_76188_() == null) {
            return false;
        }
        return ChiseledBlock.getBlockEntity((BlockGetter)worldIn, pos).map(entity -> {
            try (IBatchMutation ignored = entity.batch();){
                entity.mutableStream().forEach(stateEntry -> {
                    if (stateEntry.getBlockInformation().isAir()) {
                        BlockState blockState = fluidStateIn.m_76188_();
                        Optional<IStateVariant> additionalStateInfo = IStateVariantManager.getInstance().getStateVariant(fluidStateIn);
                        try {
                            stateEntry.setBlockInformation(new BlockInformation(blockState, additionalStateInfo));
                        }
                        catch (SpaceOccupiedException spaceOccupiedException) {
                            // empty catch block
                        }
                    }
                });
            }
            return true;
        }).orElse(false);
    }

    @NotNull
    public ItemStack m_142598_(@NotNull LevelAccessor p_154560_, @NotNull BlockPos p_154561_, @NotNull BlockState p_154562_) {
        return ItemStack.f_41583_;
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new ChiseledBlockEntity(pos, state);
    }

    public void m_6861_(@NotNull BlockState state, Level level, @NotNull BlockPos position, @NotNull Block block, @NotNull BlockPos otherPosition, boolean update) {
        BlockEntity tileEntity = level.m_7702_(position);
        if (level.m_5776_() && tileEntity instanceof ChiseledBlockEntity) {
            ChiseledBlockModelDataManager.getInstance().updateModelData((ChiseledBlockEntity)tileEntity);
        } else if (!level.m_5776_() && tileEntity instanceof ChiseledBlockEntity) {
            ChiselsAndBits.getInstance().getNetworkChannel().sendToTrackingChunk(new NeighborBlockUpdatedPacket(position, otherPosition), level.m_46745_(position));
        }
    }

    @Override
    public float[] getBeaconColorMultiplier(BlockState state, LevelReader levelReader, BlockPos pos, BlockPos beaconPos) {
        return ChiseledBlock.getBlockEntity((BlockGetter)levelReader, pos).filter(e -> e.getStatistics().getStateCounts().keySet().stream().filter(entryState -> !entryState.isAir()).allMatch(entryState -> ILevelBasedPropertyAccessor.getInstance().getBeaconColorMultiplier(new SingleBlockWorldReader(e.getStatistics().getPrimaryState(), pos, levelReader), pos, beaconPos) != null)).flatMap(e -> e.getStatistics().getStateCounts().entrySet().stream().filter(entryState -> !((BlockInformation)entryState.getKey()).isAir()).map(entryState -> ArrayUtils.multiply(ILevelBasedPropertyAccessor.getInstance().getBeaconColorMultiplier(new SingleBlockWorldReader((BlockInformation)entryState.getKey(), pos, levelReader), pos, beaconPos), ((Integer)entryState.getValue()).intValue())).reduce((floats, floats2) -> {
            if (((float[])floats).length != ((float[])floats2).length) {
                return null;
            }
            if (floats == null) {
                return null;
            }
            if (floats2 == null) {
                return null;
            }
            float[] result = new float[((float[])floats).length];
            for (int i = 0; i < ((float[])floats).length; ++i) {
                result[i] = floats[i] + floats2[i];
            }
            return result;
        }).filter(Objects::nonNull).flatMap(summedResult -> ChiseledBlock.getBlockEntity((BlockGetter)levelReader, pos).map(entity -> ArrayUtils.multiply(summedResult, 1.0f / (entity.getStatistics().getFullnessFactor() * (float)StateEntrySize.current().getBitsPerBlock()))))).orElse(null);
    }

    @Override
    public SoundType getSoundType(BlockState state, LevelReader levelReader, BlockPos pos, @Nullable Entity entity) {
        return ChiseledBlock.getBlockEntity((BlockGetter)levelReader, pos).map(blockEntity -> blockEntity.getStatistics().getPrimaryState()).map(blockState -> ILevelBasedPropertyAccessor.getInstance().getSoundType(new SingleBlockWorldReader((BlockInformation)blockState, pos, levelReader), pos, entity)).orElse(SoundType.f_56742_);
    }

    @Override
    public float getExplosionResistance(BlockState state, BlockGetter blockGetter, BlockPos position, Explosion explosion) {
        return (float)ChiseledBlock.getBlockEntity(blockGetter, position).map(e -> e.getStatistics().getStateCounts().entrySet().stream().filter(entryState -> !((BlockInformation)entryState.getKey()).isAir()).mapToDouble(entryState -> ILevelBasedPropertyAccessor.getInstance().getExplosionResistance(new SingleBlockBlockReader((BlockInformation)entryState.getKey(), position, blockGetter), position, explosion) * (float)((Integer)entryState.getValue()).intValue()).sum() / (double)(e.getStatistics().getFullnessFactor() * (float)StateEntrySize.current().getBitsPerBlock())).orElse(0.0).doubleValue();
    }

    public void m_5707_(@NotNull Level level, @NotNull BlockPos blockPos, @NotNull BlockState blockState, @NotNull Player player) {
        ChiseledBlock.getBlockEntity((BlockGetter)level, blockPos).map(IAreaAccessor::createSnapshot).map(IMultiStateSnapshot::toItemStack).ifPresent(multiStateItemStack -> DistExecutor.unsafeRunWhenOn(Dist.CLIENT, () -> () -> CreativeClipboardUtils.addBrokenBlock(multiStateItemStack)));
    }

    @Override
    public boolean canBeGrass(LevelReader levelReader, BlockState grassState, BlockPos grassBlockPos, BlockState targetState, BlockPos targetPosition) {
        return ChiseledBlock.getBlockEntity((BlockGetter)levelReader, targetPosition).map(blockEntity -> blockEntity.getStatistics().canSustainGrassBelow()).orElse(false);
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState blockState, @NotNull Level level, @NotNull BlockPos blockPos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult blockHitResult) {
        ItemStack itemStack = player.m_21120_(hand);
        if (itemStack.m_150930_(Items.f_41902_)) {
            return ChiseledBlock.getBlockEntity((BlockGetter)level, blockPos).map(blockEntity -> {
                try (IBatchMutation mutation = blockEntity.batch(IChangeTrackerManager.getInstance().getChangeTracker(player));){
                    Long l = blockEntity.mutableStream().filter(entry -> !entry.getBlockInformation().getBlockState().m_60819_().m_76178_()).peek(IMutableStateEntryInfo::clear).count();
                    return l;
                }
            }).map(count -> {
                if (count > 0L) {
                    itemStack.m_41774_(1);
                    IPlayerInventoryManager.getInstance().giveToPlayer(player, new ItemStack((ItemLike)Items.f_41903_));
                }
                return count > 0L ? InteractionResult.SUCCESS : InteractionResult.PASS;
            }).orElse(InteractionResult.PASS);
        }
        return InteractionResult.PASS;
    }
}

