/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.util;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackItem;
import net.p3pp3rf1y.sophisticatedbackpacks.util.PlayerInventoryHandler;

public class PlayerInventoryProvider {
    public static final String MAIN_INVENTORY = "main";
    public static final String OFFHAND_INVENTORY = "offhand";
    public static final String ARMOR_INVENTORY = "armor";
    private final Map<String, PlayerInventoryHandler> playerInventoryHandlers = new LinkedHashMap<String, PlayerInventoryHandler>();
    private final List<String> renderedHandlers = new ArrayList<String>();
    private boolean playerInventoryHandlersInitialized = false;
    private Consumer<Player> playerInventoryHandlerInitCallback = player -> {};
    private static final PlayerInventoryProvider serverProvider = new PlayerInventoryProvider();
    private static final PlayerInventoryProvider clientProvider = new PlayerInventoryProvider();

    public static PlayerInventoryProvider get() {
        if (FMLEnvironment.dist == Dist.CLIENT) {
            return clientProvider;
        }
        return serverProvider;
    }

    private PlayerInventoryProvider() {
        this.addPlayerInventoryHandler(MAIN_INVENTORY, player -> player.m_150109_().f_35974_.size(), (player, slot) -> (ItemStack)player.m_150109_().f_35974_.get(slot.intValue()), (player, slot, stack) -> player.m_150109_().f_35974_.set(slot, (Object)stack), true, false, false, false);
        this.addPlayerInventoryHandler(OFFHAND_INVENTORY, player -> player.m_150109_().f_35976_.size(), (player, slot) -> (ItemStack)player.m_150109_().f_35976_.get(slot.intValue()), (player, slot, stack) -> player.m_150109_().f_35976_.set(slot, (Object)stack), false, false, false, false);
        this.addPlayerInventoryHandler(ARMOR_INVENTORY, player -> 1, (player, slot) -> (ItemStack)player.m_150109_().f_35975_.get(EquipmentSlot.CHEST.m_20749_()), (player, slot, stack) -> player.m_150109_().f_35975_.set(EquipmentSlot.CHEST.m_20749_(), (Object)stack), false, true, false, true);
    }

    public void setPlayerInventoryHandlerInitCallback(Consumer<Player> callback) {
        this.playerInventoryHandlerInitCallback = callback;
        this.playerInventoryHandlersInitialized = false;
    }

    public void removePlayerInventoryHandlersStartingWith(String prefix) {
        this.playerInventoryHandlers.entrySet().removeIf(e -> ((String)e.getKey()).startsWith(prefix));
        this.renderedHandlers.removeIf(e -> e.startsWith(prefix));
    }

    public void addPlayerInventoryHandler(String name, Function<Player, Integer> getSlotCount, BiFunction<Player, Integer, ItemStack> getStackInSlot, PlayerInventoryHandler.IStackInSlotModifier setStackInSlot, boolean visibleInGui, boolean rendered, boolean ownRenderer, boolean accessibleByAnotherPlayer) {
        LinkedHashMap<String, PlayerInventoryHandler> temp = new LinkedHashMap<String, PlayerInventoryHandler>(this.playerInventoryHandlers);
        this.playerInventoryHandlers.clear();
        this.playerInventoryHandlers.put(name, new PlayerInventoryHandler(getSlotCount, getStackInSlot, setStackInSlot, visibleInGui, ownRenderer, accessibleByAnotherPlayer));
        this.playerInventoryHandlers.putAll(temp);
        if (rendered) {
            ArrayList<String> tempRendered = new ArrayList<String>(this.renderedHandlers);
            this.renderedHandlers.clear();
            this.renderedHandlers.add(name);
            this.renderedHandlers.addAll(tempRendered);
        }
    }

    public Optional<RenderInfo> getBackpackFromRendered(Player player) {
        this.initialize(player);
        for (String handlerName : this.renderedHandlers) {
            PlayerInventoryHandler invHandler = this.playerInventoryHandlers.get(handlerName);
            if (invHandler == null) {
                return Optional.empty();
            }
            for (int slot = 0; slot < invHandler.getSlotCount(player); ++slot) {
                ItemStack slotStack = invHandler.getStackInSlot(player, slot);
                if (!(slotStack.m_41720_() instanceof BackpackItem)) continue;
                return invHandler.hasItsOwnRenderer() ? Optional.empty() : Optional.of(new RenderInfo(slotStack, handlerName.equals(ARMOR_INVENTORY)));
            }
        }
        return Optional.empty();
    }

    private Map<String, PlayerInventoryHandler> getPlayerInventoryHandlers(Player player) {
        this.initialize(player);
        return this.playerInventoryHandlers;
    }

    private void initialize(Player player) {
        if (!this.playerInventoryHandlersInitialized) {
            this.playerInventoryHandlerInitCallback.accept(player);
            this.playerInventoryHandlersInitialized = true;
        }
    }

    public Optional<PlayerInventoryHandler> getPlayerInventoryHandler(Player player, String name) {
        return Optional.ofNullable(this.getPlayerInventoryHandlers(player).get(name));
    }

    public void runOnBackpacks(Player player, BackpackInventorySlotConsumer backpackInventorySlotConsumer) {
        this.runOnBackpacks(player, backpackInventorySlotConsumer, false);
    }

    public void runOnBackpacks(Player player, BackpackInventorySlotConsumer backpackInventorySlotConsumer, boolean onlyAccessibleByAnotherPlayer) {
        for (Map.Entry<String, PlayerInventoryHandler> entry : this.getPlayerInventoryHandlers(player).entrySet()) {
            PlayerInventoryHandler invHandler = entry.getValue();
            if (onlyAccessibleByAnotherPlayer && !invHandler.isAccessibleByAnotherPlayer()) continue;
            for (int slot = 0; slot < invHandler.getSlotCount(player); ++slot) {
                ItemStack slotStack = invHandler.getStackInSlot(player, slot);
                if (!(slotStack.m_41720_() instanceof BackpackItem) || !backpackInventorySlotConsumer.accept(slotStack, entry.getKey(), slot)) continue;
                return;
            }
        }
    }

    public static class RenderInfo {
        private final ItemStack backpack;
        private final boolean isArmorSlot;

        public RenderInfo(ItemStack backpack, boolean isArmorSlot) {
            this.backpack = backpack;
            this.isArmorSlot = isArmorSlot;
        }

        public ItemStack getBackpack() {
            return this.backpack;
        }

        public boolean isArmorSlot() {
            return this.isArmorSlot;
        }
    }

    public static interface BackpackInventorySlotConsumer {
        public boolean accept(ItemStack var1, String var2, int var3);
    }
}

