/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.network;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import net.p3pp3rf1y.sophisticatedbackpacks.util.InventoryInteractionHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.util.PlayerInventoryProvider;

public class InventoryInteractionMessage {
    private final BlockPos pos;
    private final Direction face;

    public InventoryInteractionMessage(BlockPos pos, Direction face) {
        this.pos = pos;
        this.face = face;
    }

    public static void encode(InventoryInteractionMessage msg, FriendlyByteBuf packetBuffer) {
        packetBuffer.writeLong(msg.pos.m_121878_());
        packetBuffer.m_130068_((Enum)msg.face);
    }

    public static InventoryInteractionMessage decode(FriendlyByteBuf packetBuffer) {
        return new InventoryInteractionMessage(BlockPos.m_122022_((long)packetBuffer.readLong()), (Direction)packetBuffer.m_130066_(Direction.class));
    }

    static void onMessage(InventoryInteractionMessage msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> InventoryInteractionMessage.handleMessage(msg, context.getSender()));
        context.setPacketHandled(true);
    }

    private static void handleMessage(InventoryInteractionMessage msg, @Nullable ServerPlayer sender) {
        if (sender == null) {
            return;
        }
        PlayerInventoryProvider.get().runOnBackpacks((Player)sender, (backpack, inventoryName, slot) -> {
            InventoryInteractionHelper.tryInventoryInteraction(msg.pos, sender.f_19853_, backpack, msg.face, (Player)sender);
            sender.m_21011_(InteractionHand.MAIN_HAND, true);
            return true;
        });
    }
}

