/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.compat.curios;

import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackItem;
import net.p3pp3rf1y.sophisticatedbackpacks.compat.curios.BackpackCurioRenderer;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModItems;
import net.p3pp3rf1y.sophisticatedbackpacks.util.PlayerInventoryProvider;
import net.p3pp3rf1y.sophisticatedcore.compat.ICompat;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotTypePreset;
import top.theillusivec4.curios.api.client.CuriosRendererRegistry;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

public class CuriosCompat
implements ICompat {
    public CuriosCompat() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::sendImc);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            CuriosRendererRegistry.register((Item)((Item)ModItems.BACKPACK.get()), BackpackCurioRenderer::new);
            CuriosRendererRegistry.register((Item)((Item)ModItems.IRON_BACKPACK.get()), BackpackCurioRenderer::new);
            CuriosRendererRegistry.register((Item)((Item)ModItems.GOLD_BACKPACK.get()), BackpackCurioRenderer::new);
            CuriosRendererRegistry.register((Item)((Item)ModItems.DIAMOND_BACKPACK.get()), BackpackCurioRenderer::new);
            CuriosRendererRegistry.register((Item)((Item)ModItems.NETHERITE_BACKPACK.get()), BackpackCurioRenderer::new);
        });
        IEventBus eventBus = MinecraftForge.EVENT_BUS;
        eventBus.addGenericListener(ItemStack.class, this::onAttachCapabilities);
        eventBus.addListener(this::onTagsUpdated);
        this.addPlayerInventoryHandlers();
    }

    private void addPlayerInventoryHandlers() {
        PlayerInventoryProvider.get().setPlayerInventoryHandlerInitCallback(player -> CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player).ifPresent(handler -> {
            Set backpackCurioTags = CuriosApi.getCuriosHelper().getCurioTags((Item)ModItems.BACKPACK.get());
            for (String identifier : handler.getCurios().keySet()) {
                if (!identifier.equals(SlotTypePreset.CURIO.getIdentifier()) && !backpackCurioTags.contains(identifier)) continue;
                this.addSlotProvider(identifier);
            }
        }));
    }

    private void addSlotProvider(String identifier) {
        PlayerInventoryProvider.get().addPlayerInventoryHandler("curios_" + identifier, player -> CuriosCompat.getFromCuriosSlotStackHandler((LivingEntity)player, identifier, ICurioStacksHandler::getSlots, 0), (player, slot) -> CuriosCompat.getFromCuriosSlotStackHandler((LivingEntity)player, identifier, sh -> sh.getStacks().getStackInSlot(slot.intValue()), ItemStack.f_41583_), (player, slot, stack) -> this.runOnBackStackHandler(player, identifier, sh -> sh.getStacks().setStackInSlot(slot, stack)), false, true, true, true);
    }

    public static <T> T getFromCuriosSlotStackHandler(LivingEntity livingEntity, String identifier, Function<ICurioStacksHandler, T> getFromHandler, T defaultValue) {
        return CuriosApi.getCuriosHelper().getCuriosHandler(livingEntity).map(h -> h.getStacksHandler(identifier).map(getFromHandler).orElse(defaultValue)).orElse(defaultValue);
    }

    private void runOnBackStackHandler(Player player, String identifier, Consumer<ICurioStacksHandler> runOnHandler) {
        CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player).ifPresent(h -> h.getStacksHandler(identifier).ifPresent(runOnHandler));
    }

    private void sendImc(InterModEnqueueEvent evt) {
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.BACK.getMessageBuilder().build());
    }

    public void onAttachCapabilities(AttachCapabilitiesEvent<ItemStack> evt) {
        final ItemStack stack = (ItemStack)evt.getObject();
        Item item = stack.m_41720_();
        if (item.getRegistryName() != null && item.getRegistryName().m_135827_().equals("sophisticatedbackpacks") && item instanceof BackpackItem) {
            evt.addCapability(new ResourceLocation("sophisticatedbackpacks", item.getRegistryName().m_135815_() + "_curios"), new ICapabilityProvider(){

                public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
                    return CuriosCapability.ITEM.orEmpty(cap, LazyOptional.of(() -> () -> stack));
                }
            });
        }
    }

    public void onTagsUpdated(TagsUpdatedEvent event) {
        PlayerInventoryProvider.get().removePlayerInventoryHandlersStartingWith("curios_");
        this.addPlayerInventoryHandlers();
    }

    public void setup() {
    }
}

