/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.common.gui;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkHooks;
import net.p3pp3rf1y.sophisticatedbackpacks.SophisticatedBackpacks;
import net.p3pp3rf1y.sophisticatedbackpacks.api.CapabilityBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackAccessLogger;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackItem;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackStorage;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.SBPTranslationHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.BackpackContext;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.BackpackSettingsContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModItems;
import net.p3pp3rf1y.sophisticatedbackpacks.network.BackpackContentsMessage;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.common.gui.ISyncedContainer;
import net.p3pp3rf1y.sophisticatedcore.common.gui.StorageContainerMenuBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeHandler;
import net.p3pp3rf1y.sophisticatedcore.util.NoopStorageWrapper;

public class BackpackContainer
extends StorageContainerMenuBase<IBackpackWrapper>
implements ISyncedContainer {
    private final BackpackContext backpackContext;

    public BackpackContainer(int windowId, Player player, BackpackContext backpackContext) {
        super((MenuType)ModItems.BACKPACK_CONTAINER_TYPE.get(), windowId, player, (IStorageWrapper)backpackContext.getBackpackWrapper(player), backpackContext.getParentBackpackWrapper(player).orElse((IStorageWrapper)NoopStorageWrapper.INSTANCE), backpackContext.getBackpackSlotIndex(), backpackContext.shouldLockBackpackSlot(player));
        this.backpackContext = backpackContext;
        ((IBackpackWrapper)this.storageWrapper).getContentsUuid().ifPresent(backpackUuid -> {
            ItemStack backpack = ((IBackpackWrapper)this.storageWrapper).getBackpack();
            BackpackAccessLogger.logPlayerAccess(player, backpack.m_41720_(), backpackUuid, backpack.m_41786_().getString(), ((IBackpackWrapper)this.storageWrapper).getMainColor(), ((IBackpackWrapper)this.storageWrapper).getAccentColor(), ((IBackpackWrapper)this.storageWrapper).getColumnsTaken());
        });
    }

    public Optional<BlockPos> getBlockPosition() {
        BackpackContext.ContextType type = this.backpackContext.getType();
        if (type == BackpackContext.ContextType.BLOCK_BACKPACK || type == BackpackContext.ContextType.BLOCK_SUB_BACKPACK) {
            return Optional.of(this.backpackContext.getBackpackPosition(this.player));
        }
        return Optional.empty();
    }

    protected void sendStorageSettingsToClient() {
        if (this.player.f_19853_.f_46443_) {
            return;
        }
        ((IBackpackWrapper)this.storageWrapper).getContentsUuid().ifPresent(uuid -> {
            CompoundTag settingsContents = new CompoundTag();
            CompoundTag settingsNbt = ((IBackpackWrapper)this.storageWrapper).getSettingsHandler().getNbt();
            if (!settingsNbt.m_128456_()) {
                settingsContents.m_128365_("settings", (Tag)settingsNbt);
                SophisticatedBackpacks.PACKET_HANDLER.sendToClient((ServerPlayer)this.player, new BackpackContentsMessage((UUID)uuid, settingsContents));
            }
        });
    }

    protected StorageContainerMenuBase.StorageUpgradeSlot instantiateUpgradeSlot(UpgradeHandler upgradeHandler, int slotIndex) {
        return new BackpackUpgradeSlot(upgradeHandler, slotIndex);
    }

    public boolean m_6875_(Player player) {
        return this.backpackContext.canInteractWith(player);
    }

    public static BackpackContainer fromBuffer(int windowId, Inventory playerInventory, FriendlyByteBuf packetBuffer) {
        return new BackpackContainer(windowId, playerInventory.f_35978_, BackpackContext.fromBuffer(packetBuffer, playerInventory.f_35978_.f_19853_));
    }

    public BackpackContext getBackpackContext() {
        return this.backpackContext;
    }

    public void openSettings() {
        if (this.isClientSide()) {
            this.sendToServer(data -> data.m_128359_("action", "openSettings"));
            return;
        }
        NetworkHooks.openGui((ServerPlayer)((ServerPlayer)this.player), (MenuProvider)new SimpleMenuProvider((w, p, pl) -> new BackpackSettingsContainer(w, pl, this.backpackContext), (Component)new TranslatableComponent(SBPTranslationHelper.INSTANCE.translGui("settings.title"))), this.backpackContext::toBuffer);
    }

    protected boolean isNotCorrectStorageItem(ItemStack supposedToBeStorageItemStack) {
        return supposedToBeStorageItemStack.m_41619_() || !(supposedToBeStorageItemStack.m_41720_() instanceof BackpackItem) || supposedToBeStorageItemStack.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).map(w -> w != (this.isFirstLevelStorage() ? this.storageWrapper : this.parentStorageWrapper)).orElse(true) != false;
    }

    public void detectSettingsChangeAndReload() {
        ((IBackpackWrapper)this.storageWrapper).getContentsUuid().ifPresent(uuid -> {
            BackpackStorage storage = BackpackStorage.get();
            if (storage.removeUpdatedBackpackSettingsFlag((UUID)uuid)) {
                ((IBackpackWrapper)this.storageWrapper).getSettingsHandler().reloadFrom(storage.getOrCreateBackpackContents((UUID)uuid));
                this.refreshInventorySlotsIfNeeded();
            }
        });
    }

    protected boolean shouldSlotItemBeDroppedFromStorage(Slot slot) {
        return slot.m_7993_().m_41720_() instanceof BackpackItem && !((IBackpackWrapper)this.storageWrapper).getInventoryHandler().isItemValid(0, slot.m_7993_());
    }

    public class BackpackUpgradeSlot
    extends StorageContainerMenuBase.StorageUpgradeSlot {
        public BackpackUpgradeSlot(UpgradeHandler upgradeHandler, int slotIndex) {
            super((StorageContainerMenuBase)BackpackContainer.this, upgradeHandler, slotIndex);
        }

        protected void onUpgradeChanged() {
            super.onUpgradeChanged();
            BackpackContainer.this.backpackContext.onUpgradeChanged(BackpackContainer.this.player);
        }
    }
}

