/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.backpack;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.api.CapabilityBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackBlock;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModBlocks;
import net.p3pp3rf1y.sophisticatedcore.renderdata.RenderInfo;
import net.p3pp3rf1y.sophisticatedcore.renderdata.TankPosition;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;

public class BackpackBlockEntity
extends BlockEntity {
    private IBackpackWrapper backpackWrapper = IBackpackWrapper.Noop.INSTANCE;
    private boolean updateBlockRender = true;

    public BackpackBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlocks.BACKPACK_TILE_TYPE.get(), pos, state);
    }

    public void setBackpack(ItemStack backpack) {
        this.backpackWrapper = (IBackpackWrapper)backpack.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).orElse((Object)IBackpackWrapper.Noop.INSTANCE);
        this.backpackWrapper.setSaveHandler(() -> {
            this.m_6596_();
            this.updateBlockRender = false;
            WorldHelper.notifyBlockUpdate((BlockEntity)this);
        });
        this.backpackWrapper.setInventorySlotChangeHandler(() -> ((BackpackBlockEntity)this).m_6596_());
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.setBackpackFromNbt(nbt);
        WorldHelper.notifyBlockUpdate((BlockEntity)this);
    }

    private void setBackpackFromNbt(CompoundTag nbt) {
        this.setBackpack(ItemStack.m_41712_((CompoundTag)nbt.m_128469_("backpackData")));
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.writeBackpack(tag);
    }

    private void writeBackpack(CompoundTag ret) {
        ItemStack backpackCopy = this.backpackWrapper.getBackpack().m_41777_();
        backpackCopy.m_41751_(backpackCopy.m_41720_().getShareTag(backpackCopy));
        ret.m_128365_("backpackData", (Tag)backpackCopy.m_41739_(new CompoundTag()));
    }

    public CompoundTag m_5995_() {
        CompoundTag ret = super.m_5995_();
        this.writeBackpack(ret);
        ret.m_128379_("updateBlockRender", this.updateBlockRender);
        this.updateBlockRender = true;
        return ret;
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag tag = pkt.m_131708_();
        if (tag == null) {
            return;
        }
        this.setBackpackFromNbt(tag);
        if (tag.m_128471_("updateBlockRender")) {
            WorldHelper.notifyBlockUpdate((BlockEntity)this);
        }
    }

    public IBackpackWrapper getBackpackWrapper() {
        return this.backpackWrapper;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return LazyOptional.of(() -> this.getBackpackWrapper().getInventoryForInputOutput()).cast();
        }
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.getBackpackWrapper().getFluidHandler().map(handler -> LazyOptional.of(() -> handler).cast()).orElseGet(LazyOptional::empty);
        }
        if (cap == CapabilityEnergy.ENERGY) {
            return this.getBackpackWrapper().getEnergyStorage().map(storage -> LazyOptional.of(() -> storage).cast()).orElseGet(LazyOptional::empty);
        }
        return super.getCapability(cap, side);
    }

    public void refreshRenderState() {
        BlockState state = this.m_58900_();
        state = (BlockState)state.m_61124_((Property)BackpackBlock.LEFT_TANK, (Comparable)Boolean.valueOf(false));
        state = (BlockState)state.m_61124_((Property)BackpackBlock.RIGHT_TANK, (Comparable)Boolean.valueOf(false));
        RenderInfo renderInfo = this.backpackWrapper.getRenderInfo();
        for (TankPosition pos : renderInfo.getTankRenderInfos().keySet()) {
            if (pos == TankPosition.LEFT) {
                state = (BlockState)state.m_61124_((Property)BackpackBlock.LEFT_TANK, (Comparable)Boolean.valueOf(true));
                continue;
            }
            if (pos != TankPosition.RIGHT) continue;
            state = (BlockState)state.m_61124_((Property)BackpackBlock.RIGHT_TANK, (Comparable)Boolean.valueOf(true));
        }
        state = (BlockState)state.m_61124_((Property)BackpackBlock.BATTERY, (Comparable)Boolean.valueOf(renderInfo.getBatteryRenderInfo().isPresent()));
        this.f_58857_.m_46597_(this.f_58858_, state);
        this.f_58857_.m_46672_(this.f_58858_, state.m_60734_());
        WorldHelper.notifyBlockUpdate((BlockEntity)this);
    }

    public static void serverTick(Level level, BlockPos blockPos, BackpackBlockEntity backpackBlockEntity) {
        if (level.f_46443_) {
            return;
        }
        backpackBlockEntity.backpackWrapper.getUpgradeHandler().getWrappersThatImplement(ITickableUpgrade.class).forEach(upgrade -> upgrade.tick(null, level, blockPos));
    }
}

