/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util.flags;

import cofh.lib.util.constants.Constants;
import cofh.lib.util.flags.FlagLootCondition;
import cofh.lib.util.flags.FlagRecipeCondition;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.function.BooleanSupplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;

public class FlagManager {
    private static final Object2ObjectOpenHashMap<String, BooleanSupplier> FLAGS = new Object2ObjectOpenHashMap(64);
    public final ResourceLocation id;
    public LootItemConditionType flagConditionType;

    public FlagManager(String modId) {
        this(modId, "flag");
    }

    public FlagManager(String modId, String path) {
        this.id = new ResourceLocation(modId, path);
        CraftingHelper.register((IConditionSerializer)new FlagRecipeCondition.Serializer(this, this.id));
        this.flagConditionType = new LootItemConditionType((Serializer)new FlagLootCondition.Serializer(this));
    }

    public void setup() {
        Registry.m_122965_((Registry)Registry.f_122877_, (ResourceLocation)this.id, (Object)this.flagConditionType);
    }

    private BooleanSupplier getOrCreateFlag(String flag) {
        FLAGS.putIfAbsent((Object)flag, (Object)Constants.FALSE);
        return (BooleanSupplier)FLAGS.get((Object)flag);
    }

    public synchronized void setFlag(String flag, boolean enable) {
        FLAGS.put((Object)flag, (Object)(enable ? Constants.TRUE : Constants.FALSE));
    }

    public synchronized void setFlag(String flag, BooleanSupplier condition) {
        FLAGS.put((Object)flag, (Object)(condition == null ? Constants.FALSE : condition));
    }

    public BooleanSupplier getFlag(String flag) {
        return () -> this.getOrCreateFlag(flag).getAsBoolean();
    }
}

