/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util;

import cofh.lib.enchantment.EnchantmentCoFH;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.references.CoFHTags;
import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Either;
import java.nio.file.Path;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class Utils {
    public static final int TIME_CONSTANT = 32;
    public static final int TIME_CONSTANT_HALF = 16;
    public static final int TIME_CONSTANT_QUARTER = 8;
    private static int timeConstant = 0;
    private static int timeConstantHalf = 0;
    private static int timeConstantQuarter = 0;

    private Utils() {
    }

    public static boolean isModLoaded(String modid) {
        return ModList.get().isLoaded(modid);
    }

    public static boolean isClientWorld(Level world) {
        return world.f_46443_;
    }

    public static boolean isServerWorld(Level world) {
        return !world.f_46443_;
    }

    public static boolean isFakePlayer(Entity entity) {
        return entity instanceof FakePlayer;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isCreativePlayer(Entity entity) {
        if (!(entity instanceof Player)) return false;
        Player player = (Player)entity;
        if (!player.m_150110_().f_35937_) return false;
        return true;
    }

    public static EquipmentSlot handToEquipSlot(InteractionHand hand) {
        return hand.equals((Object)InteractionHand.MAIN_HAND) ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND;
    }

    public static InteractionHand otherHand(InteractionHand hand) {
        return hand.equals((Object)InteractionHand.MAIN_HAND) ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
    }

    public static EquipmentSlot otherHand(EquipmentSlot slot) {
        return slot.equals((Object)EquipmentSlot.MAINHAND) ? EquipmentSlot.OFFHAND : EquipmentSlot.MAINHAND;
    }

    public static String createPrettyJSON(String jsonString) {
        JsonObject json = JsonParser.parseString((String)jsonString).getAsJsonObject();
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        return gson.toJson((JsonElement)json);
    }

    public static void loadConfig(ForgeConfigSpec spec, Path path) {
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().writingMode(WritingMode.REPLACE).build();
        configData.load();
        spec.setConfig((CommentedConfig)configData);
    }

    public static boolean spawnLightningBolt(Level world, BlockPos pos) {
        return Utils.spawnLightningBolt(world, pos, null);
    }

    public static boolean spawnLightningBolt(Level world, BlockPos pos, Entity caster) {
        if (Utils.isServerWorld(world)) {
            ServerPlayer player;
            LightningBolt bolt = (LightningBolt)EntityType.f_20465_.m_20615_(world);
            bolt.m_20219_(Vec3.m_82539_((Vec3i)pos));
            bolt.m_20879_(caster instanceof ServerPlayer ? (player = (ServerPlayer)caster) : null);
            world.m_7967_((Entity)bolt);
        }
        return true;
    }

    public static boolean destroyBlock(Level world, BlockPos pos, boolean dropBlock, @Nullable Entity entityIn) {
        Player player;
        BlockState state = world.m_8055_(pos);
        if (state.m_60795_() || state.m_60800_((BlockGetter)world, pos) < 0.0f || entityIn instanceof Player && state.m_60625_(player = (Player)entityIn, (BlockGetter)world, pos) < 0.0f) {
            return false;
        }
        FluidState ifluidstate = world.m_6425_(pos);
        if (dropBlock) {
            BlockEntity tileentity = state.m_155947_() ? world.m_7702_(pos) : null;
            Block.m_49881_((BlockState)state, (Level)world, (BlockPos)pos, (BlockEntity)tileentity, (Entity)entityIn, (ItemStack)ItemStack.f_41583_);
        }
        return world.m_7731_(pos, ifluidstate.m_76188_(), 3);
    }

    public static boolean isWrench(ItemStack item) {
        return item.m_204117_(CoFHTags.Items.TOOLS_WRENCH);
    }

    public static boolean hasBiomeType(Level world, BlockPos pos, BiomeDictionary.Type type) {
        Optional biomeReg;
        Either biomeEither = world.m_204166_(pos).m_203439_();
        Optional biomeKey = biomeEither.left();
        if (biomeKey.isEmpty() && (biomeReg = world.m_5962_().m_6632_(Registry.f_122885_)).isPresent()) {
            biomeKey = biomeEither.right().flatMap(e -> ((Registry)biomeReg.get()).m_7854_(e));
        }
        return biomeKey.filter(biomeResourceKey -> BiomeDictionary.hasType((ResourceKey)biomeResourceKey, (BiomeDictionary.Type)type)).isPresent();
    }

    public static void tickTimeConstants() {
        if (++timeConstant >= 32) {
            timeConstant = 0;
        }
        if (++timeConstantHalf >= 16) {
            timeConstantHalf = 0;
        }
        if (++timeConstantQuarter >= 8) {
            timeConstantQuarter = 0;
        }
    }

    public static boolean timeCheck(Level world) {
        return timeConstant == 0;
    }

    public static boolean timeCheckHalf(Level world) {
        return timeConstantHalf == 0;
    }

    public static boolean timeCheckQuarter(Level world) {
        return timeConstantQuarter == 0;
    }

    public static void spawnBlockParticlesClient(Level world, ParticleOptions particle, BlockPos pos, Random rand, int count) {
        for (int i = 0; i < count; ++i) {
            double d0 = (double)pos.m_123341_() + rand.nextDouble();
            double d1 = (double)pos.m_123342_() + rand.nextDouble();
            double d2 = (double)pos.m_123343_() + rand.nextDouble();
            double d3 = (rand.nextDouble() - 0.5) * 0.5;
            double d4 = (rand.nextDouble() - 0.5) * 0.5;
            double d5 = (rand.nextDouble() - 0.5) * 0.5;
            world.m_7106_(particle, d0, d1, d2, d3, d4, d5);
        }
    }

    public static void spawnParticles(Level world, ParticleOptions particle, double posX, double posY, double posZ, int particleCount, double xOffset, double yOffset, double zOffset, double speed) {
        if (Utils.isServerWorld(world)) {
            ((ServerLevel)world).m_8767_(particle, posX, posY + 1.0, posZ, particleCount, xOffset, yOffset, zOffset, speed);
        } else {
            world.m_7106_(particle, posX + xOffset, posY + yOffset, posZ + zOffset, 0.0, 0.0, 0.0);
        }
    }

    public static boolean addToPlayerInventory(Player player, ItemStack stack) {
        ArmorItem armorItem;
        int index;
        if (stack.m_41619_() || player == null) {
            return false;
        }
        Item item = stack.m_41720_();
        if (item instanceof ArmorItem && ((ItemStack)player.m_150109_().f_35975_.get(index = (armorItem = (ArmorItem)item).m_40402_().m_20749_())).m_41619_()) {
            player.m_150109_().f_35975_.set(index, (Object)stack);
            return true;
        }
        Inventory inv = player.m_150109_();
        for (int i = 0; i < inv.f_35974_.size(); ++i) {
            if (!((ItemStack)inv.f_35974_.get(i)).m_41619_()) continue;
            inv.f_35974_.set(i, (Object)stack.m_41777_());
            return true;
        }
        return false;
    }

    public static boolean addPotionEffectNoEvent(LivingEntity entity, MobEffectInstance effectInstanceIn) {
        if (!Utils.isPotionApplicableNoEvent(entity, effectInstanceIn)) {
            return false;
        }
        MobEffectInstance effectinstance = (MobEffectInstance)entity.m_21221_().get(effectInstanceIn.m_19544_());
        if (effectinstance == null) {
            entity.m_21221_().put(effectInstanceIn.m_19544_(), effectInstanceIn);
            entity.m_142540_(effectInstanceIn, null);
            return true;
        }
        if (effectinstance.m_19558_(effectInstanceIn)) {
            entity.m_141973_(effectinstance, true, null);
            return true;
        }
        return false;
    }

    public static boolean isPotionApplicableNoEvent(LivingEntity entity, MobEffectInstance potioneffectIn) {
        if (entity.m_6336_() == MobType.f_21641_) {
            MobEffect effect = potioneffectIn.m_19544_();
            return effect != MobEffects.f_19605_ && effect != MobEffects.f_19614_;
        }
        return true;
    }

    public static boolean dropItemStackIntoWorld(ItemStack stack, Level world, Vec3 pos) {
        return Utils.dropItemStackIntoWorld(stack, world, pos, false);
    }

    public static boolean dropItemStackIntoWorldWithRandomness(ItemStack stack, Level world, BlockPos pos) {
        return Utils.dropItemStackIntoWorld(stack, world, Vec3.m_82512_((Vec3i)pos), true);
    }

    public static boolean dropItemStackIntoWorldWithRandomness(ItemStack stack, Level world, Vec3 pos) {
        return Utils.dropItemStackIntoWorld(stack, world, pos, true);
    }

    public static boolean dropItemStackIntoWorld(ItemStack stack, Level world, Vec3 pos, boolean velocity) {
        if (stack.m_41619_()) {
            return false;
        }
        float x2 = 0.5f;
        float y2 = 0.0f;
        float z2 = 0.5f;
        if (velocity) {
            x2 = world.f_46441_.nextFloat() * 0.8f + 0.1f;
            y2 = world.f_46441_.nextFloat() * 0.8f + 0.1f;
            z2 = world.f_46441_.nextFloat() * 0.8f + 0.1f;
        }
        ItemEntity entity = new ItemEntity(world, pos.f_82479_ + (double)x2, pos.f_82480_ + (double)y2, pos.f_82481_ + (double)z2, stack.m_41777_());
        if (velocity) {
            entity.m_20334_(world.f_46441_.nextGaussian() * (double)0.05f, world.f_46441_.nextGaussian() * (double)0.05f + (double)0.2f, world.f_46441_.nextGaussian() * (double)0.05f);
        } else {
            entity.m_20334_(-0.05, 0.0, 0.0);
        }
        world.m_7967_((Entity)entity);
        return true;
    }

    public static boolean dropDismantleStackIntoWorld(ItemStack stack, Level world, BlockPos pos) {
        if (stack.m_41619_()) {
            return false;
        }
        float f = 0.3f;
        double x2 = (double)(world.f_46441_.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        double y2 = (double)(world.f_46441_.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        double z2 = (double)(world.f_46441_.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        ItemEntity dropEntity = new ItemEntity(world, (double)pos.m_123341_() + x2, (double)pos.m_123342_() + y2, (double)pos.m_123343_() + z2, stack);
        dropEntity.m_32010_(10);
        world.m_7967_((Entity)dropEntity);
        return true;
    }

    public static boolean teleportEntityTo(Entity entity, BlockPos pos) {
        return Utils.teleportEntityTo(entity, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5);
    }

    public static boolean teleportEntityTo(Entity entity, double x, double y, double z) {
        if (entity instanceof LivingEntity) {
            return Utils.teleportEntityTo((LivingEntity)entity, x, y, z);
        }
        entity.m_7678_(x, y, z, entity.m_146908_(), entity.m_146909_());
        entity.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean teleportEntityTo(LivingEntity entity, double x, double y, double z) {
        event = new EntityTeleportEvent.EnderEntity(entity, x, y, z);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        if (!(entity instanceof ServerPlayer)) ** GOTO lbl-1000
        player = (ServerPlayer)entity;
        if (!Utils.isFakePlayer((Entity)entity)) {
            if (player.f_8906_.m_6198_().m_129536_() && !player.m_5803_()) {
                if (entity.m_20159_()) {
                    entity.m_8127_();
                }
                entity.m_6021_(event.getTargetX(), event.getTargetY(), event.getTargetZ());
                entity.f_19789_ = 0.0f;
            }
        } else lbl-1000:
        // 2 sources

        {
            if (entity.m_20159_()) {
                entity.m_8127_();
            }
            entity.m_6021_(event.getTargetX(), event.getTargetY(), event.getTargetZ());
            entity.f_19789_ = 0.0f;
        }
        entity.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
        return true;
    }

    public static int getEnchantedCapacity(int amount, int holding) {
        return MathHelper.clamp(amount + amount * holding / 2, 0, Integer.MAX_VALUE);
    }

    public static int getItemEnchantmentLevel(Enchantment ench, ItemStack stack) {
        if (ench == null || ench instanceof EnchantmentCoFH && !((EnchantmentCoFH)ench).isEnabled()) {
            return 0;
        }
        return EnchantmentHelper.m_44843_((Enchantment)ench, (ItemStack)stack);
    }

    public static int getHeldEnchantmentLevel(LivingEntity living, Enchantment ench) {
        if (ench == null || ench instanceof EnchantmentCoFH && !((EnchantmentCoFH)ench).isEnabled()) {
            return 0;
        }
        return Math.max(EnchantmentHelper.m_44843_((Enchantment)ench, (ItemStack)living.m_21205_()), EnchantmentHelper.m_44843_((Enchantment)ench, (ItemStack)living.m_21206_()));
    }

    public static int getMaxEquippedEnchantmentLevel(LivingEntity living, Enchantment ench) {
        if (ench == null || ench instanceof EnchantmentCoFH && !((EnchantmentCoFH)ench).isEnabled()) {
            return 0;
        }
        return EnchantmentHelper.m_44836_((Enchantment)ench, (LivingEntity)living);
    }

    public static void addEnchantment(ItemStack stack, Enchantment ench, int level) {
        stack.m_41663_(ench, level);
    }

    public static void removeEnchantment(ItemStack stack, Enchantment ench) {
        if (stack.m_41783_() == null || !stack.m_41783_().m_128425_("Enchantments", 9)) {
            return;
        }
        ListTag list = stack.m_41783_().m_128437_("Enchantments", 10);
        String encId = String.valueOf(ForgeRegistries.ENCHANTMENTS.getKey((IForgeRegistryEntry)ench));
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag tag = list.m_128728_(i);
            String id = tag.m_128461_("id");
            if (!encId.equals(id)) continue;
            list.remove(i);
            break;
        }
        if (list.isEmpty()) {
            stack.m_41749_("Enchantments");
        }
    }

    public static String getItemNamespace(Item item) {
        return item.getRegistryName() == null ? "" : item.getRegistryName().m_135827_();
    }

    public static String getItemNamespace(ItemStack stack) {
        return stack.m_41720_().getRegistryName() == null ? "" : stack.m_41720_().getRegistryName().m_135827_();
    }

    public static String getFluidNamespace(Fluid fluid) {
        return fluid.getRegistryName() == null ? "" : fluid.getRegistryName().m_135827_();
    }

    public static String getFluidNamespace(FluidStack stack) {
        return stack.getFluid().getRegistryName() == null ? "" : stack.getFluid().getRegistryName().m_135827_();
    }
}

