/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.item;

import cofh.core.init.CoreKeys;
import cofh.lib.item.ContainerType;
import cofh.lib.item.IMultiModeItem;
import cofh.lib.util.helpers.AugmentableHelper;
import cofh.lib.util.helpers.KeyHelper;
import cofh.lib.util.helpers.SecurityHelper;
import cofh.lib.util.helpers.StringHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.extensions.IForgeItem;

public interface ICoFHItem
extends IForgeItem {
    default public boolean isCreative(ItemStack stack, ContainerType type) {
        switch (type) {
            case ITEM: {
                return AugmentableHelper.getPropertyWithDefault(stack, "ItemCre", 0.0f) > 0.0f;
            }
            case FLUID: {
                return AugmentableHelper.getPropertyWithDefault(stack, "FluidCre", 0.0f) > 0.0f;
            }
            case ENERGY: {
                return AugmentableHelper.getPropertyWithDefault(stack, "RFCre", 0.0f) > 0.0f;
            }
        }
        return false;
    }

    default public boolean canPlayerAccess(ItemStack stack, Player player) {
        return SecurityHelper.getAccess(stack).matches(SecurityHelper.getOwner(stack), (Entity)player);
    }

    default public boolean hasCustomEntity(ItemStack stack) {
        return SecurityHelper.hasSecurity(stack);
    }

    @Nullable
    default public Entity createEntity(Level world, Entity location, ItemStack stack) {
        if (SecurityHelper.hasSecurity(stack)) {
            location.m_20331_(true);
            ((ItemEntity)location).lifespan = Integer.MAX_VALUE;
        }
        return null;
    }

    default public void addEnergyTooltip(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn, int extract, int receive, boolean creative) {
        if (extract == receive && extract > 0 || creative) {
            tooltip.add((Component)StringHelper.getTextComponent(StringHelper.localize("info.cofh.transfer") + ": " + StringHelper.getScaledNumber(extract) + " RF/t"));
        } else if (extract > 0) {
            if (receive > 0) {
                tooltip.add((Component)StringHelper.getTextComponent(StringHelper.localize("info.cofh.send") + "|" + StringHelper.localize("info.cofh.receive") + ": " + StringHelper.getScaledNumber(extract) + "|" + StringHelper.getScaledNumber(receive) + " RF/t"));
            } else {
                tooltip.add((Component)StringHelper.getTextComponent(StringHelper.localize("info.cofh.send") + ": " + StringHelper.getScaledNumber(extract) + " RF/t"));
            }
        } else if (receive > 0) {
            tooltip.add((Component)StringHelper.getTextComponent(StringHelper.localize("info.cofh.receive") + ": " + StringHelper.getScaledNumber(receive) + " RF/t"));
        }
    }

    default public void addModeChangeTooltip(IMultiModeItem item, ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (item.getNumModes(stack) <= 2) {
            this.addIncrementModeChangeTooltip(item, stack, worldIn, tooltip, flagIn);
            return;
        }
        tooltip.add((Component)new TranslatableComponent("info.cofh.mode_change", new Object[]{KeyHelper.getKeynameFromKeycode(CoreKeys.MULTIMODE_INCREMENT.getKey().m_84873_()), KeyHelper.getKeynameFromKeycode(CoreKeys.MULTIMODE_DECREMENT.getKey().m_84873_())}).m_130940_(ChatFormatting.YELLOW));
        if (CoreKeys.MULTIMODE_INCREMENT.getKey().m_84873_() == -1) {
            tooltip.add((Component)new TranslatableComponent("info.cofh.key_not_bound", new Object[]{StringHelper.localize("key.cofh.mode_change_increment")}).m_130940_(ChatFormatting.RED));
        }
        if (CoreKeys.MULTIMODE_DECREMENT.getKey().m_84873_() == -1) {
            tooltip.add((Component)new TranslatableComponent("info.cofh.key_not_bound", new Object[]{StringHelper.localize("key.cofh.mode_change_decrement")}).m_130940_(ChatFormatting.RED));
        }
    }

    default public void addIncrementModeChangeTooltip(IMultiModeItem item, ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)new TranslatableComponent("info.cofh.mode_toggle", new Object[]{KeyHelper.getKeynameFromKeycode(CoreKeys.MULTIMODE_INCREMENT.getKey().m_84873_())}).m_130940_(ChatFormatting.YELLOW));
        if (CoreKeys.MULTIMODE_INCREMENT.getKey().m_84873_() == -1) {
            tooltip.add((Component)new TranslatableComponent("info.cofh.key_not_bound", new Object[]{StringHelper.localize("key.cofh.mode_change_increment")}).m_130940_(ChatFormatting.RED));
        }
    }

    default public boolean isActive(ItemStack stack) {
        return stack.m_41784_().m_128471_("Active");
    }

    default public void setActive(ItemStack stack, boolean state) {
        stack.m_41784_().m_128379_("Active", state);
    }

    default public boolean hasActiveTag(ItemStack stack) {
        return stack.m_41784_().m_128441_("Active");
    }

    default public void setActive(ItemStack stack, LivingEntity entity) {
        stack.m_41784_().m_128356_("Active", entity.f_19853_.m_46467_() + 20L);
    }
}

