/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.inventory;

import cofh.lib.inventory.ItemStorageCoFH;
import cofh.lib.inventory.SimpleItemHandler;
import cofh.lib.util.IInventoryCallback;
import cofh.lib.util.constants.Constants;
import java.util.List;
import java.util.function.BooleanSupplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.item.ItemStack;

public class IOItemHandler
extends SimpleItemHandler {
    protected BooleanSupplier allowInsert = Constants.TRUE;
    protected BooleanSupplier allowExtract = Constants.TRUE;

    public IOItemHandler(@Nullable IInventoryCallback callback, @Nonnull List<ItemStorageCoFH> slots) {
        super(callback, slots);
    }

    public void setConditions(BooleanSupplier allowInsert, BooleanSupplier allowExtract) {
        this.allowInsert = allowInsert;
        this.allowExtract = allowExtract;
    }

    @Override
    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (!this.allowInsert.getAsBoolean()) {
            return ItemStack.f_41583_;
        }
        return super.insertItem(slot, stack, simulate);
    }

    @Override
    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (!this.allowExtract.getAsBoolean()) {
            return ItemStack.f_41583_;
        }
        return super.extractItem(slot, amount, simulate);
    }
}

