/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.energy;

import cofh.lib.capability.IRedstoneFluxStorage;
import cofh.lib.util.IResourceStorage;
import cofh.lib.util.constants.Constants;
import cofh.lib.util.helpers.MathHelper;
import java.util.function.BooleanSupplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.common.util.INBTSerializable;

public class EnergyStorageCoFH
implements IRedstoneFluxStorage,
IResourceStorage,
INBTSerializable<CompoundTag> {
    protected final int baseCapacity;
    protected final int baseReceive;
    protected final int baseExtract;
    protected BooleanSupplier creative = Constants.FALSE;
    protected BooleanSupplier enabled = Constants.TRUE;
    protected int energy;
    protected int capacity;
    protected int maxReceive;
    protected int maxExtract;

    public EnergyStorageCoFH(int capacity) {
        this(capacity, capacity, capacity, 0);
    }

    public EnergyStorageCoFH(int capacity, int maxTransfer) {
        this(capacity, maxTransfer, maxTransfer, 0);
    }

    public EnergyStorageCoFH(int capacity, int maxReceive, int maxExtract) {
        this(capacity, maxReceive, maxExtract, 0);
    }

    public EnergyStorageCoFH(int capacity, int maxReceive, int maxExtract, int energy) {
        this.baseCapacity = capacity;
        this.baseReceive = maxReceive;
        this.baseExtract = maxExtract;
        this.capacity = capacity;
        this.maxReceive = maxReceive;
        this.maxExtract = maxExtract;
        this.energy = Math.max(0, Math.min(capacity, energy));
    }

    public EnergyStorageCoFH applyModifiers(float storageMod, float transferMod) {
        this.setCapacity(Math.round((float)this.baseCapacity * storageMod));
        this.setMaxReceive(Math.round((float)this.baseReceive * transferMod));
        this.setMaxExtract(Math.round((float)this.baseExtract * transferMod));
        return this;
    }

    public EnergyStorageCoFH setCapacity(int capacity) {
        this.capacity = MathHelper.clamp(capacity, 0, Integer.MAX_VALUE);
        this.energy = Math.max(0, Math.min(capacity, this.energy));
        return this;
    }

    public EnergyStorageCoFH setMaxReceive(int maxReceive) {
        this.maxReceive = MathHelper.clamp(maxReceive, 0, Integer.MAX_VALUE);
        return this;
    }

    public EnergyStorageCoFH setMaxExtract(int maxExtract) {
        this.maxExtract = MathHelper.clamp(maxExtract, 0, Integer.MAX_VALUE);
        return this;
    }

    public EnergyStorageCoFH setCreative(BooleanSupplier creative) {
        this.creative = creative;
        if (this.isCreative()) {
            this.energy = this.getCapacity();
        }
        return this;
    }

    public EnergyStorageCoFH setEnabled(BooleanSupplier enabled) {
        if (enabled != null) {
            this.enabled = enabled;
        }
        return this;
    }

    public void setEnergyStored(int amount) {
        this.energy = amount;
        this.energy = Math.max(0, Math.min(this.capacity, this.energy));
    }

    public int getMaxReceive() {
        return this.maxReceive;
    }

    public int getMaxExtract() {
        return this.maxExtract;
    }

    public int receiveEnergyOverride(int maxReceive, boolean simulate) {
        int energyReceived = Math.min(this.capacity - this.energy, maxReceive);
        if (!simulate) {
            this.energy += energyReceived;
        }
        return energyReceived;
    }

    public int extractEnergyOverride(int maxExtract, boolean simulate) {
        int energyExtracted = Math.min(this.energy, maxExtract);
        if (!simulate) {
            this.energy -= energyExtracted;
        }
        return energyExtracted;
    }

    public void readFromBuffer(FriendlyByteBuf buffer) {
        this.setCapacity(buffer.readInt());
        this.setEnergyStored(buffer.readInt());
        this.setMaxExtract(buffer.readInt());
        this.setMaxReceive(buffer.readInt());
    }

    public void writeToBuffer(FriendlyByteBuf buffer) {
        buffer.writeInt(this.getMaxEnergyStored());
        buffer.writeInt(this.getEnergyStored());
        buffer.writeInt(this.getMaxExtract());
        buffer.writeInt(this.getMaxReceive());
    }

    public EnergyStorageCoFH read(CompoundTag nbt) {
        this.energy = nbt.m_128451_("Energy");
        return this;
    }

    public CompoundTag write(CompoundTag nbt) {
        if (this.capacity <= 0) {
            return nbt;
        }
        nbt.m_128405_("Energy", this.energy);
        return nbt;
    }

    public CompoundTag writeWithParams(CompoundTag nbt) {
        if (this.capacity <= 0) {
            return nbt;
        }
        nbt.m_128405_("Energy", this.energy);
        nbt.m_128405_("EnergyMax", this.baseCapacity);
        nbt.m_128405_("EnergyRecv", this.maxReceive);
        nbt.m_128405_("EnergySend", this.maxExtract);
        return nbt;
    }

    public CompoundTag serializeNBT() {
        return this.write(new CompoundTag());
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.read(nbt);
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (!this.enabled.getAsBoolean()) {
            return 0;
        }
        int energyReceived = Math.min(this.capacity - this.energy, Math.min(this.maxReceive, maxReceive));
        if (!simulate) {
            this.energy += energyReceived;
        }
        return energyReceived;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        if (!this.enabled.getAsBoolean()) {
            return 0;
        }
        int energyExtracted = Math.min(this.energy, Math.min(this.maxExtract, maxExtract));
        if (!simulate && !this.isCreative()) {
            this.energy -= energyExtracted;
        }
        return energyExtracted;
    }

    public int getEnergyStored() {
        return this.energy;
    }

    public int getMaxEnergyStored() {
        return this.capacity;
    }

    public boolean canExtract() {
        return this.maxExtract > 0;
    }

    public boolean canReceive() {
        return this.maxReceive > 0;
    }

    @Override
    public boolean clear() {
        if (this.isEmpty()) {
            return false;
        }
        this.energy = 0;
        return true;
    }

    @Override
    public void modify(int amount) {
        if (this.isCreative()) {
            amount = Math.max(amount, 0);
        }
        this.energy += amount;
        if (this.energy > this.capacity) {
            this.energy = this.capacity;
        } else if (this.energy < 0) {
            this.energy = 0;
        }
    }

    @Override
    public boolean isCreative() {
        return this.creative.getAsBoolean();
    }

    @Override
    public boolean isEmpty() {
        return this.energy <= 0 && this.capacity > 0;
    }

    @Override
    public int getCapacity() {
        return this.getMaxEnergyStored();
    }

    @Override
    public int getStored() {
        return this.getEnergyStored();
    }

    @Override
    public String getUnit() {
        return "RF";
    }
}

