/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.data;

import cofh.lib.util.DeferredRegisterCoFH;
import cofh.lib.util.flags.FlagManager;
import cofh.lib.util.flags.FlagRecipeCondition;
import cofh.lib.util.flags.TagExistsRecipeCondition;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.core.Registry;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.HashCache;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.crafting.CompoundIngredient;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RecipeProviderCoFH
extends RecipeProvider
implements IConditionBuilder {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final String modid;
    protected FlagManager manager;

    public RecipeProviderCoFH(DataGenerator generatorIn, String modid) {
        super(generatorIn);
        this.modid = modid;
    }

    public void m_6865_(HashCache cache) {
        Path path = this.f_125970_.m_123916_();
        HashSet set = Sets.newHashSet();
        this.m_176531_(recipe -> {
            if (!set.add(recipe.m_6445_())) {
                LOGGER.error("Duplicate recipe " + recipe.m_6445_());
            } else {
                RecipeProviderCoFH.m_125983_((HashCache)cache, (JsonObject)recipe.m_125966_(), (Path)path.resolve("data/" + recipe.m_6445_().m_135827_() + "/recipes/" + recipe.m_6445_().m_135815_() + ".json"));
            }
        });
    }

    @SafeVarargs
    protected final Ingredient fromTags(TagKey<Item> ... tagsIn) {
        ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>(tagsIn.length);
        for (TagKey<Item> tag : tagsIn) {
            ingredients.add(Ingredient.m_204132_(tag));
        }
        return new CompoundIngredientWrapper(ingredients);
    }

    protected void generateSmallPackingRecipe(Consumer<FinishedRecipe> consumer, Item storage, Item individual, String suffix) {
        String storageName = RecipeProviderCoFH.name(storage);
        String individualName = RecipeProviderCoFH.name(individual);
        ShapedRecipeBuilder.m_126116_((ItemLike)storage).m_126127_(Character.valueOf('#'), (ItemLike)individual).m_126130_("##").m_126130_("##").m_142284_("has_at_least_4_" + individualName, (CriterionTriggerInstance)this.hasItem(MinMaxBounds.Ints.m_55386_((int)4), (ItemLike)individual)).m_176500_(consumer, this.modid + ":storage/" + storageName + suffix);
    }

    protected void generateSmallUnpackingRecipe(Consumer<FinishedRecipe> consumer, Item storage, Item individual, String suffix) {
        String storageName = RecipeProviderCoFH.name(storage);
        String individualName = RecipeProviderCoFH.name(individual);
        ShapelessRecipeBuilder.m_126191_((ItemLike)individual, (int)4).m_126209_((ItemLike)storage).m_142284_("has_at_least_4_" + individualName, (CriterionTriggerInstance)this.hasItem(MinMaxBounds.Ints.m_55386_((int)4), (ItemLike)individual)).m_142284_("has_" + storageName, (CriterionTriggerInstance)RecipeProviderCoFH.m_125977_((ItemLike)storage)).m_176500_(consumer, this.modid + ":storage/" + individualName + suffix);
    }

    protected void generateSmallStorageRecipes(Consumer<FinishedRecipe> consumer, Item storage, Item individual, String packingSuffix, String unpackingSuffix) {
        this.generateSmallPackingRecipe(consumer, storage, individual, packingSuffix);
        this.generateSmallUnpackingRecipe(consumer, storage, individual, unpackingSuffix);
    }

    protected void generateSmallStorageRecipes(Consumer<FinishedRecipe> consumer, Item storage, Item individual) {
        this.generateSmallStorageRecipes(consumer, storage, individual, "", "_from_block");
    }

    protected void generatePackingRecipe(Consumer<FinishedRecipe> consumer, Item storage, Item individual, String suffix) {
        String storageName = RecipeProviderCoFH.name(storage);
        String individualName = RecipeProviderCoFH.name(individual);
        ShapedRecipeBuilder.m_126116_((ItemLike)storage).m_126127_(Character.valueOf('#'), (ItemLike)individual).m_126130_("###").m_126130_("###").m_126130_("###").m_142284_("has_at_least_9_" + individualName, (CriterionTriggerInstance)this.hasItem(MinMaxBounds.Ints.m_55386_((int)9), (ItemLike)individual)).m_176500_(consumer, this.modid + ":storage/" + storageName + suffix);
    }

    protected void generatePackingRecipe(Consumer<FinishedRecipe> consumer, Item storage, Item individual, TagKey<Item> tag, String suffix) {
        String storageName = RecipeProviderCoFH.name(storage);
        String individualName = RecipeProviderCoFH.name(individual);
        ShapedRecipeBuilder.m_126116_((ItemLike)storage).m_126127_(Character.valueOf('I'), (ItemLike)individual).m_206416_(Character.valueOf('#'), tag).m_126130_("###").m_126130_("#I#").m_126130_("###").m_142284_("has_at_least_9_" + individualName, (CriterionTriggerInstance)this.hasItem(MinMaxBounds.Ints.m_55386_((int)9), (ItemLike)individual)).m_176500_(consumer, this.modid + ":storage/" + storageName + suffix);
    }

    protected void generateUnpackingRecipe(Consumer<FinishedRecipe> consumer, Item storage, Item individual, String suffix) {
        String storageName = RecipeProviderCoFH.name(storage);
        String individualName = RecipeProviderCoFH.name(individual);
        ShapelessRecipeBuilder.m_126191_((ItemLike)individual, (int)9).m_126209_((ItemLike)storage).m_142284_("has_at_least_9_" + individualName, (CriterionTriggerInstance)this.hasItem(MinMaxBounds.Ints.m_55386_((int)9), (ItemLike)individual)).m_142284_("has_" + storageName, (CriterionTriggerInstance)RecipeProviderCoFH.m_125977_((ItemLike)storage)).m_176500_(consumer, this.modid + ":storage/" + individualName + suffix);
    }

    protected void generateStorageRecipes(Consumer<FinishedRecipe> consumer, Item storage, Item individual, String packingSuffix, String unpackingSuffix) {
        this.generatePackingRecipe(consumer, storage, individual, packingSuffix);
        this.generateUnpackingRecipe(consumer, storage, individual, unpackingSuffix);
    }

    protected void generateStorageRecipes(Consumer<FinishedRecipe> consumer, Item storage, Item individual, TagKey<Item> tag, String packingSuffix, String unpackingSuffix) {
        this.generatePackingRecipe(consumer, storage, individual, tag, packingSuffix);
        this.generateUnpackingRecipe(consumer, storage, individual, unpackingSuffix);
    }

    protected void generateStorageRecipes(Consumer<FinishedRecipe> consumer, Item storage, Item individual, TagKey<Item> tag) {
        this.generateStorageRecipes(consumer, storage, individual, tag, "", "_from_block");
    }

    protected void generateStorageRecipes(Consumer<FinishedRecipe> consumer, Item storage, Item individual) {
        this.generateStorageRecipes(consumer, storage, individual, "", "_from_block");
    }

    protected void generateTypeRecipes(DeferredRegisterCoFH<Item> reg, Consumer<FinishedRecipe> consumer, String type) {
        Item ingot = reg.get(type + "_ingot");
        Item gem = reg.get(type);
        Item block = reg.get(type + "_block");
        Item nugget = reg.get(type + "_nugget");
        Item raw = reg.get("raw_" + type);
        Item rawBlock = reg.get("raw_" + type + "_block");
        TagKey<Item> ingotTag = RecipeProviderCoFH.forgeTag("ingots/" + type);
        TagKey<Item> gemTag = RecipeProviderCoFH.forgeTag("gems/" + type);
        TagKey<Item> nuggetTag = RecipeProviderCoFH.forgeTag("nuggets/" + type);
        TagKey<Item> rawTag = RecipeProviderCoFH.forgeTag("raw_materials/" + type);
        if (block != null) {
            if (ingot != null) {
                this.generateStorageRecipes(consumer, block, ingot, ingotTag, "", "_from_block");
            } else if (gem != null) {
                this.generateStorageRecipes(consumer, block, gem, gemTag, "", "_from_block");
            }
        }
        if (nugget != null) {
            if (ingot != null) {
                this.generateStorageRecipes(consumer, ingot, nugget, nuggetTag, "_from_nuggets", "_from_ingot");
            } else if (gem != null) {
                this.generateStorageRecipes(consumer, gem, nugget, nuggetTag, "_from_nuggets", "_from_gem");
            }
        }
        if (rawBlock != null && raw != null) {
            this.generateStorageRecipes(consumer, rawBlock, raw, rawTag, "", "_from_block");
        }
        this.generateGearRecipe(reg, consumer, type);
    }

    protected void generateGearRecipe(DeferredRegisterCoFH<Item> reg, Consumer<FinishedRecipe> consumer, String type) {
        Item gear = reg.get(type + "_gear");
        if (gear == null) {
            return;
        }
        Item ingot = reg.get(type + "_ingot");
        Item gem = reg.get(type);
        TagKey<Item> ingotTag = RecipeProviderCoFH.forgeTag("ingots/" + type);
        TagKey<Item> gemTag = RecipeProviderCoFH.forgeTag("gems/" + type);
        if (ingot != null) {
            ShapedRecipeBuilder.m_126116_((ItemLike)gear).m_206416_(Character.valueOf('#'), ingotTag).m_206416_(Character.valueOf('i'), Tags.Items.NUGGETS_IRON).m_126130_(" # ").m_126130_("#i#").m_126130_(" # ").m_142284_("has_" + RecipeProviderCoFH.name(ingot), (CriterionTriggerInstance)RecipeProviderCoFH.m_206406_(ingotTag)).m_176500_(consumer, this.modid + ":parts/" + RecipeProviderCoFH.name(gear));
        }
        if (gem != null) {
            ShapedRecipeBuilder.m_126116_((ItemLike)gear).m_206416_(Character.valueOf('#'), gemTag).m_206416_(Character.valueOf('i'), Tags.Items.NUGGETS_IRON).m_126130_(" # ").m_126130_("#i#").m_126130_(" # ").m_142284_("has_" + RecipeProviderCoFH.name(gem), (CriterionTriggerInstance)RecipeProviderCoFH.m_206406_(gemTag)).m_176500_(consumer, this.modid + ":parts/" + RecipeProviderCoFH.name(gear));
        }
    }

    protected void generateGearRecipe(Consumer<FinishedRecipe> consumer, Item gear, Item material, TagKey<Item> tag) {
        if (gear == null || material == null || tag == null) {
            return;
        }
        ShapedRecipeBuilder.m_126116_((ItemLike)gear).m_206416_(Character.valueOf('#'), tag).m_206416_(Character.valueOf('i'), Tags.Items.NUGGETS_IRON).m_126130_(" # ").m_126130_("#i#").m_126130_(" # ").m_142284_("has_" + RecipeProviderCoFH.name(material), (CriterionTriggerInstance)RecipeProviderCoFH.m_206406_(tag)).m_176500_(consumer, this.modid + ":parts/" + RecipeProviderCoFH.name(gear));
    }

    protected void generateSmeltingRecipe(DeferredRegisterCoFH<Item> reg, Consumer<FinishedRecipe> consumer, Item input, Item output, float xp) {
        this.generateSmeltingRecipe(reg, consumer, input, output, xp, "", "");
    }

    protected void generateSmeltingRecipe(DeferredRegisterCoFH<Item> reg, Consumer<FinishedRecipe> consumer, Item input, Item output, float xp, String folder) {
        this.generateSmeltingRecipe(reg, consumer, input, output, xp, folder, "");
    }

    protected void generateSmeltingRecipe(DeferredRegisterCoFH<Item> reg, Consumer<FinishedRecipe> consumer, Item input, Item output, float xp, String folder, String suffix) {
        SimpleCookingRecipeBuilder.m_126272_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{input}), (ItemLike)output, (float)xp, (int)200).m_142284_("has_" + RecipeProviderCoFH.name(input), (CriterionTriggerInstance)RecipeProviderCoFH.m_125977_((ItemLike)input)).m_176500_(consumer, this.modid + ":" + folder + "/" + RecipeProviderCoFH.name(output) + "_from" + suffix + "_smelting");
    }

    protected void generateSmeltingAndBlastingRecipes(DeferredRegisterCoFH<Item> reg, Consumer<FinishedRecipe> consumer, String material, float xp) {
        this.generateSmeltingAndBlastingRecipes(reg, consumer, material, xp, "smelting");
    }

    protected void generateSmeltingAndBlastingRecipes(DeferredRegisterCoFH<Item> reg, Consumer<FinishedRecipe> consumer, String material, float xp, String folder) {
        Item ore = reg.get(material + "_ore");
        Item raw = reg.get("raw_" + material);
        Item ingot = reg.get(material + "_ingot");
        Item gem = reg.get(material);
        Item dust = reg.get(material + "_dust");
        if (ingot != null) {
            if (dust != null) {
                this.generateSmeltingAndBlastingRecipes(reg, consumer, dust, ingot, 0.0f, folder, "_dust");
            }
            if (raw != null) {
                this.generateSmeltingAndBlastingRecipes(reg, consumer, raw, ingot, 0.7f, folder, "_raw");
            }
            if (ore != null) {
                this.generateSmeltingAndBlastingRecipes(reg, consumer, ore, ingot, xp, folder, "_ore");
            }
        } else if (gem != null && ore != null) {
            this.generateSmeltingAndBlastingRecipes(reg, consumer, ore, gem, xp, folder, "_ore");
        }
    }

    protected void generateSmeltingAndBlastingRecipes(DeferredRegisterCoFH<Item> reg, Consumer<FinishedRecipe> consumer, Item input, Item output, float xp, String folder) {
        this.generateSmeltingAndBlastingRecipes(reg, consumer, input, output, xp, folder, "");
    }

    protected void generateSmeltingAndBlastingRecipes(DeferredRegisterCoFH<Item> reg, Consumer<FinishedRecipe> consumer, Item input, Item output, float xp, String folder, String suffix) {
        SimpleCookingRecipeBuilder.m_126272_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{input}), (ItemLike)output, (float)xp, (int)200).m_142284_("has_" + RecipeProviderCoFH.name(input), (CriterionTriggerInstance)RecipeProviderCoFH.m_125977_((ItemLike)input)).m_176500_(consumer, this.modid + ":" + folder + "/" + RecipeProviderCoFH.name(output) + "_from" + suffix + "_smelting");
        SimpleCookingRecipeBuilder.m_126267_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{input}), (ItemLike)output, (float)xp, (int)100).m_142284_("has_" + RecipeProviderCoFH.name(input), (CriterionTriggerInstance)RecipeProviderCoFH.m_125977_((ItemLike)input)).m_176500_(consumer, this.modid + ":" + folder + "/" + RecipeProviderCoFH.name(output) + "_from" + suffix + "_blasting");
    }

    protected void generateStonecuttingRecipe(DeferredRegisterCoFH<Item> reg, Consumer<FinishedRecipe> consumer, Item input, Item output, String folder) {
        this.generateStonecuttingRecipe(reg, consumer, input, output, folder, "");
    }

    protected void generateStonecuttingRecipe(DeferredRegisterCoFH<Item> reg, Consumer<FinishedRecipe> consumer, Item input, Item output, String folder, String suffix) {
        SingleItemRecipeBuilder.m_126313_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{input}), (ItemLike)output).m_142284_("has_" + RecipeProviderCoFH.name(input), (CriterionTriggerInstance)RecipeProviderCoFH.m_125977_((ItemLike)input)).m_176500_(consumer, this.modid + ":" + folder + "/" + RecipeProviderCoFH.name(output) + "_from" + suffix + "_stonecutting");
    }

    public InventoryChangeTrigger.TriggerInstance hasItem(MinMaxBounds.Ints amount, ItemLike itemIn) {
        return RecipeProviderCoFH.m_126011_((ItemPredicate[])new ItemPredicate[]{new ItemPredicate(null, Set.of(itemIn.m_5456_()), amount, MinMaxBounds.Ints.f_55364_, EnchantmentPredicate.f_30465_, EnchantmentPredicate.f_30465_, null, NbtPredicate.f_57471_)});
    }

    protected static TagKey<Item> forgeTag(String name) {
        return ItemTags.create((ResourceLocation)new ResourceLocation("forge", name));
    }

    protected static String name(Block block) {
        return block.getRegistryName() == null ? "" : block.getRegistryName().m_135815_();
    }

    protected static String name(Item item) {
        return item.getRegistryName() == null ? "" : item.getRegistryName().m_135815_();
    }

    protected ConditionalRecipeConsumer withConditions(Consumer<FinishedRecipe> consumer) {
        return new ConditionalRecipeConsumer(consumer);
    }

    protected static class CompoundIngredientWrapper
    extends CompoundIngredient {
        public CompoundIngredientWrapper(List<Ingredient> children) {
            super(children);
        }
    }

    protected class ConditionalRecipeConsumer
    implements Consumer<FinishedRecipe> {
        protected final Consumer<FinishedRecipe> consumer;
        protected List<ICondition> conditions = new ArrayList<ICondition>();

        public ConditionalRecipeConsumer(Consumer<FinishedRecipe> consumer) {
            this.consumer = consumer;
        }

        public ConditionalRecipeConsumer addCondition(ICondition condition) {
            this.conditions.add(condition);
            return this;
        }

        public ConditionalRecipeConsumer addConditions(List<ICondition> conditions) {
            this.conditions.addAll(conditions);
            return this;
        }

        public ConditionalRecipeConsumer tagExists(TagKey<Item> tag) {
            this.conditions.add(new TagExistsRecipeCondition(tag.f_203868_()));
            return this;
        }

        public ConditionalRecipeConsumer flag(String flag) {
            if (RecipeProviderCoFH.this.manager != null) {
                this.conditions.add(new FlagRecipeCondition(RecipeProviderCoFH.this.manager, flag));
            }
            return this;
        }

        @Override
        public void accept(FinishedRecipe recipe) {
            if (!this.conditions.isEmpty()) {
                this.consumer.accept(new ConditionalRecipeWrapper(recipe).addConditions(this.conditions));
            } else {
                this.consumer.accept(recipe);
            }
        }
    }

    protected static class ConditionalRecipeWrapper
    implements FinishedRecipe {
        protected FinishedRecipe recipe;
        protected List<ICondition> conditions = new ArrayList<ICondition>();

        public ConditionalRecipeWrapper(FinishedRecipe recipe) {
            this.recipe = recipe;
        }

        public ConditionalRecipeWrapper addCondition(ICondition condition) {
            this.conditions.add(condition);
            return this;
        }

        public ConditionalRecipeWrapper addConditions(List<ICondition> conditions) {
            this.conditions.addAll(conditions);
            return this;
        }

        public void m_7917_(JsonObject json) {
            this.recipe.m_7917_(json);
        }

        public JsonObject m_125966_() {
            JsonObject jsonobject = new JsonObject();
            jsonobject.addProperty("type", Registry.f_122865_.m_7981_(this.m_6637_()).toString());
            this.m_7917_(jsonobject);
            if (!this.conditions.isEmpty()) {
                JsonArray conditionArray = new JsonArray();
                for (ICondition condition : this.conditions) {
                    conditionArray.add((JsonElement)CraftingHelper.serialize((ICondition)condition));
                }
                jsonobject.add("conditions", (JsonElement)conditionArray);
            }
            return jsonobject;
        }

        public ResourceLocation m_6445_() {
            return this.recipe.m_6445_();
        }

        public RecipeSerializer<?> m_6637_() {
            return this.recipe.m_6637_();
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.recipe.m_5860_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.recipe.m_6448_();
        }
    }
}

