/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.config.world;

import cofh.lib.config.IBaseConfig;
import cofh.lib.util.constants.Constants;
import java.util.List;
import java.util.function.BooleanSupplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeConfigSpec;

public class OreConfig
implements IBaseConfig {
    public static final OreConfig EMPTY_CONFIG = new OreConfig("invalid", 0, 0, 0, 0, List.of(), Constants.FALSE);
    protected String name;
    protected int count;
    protected int minY;
    protected int maxY;
    protected int size;
    protected BooleanSupplier enable;
    private ForgeConfigSpec.IntValue configCount;
    private ForgeConfigSpec.IntValue configMinY;
    private ForgeConfigSpec.IntValue configMaxY;
    private ForgeConfigSpec.IntValue configSize;

    public OreConfig(String name, int count, int minY, int maxY, int size, List<ResourceKey<Level>> dimensions, BooleanSupplier enable) {
        this.name = name;
        this.count = count;
        this.minY = minY;
        this.maxY = maxY;
        this.size = size;
        this.enable = enable;
    }

    public String getName() {
        return this.name;
    }

    public int getCount() {
        return !this.enable.getAsBoolean() ? 0 : (this.configCount == null ? this.count : (Integer)this.configCount.get());
    }

    public int getMinY() {
        return !this.enable.getAsBoolean() ? 0 : (this.configMinY == null ? this.minY : (Integer)this.configMinY.get());
    }

    public int getMaxY() {
        return !this.enable.getAsBoolean() ? 0 : (this.configMaxY == null ? this.maxY : (Integer)this.configMaxY.get());
    }

    public int getSize() {
        return !this.enable.getAsBoolean() ? 0 : (this.configSize == null ? this.size : (Integer)this.configSize.get());
    }

    public boolean shouldGenerate() {
        return this.enable.getAsBoolean() && this.getCount() > 0;
    }

    @Override
    public void apply(ForgeConfigSpec.Builder builder) {
        if (this.enable.getAsBoolean()) {
            builder.push(this.name);
            this.configCount = builder.comment("Max number of veins per chunk; set to 0 to disable.").defineInRange("Vein Count", this.count, 0, 64);
            this.configSize = builder.comment("Max size of the vein.").defineInRange("Vein Size", this.size, 1, 64);
            this.configMinY = builder.comment("Minimum Y spawn.").defineInRange("Min Y", this.minY, -2032, 2031);
            this.configMaxY = builder.comment("Maximum Y spawn.").defineInRange("Max Y", this.maxY, -2032, 2031);
            builder.pop();
        }
    }

    @Override
    public void refresh() {
    }
}

