/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.block.impl.crops;

import cofh.lib.block.impl.crops.CropsBlockCoFH;
import cofh.lib.util.Utils;
import cofh.lib.util.constants.Constants;
import cofh.lib.util.helpers.MathHelper;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.PlantType;

public class CropsBlockTall
extends CropsBlockCoFH {
    public CropsBlockTall(BlockBehaviour.Properties builder, PlantType type, int growLight, float growMod) {
        super(builder, type, growLight, growMod);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)this.m_7959_(), (Comparable)Integer.valueOf(0))).m_61124_((Property)Constants.TOP, (Comparable)Boolean.valueOf(false)));
    }

    public CropsBlockTall(BlockBehaviour.Properties builder, int growLight, float growMod) {
        this(builder, PlantType.CROP, growLight, growMod);
    }

    public CropsBlockTall(BlockBehaviour.Properties builder) {
        this(builder, 9, 1.25f);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{Constants.TOP});
    }

    protected boolean isTop(BlockState state) {
        return (Boolean)state.m_61143_((Property)Constants.TOP);
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        int age = (Integer)state.m_61143_((Property)this.m_7959_()) - (this.isTop(state) ? 2 : 0);
        return Constants.TALL_CROPS_BY_AGE[MathHelper.clamp(age, 0, Constants.TALL_CROPS_BY_AGE.length - 1)];
    }

    @Override
    public IntegerProperty m_7959_() {
        return Constants.AGE_0_9;
    }

    public int m_7419_() {
        return 9;
    }

    protected int getTallAge() {
        return 4;
    }

    @Override
    public void m_7455_(BlockState state, ServerLevel worldIn, BlockPos pos, Random random) {
        if (!worldIn.isAreaLoaded(pos, 1) || this.isTop(state) || !this.m_7898_(state, (LevelReader)worldIn, pos)) {
            return;
        }
        if (worldIn.m_45524_(pos, 0) >= this.growLight && !this.canHarvest(state)) {
            int age = this.m_52305_(state);
            float growthChance = MathHelper.maxF(CropsBlockTall.m_52272_((Block)this, (BlockGetter)worldIn, (BlockPos)pos) * this.growMod, 0.1f);
            if (ForgeHooks.onCropsGrowPre((Level)worldIn, (BlockPos)pos, (BlockState)state, (random.nextInt((int)(25.0f / growthChance) + 1) == 0 ? 1 : 0) != 0)) {
                int newAge = age + 1 == this.getPostHarvestAge() ? this.m_7419_() : age + 1;
                worldIn.m_7731_(pos, this.m_52289_(newAge), 2);
                if (newAge >= this.getTallAge()) {
                    worldIn.m_7731_(pos.m_7494_(), (BlockState)this.m_52289_(newAge).m_61124_((Property)Constants.TOP, (Comparable)Boolean.valueOf(true)), 2);
                }
                ForgeHooks.onCropsGrowPost((Level)worldIn, (BlockPos)pos, (BlockState)state);
            }
        }
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        if (this.isTop(state)) {
            return worldIn.m_8055_(pos.m_7495_()).m_60734_() == this;
        }
        if (this.m_52305_(state) >= this.getTallAge()) {
            return worldIn.m_8055_(pos.m_7494_()).m_60734_() == this && super.m_7898_(state, worldIn, pos);
        }
        return pos.m_123342_() < worldIn.m_151558_() && super.m_7898_(state, worldIn, pos) && worldIn.m_46859_(pos.m_7494_());
    }

    @Override
    public boolean m_5491_(Level worldIn, Random rand, BlockPos pos, BlockState state) {
        return !this.isTop(state);
    }

    @Override
    public void m_7719_(ServerLevel worldIn, Random rand, BlockPos pos, BlockState state) {
        if (this.canHarvest(state) || this.isTop(state) || !this.m_7898_(state, (LevelReader)worldIn, pos)) {
            return;
        }
        BlockPos above = pos.m_7494_();
        if (!worldIn.m_46859_(above) && worldIn.m_8055_(above).m_60734_() != this) {
            return;
        }
        int newAge = this.m_52305_(state) + this.m_7125_((Level)worldIn);
        newAge = Math.min(newAge, this.m_7419_());
        worldIn.m_7731_(pos, this.m_52289_(newAge), 2);
        if (newAge >= this.getTallAge()) {
            worldIn.m_7731_(above, (BlockState)this.m_52289_(newAge).m_61124_((Property)Constants.TOP, (Comparable)Boolean.valueOf(true)), 2);
        }
    }

    @Override
    public boolean harvest(Level world, BlockPos pos, BlockState state, Player player, boolean replant) {
        if (!this.canHarvest(state)) {
            return false;
        }
        if (Utils.isClientWorld(world)) {
            return true;
        }
        if (this.getPostHarvestAge() >= 0) {
            int fortune = Utils.getItemEnchantmentLevel(Enchantments.f_44987_, player.m_21205_());
            Utils.dropItemStackIntoWorldWithRandomness(new ItemStack(this.getCropItem(), 2 + MathHelper.binomialDist(fortune, 0.5)), world, pos);
            if (this.isTop(state)) {
                world.m_7731_(pos, this.m_52289_(this.getPostHarvestAge() + this.getTallAge()), 2);
                world.m_7731_(pos.m_7495_(), this.m_52289_(this.getPostHarvestAge()), 2);
                Utils.dropItemStackIntoWorldWithRandomness(new ItemStack(this.getCropItem(), 2 + MathHelper.binomialDist(fortune, 0.5)), world, pos.m_7495_());
            } else {
                world.m_7731_(pos, this.m_52289_(this.getPostHarvestAge()), 2);
                world.m_7731_(pos.m_7494_(), this.m_52289_(this.getPostHarvestAge() + this.getTallAge()), 2);
                Utils.dropItemStackIntoWorldWithRandomness(new ItemStack(this.getCropItem(), 2 + MathHelper.binomialDist(fortune, 0.5)), world, pos.m_7494_());
            }
        } else if (replant) {
            boolean seedDrop = false;
            Item seedItem = (Item)this.seed.get();
            List drops = Block.m_49874_((BlockState)state, (ServerLevel)((ServerLevel)world), (BlockPos)pos, null, (Entity)player, (ItemStack)player.m_21205_());
            for (ItemStack drop : drops) {
                drop.m_41764_(drop.m_41613_() * 2);
                if (!seedDrop && drop.m_41720_() == seedItem) {
                    drop.m_41774_(1);
                    seedDrop = true;
                }
                if (!drop.m_41619_()) {
                    Utils.dropItemStackIntoWorldWithRandomness(drop, world, pos);
                }
                world.m_46953_(pos, false, (Entity)player);
                world.m_46953_(this.isTop(state) ? pos.m_7495_() : pos.m_7494_(), false, (Entity)player);
                if (!seedDrop) continue;
                world.m_7731_(this.isTop(state) ? pos.m_7495_() : pos, this.m_52289_(0), 3);
            }
        } else {
            world.m_46953_(pos, true, (Entity)player);
            world.m_46953_(this.isTop(state) ? pos.m_7495_() : pos.m_7494_(), true, (Entity)player);
        }
        return true;
    }
}

