/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.block.impl.crops;

import cofh.lib.block.impl.crops.CropsBlockCoFH;
import cofh.lib.util.constants.Constants;
import cofh.lib.util.helpers.MathHelper;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;

public class CropsBlockMushroom
extends CropsBlockCoFH {
    public CropsBlockMushroom(BlockBehaviour.Properties builder, PlantType type, int growLight, float growMod) {
        super(builder, type, growLight, growMod);
    }

    public CropsBlockMushroom(BlockBehaviour.Properties builder, int growLight, float growMod) {
        this(builder, Constants.FUNGUS, growLight, growMod);
    }

    public CropsBlockMushroom(BlockBehaviour.Properties properties) {
        this(properties, 0, 1.0f);
    }

    protected boolean m_6266_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return state.m_60713_(Blocks.f_50195_) || state.m_60713_(Blocks.f_50599_);
    }

    @Override
    public void m_7455_(BlockState state, ServerLevel worldIn, BlockPos pos, Random random) {
        int age = this.m_52305_(state);
        if (age < this.m_7419_() && ForgeHooks.onCropsGrowPre((Level)worldIn, (BlockPos)pos, (BlockState)state, (random.nextInt(20 + age) == 0 ? 1 : 0) != 0)) {
            int newAge = age + 1 == this.getPostHarvestAge() ? this.m_7419_() : age + 1;
            worldIn.m_7731_(pos, this.m_52289_(newAge), newAge == this.m_7419_() ? 3 : 2);
            ForgeHooks.onCropsGrowPost((Level)worldIn, (BlockPos)pos, (BlockState)state);
        }
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return Constants.MUSHROOMS_BY_AGE[MathHelper.clamp((Integer)state.m_61143_((Property)this.m_7959_()), 0, Constants.MUSHROOMS_BY_AGE.length - 1)];
    }

    @Override
    public IntegerProperty m_7959_() {
        return Constants.AGE_0_4;
    }

    public int m_7419_() {
        return 4;
    }

    protected int m_7125_(Level worldIn) {
        return MathHelper.nextInt(worldIn.f_46441_, 0, 2);
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.m_7495_();
        if (state.m_60734_() == this) {
            return worldIn.m_8055_(blockpos).canSustainPlant((BlockGetter)worldIn, blockpos, Direction.UP, (IPlantable)this);
        }
        return this.m_6266_(worldIn.m_8055_(blockpos), (BlockGetter)worldIn, blockpos);
    }

    @Override
    public boolean m_7370_(BlockGetter worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return false;
    }

    @Override
    public boolean m_5491_(Level worldIn, Random rand, BlockPos pos, BlockState state) {
        return false;
    }

    @Override
    public void m_7719_(ServerLevel worldIn, Random rand, BlockPos pos, BlockState state) {
    }
}

