/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.advancements;

import cofh.lib.advancements.CriterionListeners;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.PlayerAdvancements;

public abstract class AbstractCriterionTrigger<T extends CriterionListeners<U>, U extends CriterionTriggerInstance>
implements CriterionTrigger<U> {
    private final ResourceLocation id;
    private final Function<PlayerAdvancements, T> createNew;
    private final Map<PlayerAdvancements, T> listeners = Maps.newHashMap();

    protected AbstractCriterionTrigger(ResourceLocation id, Function<PlayerAdvancements, T> createNew) {
        this.id = id;
        this.createNew = createNew;
    }

    public ResourceLocation m_7295_() {
        return this.id;
    }

    public void m_6467_(@Nonnull PlayerAdvancements playerAdvancements, @Nonnull CriterionTrigger.Listener<U> listener) {
        CriterionListeners listeners = (CriterionListeners)this.listeners.get(playerAdvancements);
        if (listeners == null) {
            listeners = (CriterionListeners)this.createNew.apply(playerAdvancements);
            this.listeners.put(playerAdvancements, listeners);
        }
        listeners.add(listener);
    }

    public void m_6468_(@Nonnull PlayerAdvancements playerAdvancements, @Nonnull CriterionTrigger.Listener<U> listener) {
        CriterionListeners listeners = (CriterionListeners)this.listeners.get(playerAdvancements);
        if (listeners != null) {
            listeners.remove(listener);
            if (listeners.isEmpty()) {
                this.listeners.remove(playerAdvancements);
            }
        }
    }

    @Nullable
    protected T getListeners(PlayerAdvancements playerAdvancements) {
        return (T)((CriterionListeners)this.listeners.get(playerAdvancements));
    }

    public void m_5656_(@Nonnull PlayerAdvancements playerAdvancements) {
        this.listeners.remove(playerAdvancements);
    }
}

