/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.inventory.container;

import cofh.core.network.packet.server.ContainerPacket;
import cofh.core.util.filter.AbstractItemFilter;
import cofh.lib.inventory.container.ContainerCoFH;
import cofh.lib.inventory.container.slot.SlotFalseCopy;
import cofh.lib.inventory.container.slot.SlotLocked;
import cofh.lib.inventory.wrapper.InvWrapperGeneric;
import cofh.lib.util.filter.IFilterOptions;
import cofh.lib.util.filter.IFilterableItem;
import cofh.lib.util.helpers.FilterHelper;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.references.CoreReferences;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class HeldItemFilterContainer
extends ContainerCoFH
implements IFilterOptions {
    protected final IFilterableItem filterable;
    protected AbstractItemFilter filter;
    protected InvWrapperGeneric filterInventory;
    protected ItemStack filterStack;
    public SlotLocked lockedSlot;

    public HeldItemFilterContainer(int windowId, Inventory inventory, Player player) {
        super(CoreReferences.HELD_ITEM_FILTER_CONTAINER, windowId, inventory, player);
        this.allowSwap = false;
        this.filterStack = FilterHelper.hasFilter(player.m_21205_()) ? player.m_21205_() : player.m_21206_();
        this.filterable = (IFilterableItem)this.filterStack.m_41720_();
        this.filter = (AbstractItemFilter)this.filterable.getFilter(this.filterStack);
        int slots = this.filter.size();
        this.filterInventory = new InvWrapperGeneric(this, this.filter.getItems(), slots);
        int rows = MathHelper.clamp(slots / 3, 1, 3);
        int rowSize = slots / rows;
        int xOffset = 62 - 9 * rowSize;
        int yOffset = 44 - 9 * rows;
        for (int i = 0; i < this.filter.size(); ++i) {
            this.m_38897_(new SlotFalseCopy(this.filterInventory, i, xOffset + i % rowSize * 18, yOffset + i / rowSize * 18));
        }
        this.bindPlayerInventory(inventory);
    }

    @Override
    protected void bindPlayerInventory(Inventory inventory) {
        int i;
        int xOffset = this.getPlayerInventoryHorizontalOffset();
        int yOffset = this.getPlayerInventoryVerticalOffset();
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)inventory, j + i * 9 + 9, xOffset + j * 18, yOffset + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            if (i == inventory.f_35977_) {
                this.lockedSlot = new SlotLocked((Container)inventory, i, xOffset + i * 18, yOffset + 58);
                this.m_38897_(this.lockedSlot);
                continue;
            }
            this.m_38897_(new Slot((Container)inventory, i, xOffset + i * 18, yOffset + 58));
        }
    }

    public int getFilterSize() {
        return this.filter.size();
    }

    @Override
    protected int getMergeableSlotCount() {
        return this.filterInventory.m_6643_();
    }

    public boolean m_6875_(Player playerIn) {
        return true;
    }

    public void m_6877_(Player playerIn) {
        this.filter.setItems(this.filterInventory.getStacks());
        this.filter.write(this.filterStack.m_41784_());
        this.filterable.onFilterChanged(this.filterStack);
        super.m_6877_(playerIn);
    }

    @Override
    public FriendlyByteBuf getContainerPacket(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.getAllowList());
        buffer.writeBoolean(this.getCheckNBT());
        return buffer;
    }

    @Override
    public void handleContainerPacket(FriendlyByteBuf buffer) {
        this.filter.setAllowList(buffer.readBoolean());
        this.filter.setCheckNBT(buffer.readBoolean());
    }

    @Override
    public boolean getAllowList() {
        return this.filter.getAllowList();
    }

    @Override
    public boolean setAllowList(boolean allowList) {
        boolean ret = this.filter.setAllowList(allowList);
        ContainerPacket.sendToServer(this);
        return ret;
    }

    @Override
    public boolean getCheckNBT() {
        return this.filter.getCheckNBT();
    }

    @Override
    public boolean setCheckNBT(boolean checkNBT) {
        boolean ret = this.filter.setCheckNBT(checkNBT);
        ContainerPacket.sendToServer(this);
        return ret;
    }
}

