/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.fluid;

import cofh.core.CoFHCore;
import cofh.core.util.helpers.FluidHelper;
import cofh.lib.fluid.FluidCoFH;
import cofh.lib.util.references.CoreReferences;
import java.util.Collection;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.ForgeFlowingFluid;

public class PotionFluid
extends FluidCoFH {
    public static int DEFAULT_COLOR = 0xF800F8;

    public static PotionFluid create() {
        return new PotionFluid("potion", "cofh_core:block/fluids/potion_still", "cofh_core:block/fluids/potion_flow");
    }

    protected PotionFluid(String key, String stillTexture, String flowTexture) {
        this.stillFluid = CoFHCore.FLUIDS.register(key, () -> new ForgeFlowingFluid.Source(this.properties));
        this.flowingFluid = CoFHCore.FLUIDS.register(PotionFluid.flowing(key), () -> new ForgeFlowingFluid.Flowing(this.properties));
        this.properties = new ForgeFlowingFluid.Properties((Supplier)this.stillFluid, (Supplier)this.flowingFluid, PotionFluidAttributes.builder(new ResourceLocation(stillTexture), new ResourceLocation(flowTexture)).sound(SoundEvents.f_11770_, SoundEvents.f_11769_));
    }

    public static int getPotionColor(FluidStack stack) {
        if (stack.getTag() != null && stack.getTag().m_128425_("CustomPotionColor", 99)) {
            return stack.getTag().m_128451_("CustomPotionColor");
        }
        return FluidHelper.getPotionFromFluidTag(stack.getTag()) == Potions.f_43598_ ? DEFAULT_COLOR : PotionUtils.m_43564_((Collection)PotionUtils.m_43566_((CompoundTag)stack.getTag()));
    }

    public static FluidStack getPotionAsFluid(int amount, Potion type) {
        if (type == null || type == Potions.f_43598_) {
            return FluidStack.EMPTY;
        }
        if (type == Potions.f_43599_) {
            return new FluidStack((Fluid)Fluids.f_76193_, amount);
        }
        return PotionFluid.addPotionToFluidStack(new FluidStack((Fluid)CoreReferences.FLUID_POTION, amount), type);
    }

    public static FluidStack addPotionToFluidStack(FluidStack stack, Potion type) {
        ResourceLocation resourceLoc = type.getRegistryName();
        if (resourceLoc == null) {
            return FluidStack.EMPTY;
        }
        if (type == Potions.f_43598_) {
            if (stack.getTag() != null) {
                stack.getTag().m_128473_("Potion");
                if (stack.getTag().m_128456_()) {
                    stack.setTag(null);
                }
            }
        } else {
            if (stack.getTag() == null) {
                stack.setTag(new CompoundTag());
            }
            stack.getTag().m_128359_("Potion", resourceLoc.toString());
        }
        return stack;
    }

    public static FluidStack getPotionFluidFromItem(int amount, ItemStack stack) {
        Item item = stack.m_41720_();
        if (item.equals(Items.f_42589_)) {
            return PotionFluid.getPotionAsFluid(amount, PotionUtils.m_43579_((ItemStack)stack));
        }
        return FluidStack.EMPTY;
    }

    protected static class PotionFluidAttributes
    extends FluidAttributes {
        protected PotionFluidAttributes(FluidAttributes.Builder builder, Fluid fluid) {
            super(builder, fluid);
        }

        public Component getDisplayName(FluidStack stack) {
            Potion potion = PotionUtils.m_43577_((CompoundTag)stack.getTag());
            if (potion == Potions.f_43598_ || potion == Potions.f_43599_) {
                return super.getDisplayName(stack);
            }
            return new TranslatableComponent(potion.m_43492_(Items.f_42589_.m_5524_() + ".effect."));
        }

        public Rarity getRarity(FluidStack stack) {
            return FluidHelper.getPotionFromFluidTag(stack.getTag()).m_43488_().isEmpty() ? Rarity.COMMON : Rarity.UNCOMMON;
        }

        public int getColor(FluidStack stack) {
            return 0xFF000000 | PotionFluid.getPotionColor(stack);
        }

        public static FluidAttributes.Builder builder(ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            return new FluidAttributes.Builder(stillTexture, flowingTexture, PotionFluidAttributes::new){};
        }
    }
}

