/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.event;

import cofh.core.config.CoreClientConfig;
import cofh.lib.client.renderer.entity.ITranslucentRenderer;
import cofh.lib.util.Utils;
import cofh.lib.util.constants.Constants;
import cofh.lib.util.helpers.StringHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Either;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelLastEvent;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="cofh_core")
public class CoreClientEvents {
    public static int renderTime;
    public static float renderFrame;
    public static PoseStack levelStack;
    private static final Set<String> NAMESPACES;

    private CoreClientEvents() {
    }

    @SubscribeEvent
    public static void handleItemTooltipEvent(ItemTooltipEvent event) {
        String enchKey;
        Enchantment ench;
        ListTag list;
        String infoKey;
        Object e;
        String keywordKey;
        List tooltip = event.getToolTip();
        if (tooltip.isEmpty()) {
            return;
        }
        ItemStack stack = event.getItemStack();
        if (CoreClientConfig.enableKeywords && NAMESPACES.contains(Utils.getItemNamespace(stack.m_41720_())) && StringHelper.canLocalize(keywordKey = stack.m_41778_() + ".keyword") && (e = tooltip.get(0)) instanceof MutableComponent) {
            MutableComponent mutable = (MutableComponent)e;
            mutable.m_7220_((Component)StringHelper.getKeywordTextComponent(keywordKey));
        }
        if (CoreClientConfig.enableItemDescriptions && NAMESPACES.contains(Utils.getItemNamespace(stack.m_41720_())) && StringHelper.canLocalize(infoKey = stack.m_41778_() + ".desc")) {
            tooltip.add(1, StringHelper.getInfoTextComponent(infoKey));
        }
        if (CoreClientConfig.enableEnchantmentDescriptions && stack.m_41783_() != null && (list = stack.m_41783_().m_128437_("StoredEnchantments", 10)).size() == 1 && (ench = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(ResourceLocation.m_135820_((String)list.m_128728_(0).m_128461_("id")))) != null && ench.getRegistryName() != null && StringHelper.canLocalize(enchKey = ench.m_44704_() + ".desc")) {
            tooltip.add(StringHelper.getInfoTextComponent(enchKey));
        }
        if (CoreClientConfig.enableItemTags && event.getFlags().m_7050_()) {
            Item item = event.getItemStack().m_41720_();
            Set blockTags = Block.m_49814_((Item)item).m_204297_().m_203616_().map(TagKey::f_203868_).collect(Collectors.toSet());
            Set itemTags = item.m_204114_().m_203616_().map(TagKey::f_203868_).collect(Collectors.toSet());
            if (!blockTags.isEmpty() || !itemTags.isEmpty()) {
                if (Screen.m_96637_()) {
                    if (!blockTags.isEmpty()) {
                        tooltip.add(StringHelper.getTextComponent("info.cofh.block_tags").m_130940_(ChatFormatting.GRAY));
                        blockTags.stream().map(Object::toString).map(s -> "  " + s).map(t -> StringHelper.getTextComponent(t).m_130940_(ChatFormatting.DARK_GRAY)).forEach(tooltip::add);
                    }
                    if (!itemTags.isEmpty()) {
                        tooltip.add(StringHelper.getTextComponent("info.cofh.item_tags").m_130940_(ChatFormatting.GRAY));
                        itemTags.stream().map(Object::toString).map(s -> "  " + s).map(t -> StringHelper.getTextComponent(t).m_130940_(ChatFormatting.DARK_GRAY)).forEach(tooltip::add);
                    }
                } else {
                    tooltip.add(StringHelper.getTextComponent("info.cofh.hold_ctrl_for_tags").m_130940_(ChatFormatting.GRAY));
                }
            }
        }
    }

    @SubscribeEvent
    public static void handleRenderTooltipEvent(RenderTooltipEvent.GatherComponents event) {
        if (event.getTooltipElements().isEmpty()) {
            return;
        }
        ((Either)event.getTooltipElements().get(0)).left().ifPresent(text -> {
            if (text instanceof MutableComponent) {
                MutableComponent mutable = (MutableComponent)text;
                mutable.m_7360_().removeIf(string -> string.m_7383_().equals((Object)Constants.INVIS_STYLE));
            }
        });
    }

    @SubscribeEvent
    public static void clientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ++renderTime;
        }
    }

    @SubscribeEvent
    public static void renderTick(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            renderFrame = event.renderTickTime;
        }
    }

    @SubscribeEvent
    public static void renderTranslucentEntities(RenderLevelLastEvent event) {
        ITranslucentRenderer.renderTranslucent(event.getPoseStack(), event.getPartialTick(), event.getLevelRenderer(), event.getProjectionMatrix());
    }

    static {
        levelStack = new PoseStack();
        NAMESPACES = new ObjectOpenHashSet();
        NAMESPACES.add("cofh_core");
        NAMESPACES.add("archers_paradox");
        NAMESPACES.add("ensorcellation");
        NAMESPACES.add("redstone_arsenal");
        NAMESPACES.add("thermal");
    }
}

