/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.event;

import cofh.lib.capability.CapabilityArchery;
import cofh.lib.capability.IArcheryBowItem;
import cofh.lib.capability.templates.ArcheryBowItemWrapper;
import cofh.lib.util.Utils;
import cofh.lib.util.helpers.ArcheryHelper;
import cofh.lib.util.references.EnsorcReferences;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.ArrowNockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="cofh_core")
public class ArcheryEvents {
    private ArcheryEvents() {
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void handleArrowLooseEvent(ArrowLooseEvent event) {
        ItemStack bow = event.getBow();
        if (!ArcheryHelper.validBow(bow)) {
            return;
        }
        Player shooter = event.getPlayer();
        event.setCanceled(((IArcheryBowItem)bow.getCapability(CapabilityArchery.BOW_ITEM_CAPABILITY).orElse((Object)new ArcheryBowItemWrapper(bow))).fireArrow(ArcheryHelper.findAmmo(shooter, bow), shooter, event.getCharge(), event.getWorld()));
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void handleArrowNockEvent(ArrowNockEvent event) {
        ItemStack bow = event.getBow();
        if (!ArcheryHelper.validBow(bow)) {
            return;
        }
        Player shooter = event.getPlayer();
        ItemStack ammo = ArcheryHelper.findAmmo(shooter, bow);
        if (ammo.m_41619_() && Utils.getItemEnchantmentLevel(Enchantments.f_44952_, bow) > 0) {
            ammo = new ItemStack((ItemLike)Items.f_42412_);
        }
        if (!ammo.m_41619_()) {
            shooter.m_6672_(event.getHand());
            event.setAction(InteractionResultHolder.m_19096_((Object)bow));
        } else if (!shooter.m_150110_().f_35937_) {
            event.setAction(InteractionResultHolder.m_19100_((Object)bow));
        }
    }

    @SubscribeEvent
    public static void handleItemUseTickEvent(LivingEntityUseItemEvent.Tick event) {
        int encQuickDraw = Utils.getItemEnchantmentLevel(EnsorcReferences.QUICK_DRAW, event.getItem());
        if (encQuickDraw > 0 && event.getDuration() > event.getItem().m_41779_() - 20) {
            event.setDuration(event.getDuration() - encQuickDraw);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void handleLivingHurtEvent(LivingHurtEvent event) {
        int encVolley;
        if (event.isCanceled()) {
            return;
        }
        Entity entity = event.getEntity();
        DamageSource source = event.getSource();
        Entity attacker = event.getSource().m_7639_();
        if (entity instanceof Projectile) {
            return;
        }
        if (!(attacker instanceof LivingEntity)) {
            return;
        }
        if (source.f_19326_.equals("arrow") && (encVolley = Utils.getHeldEnchantmentLevel((LivingEntity)attacker, EnsorcReferences.VOLLEY)) > 0) {
            entity.f_19802_ = 0;
        }
    }
}

