/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.config;

import cofh.lib.config.IBaseConfig;
import cofh.lib.enchantment.EnchantmentCoFH;
import cofh.lib.util.references.CoreReferences;
import net.minecraftforge.common.ForgeConfigSpec;

public class CoreEnchantConfig
implements IBaseConfig {
    public static boolean improvedFeatherFalling = true;
    public static boolean improvedMending = true;
    private ForgeConfigSpec.BooleanValue serverImprovedFeatherFalling;
    private ForgeConfigSpec.BooleanValue serverImprovedMending;
    private ForgeConfigSpec.BooleanValue enableHolding;
    private ForgeConfigSpec.BooleanValue treasureHolding;
    private ForgeConfigSpec.IntValue levelHolding;

    @Override
    public void apply(ForgeConfigSpec.Builder builder) {
        String treasure = "This sets whether or not the Enchantment is considered a 'treasure' enchantment.";
        String level = "This option adjusts the maximum allowable level for the Enchantment.";
        builder.push("Enchantments");
        this.serverImprovedFeatherFalling = builder.comment("If TRUE, Feather Falling will prevent Farmland from being trampled. This option will work with alternative versions (overrides) of Feather Falling.").define("Improved Feather Falling", improvedFeatherFalling);
        this.serverImprovedMending = builder.comment("If TRUE, Mending behavior is altered so that Experience Orbs always repair items if possible, and the most damaged item is prioritized. This option may not work with alternative versions (overrides) of Mending.").define("Improved Mending", improvedMending);
        builder.push("Holding");
        this.enableHolding = builder.comment("If TRUE, the Holding Enchantment is available for various Storage Items and Blocks.").define("Enable", true);
        this.treasureHolding = builder.comment(treasure).define("Treasure", false);
        this.levelHolding = builder.comment(level).defineInRange("Max Level", 4, 1, 10);
        builder.pop();
        builder.pop();
    }

    @Override
    public void refresh() {
        improvedFeatherFalling = (Boolean)this.serverImprovedFeatherFalling.get();
        improvedMending = (Boolean)this.serverImprovedMending.get();
        if (CoreReferences.HOLDING instanceof EnchantmentCoFH) {
            ((EnchantmentCoFH)CoreReferences.HOLDING).setEnable((Boolean)this.enableHolding.get());
            ((EnchantmentCoFH)CoreReferences.HOLDING).setTreasureEnchantment((Boolean)this.treasureHolding.get());
            ((EnchantmentCoFH)CoreReferences.HOLDING).setMaxLevel((Integer)this.levelHolding.get());
        }
    }
}

