/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.client.particle;

import cofh.core.client.particle.LevelMatrixStackParticle;
import cofh.core.util.helpers.vfx.RenderTypes;
import cofh.core.util.helpers.vfx.VFXHelper;
import cofh.lib.util.helpers.MathHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import java.util.SplittableRandom;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class WindSpiralParticle
extends LevelMatrixStackParticle {
    protected static final float defaultLifetime = 10.0f;
    protected float fLifetime;
    protected int seed;
    protected float yRot;
    protected float xRot;

    private WindSpiralParticle(ClientLevel level, double xPos, double yPos, double zPos, double speed, double yRot, double xRot) {
        super(level, xPos, yPos, zPos, speed, yRot, xRot);
        this.fLifetime = 10.0f / (float)speed;
        this.f_107225_ = MathHelper.ceil(this.fLifetime * 1.25f);
        this.seed = this.f_107223_.nextInt();
        this.yRot = (float)yRot;
        this.xRot = (float)xRot;
        this.m_107250_(1.0f, 1.0f);
        this.f_107219_ = false;
        this.f_107217_ = 0.0;
        this.f_107216_ = 0.0;
        this.f_107215_ = 0.0;
        this.f_107230_ = 0.2f * (1.0f + this.f_107223_.nextFloat());
        this.f_107228_ = this.f_107229_ = 1.0f - 0.1f * this.f_107223_.nextFloat();
        this.f_107227_ = this.f_107229_;
        this.f_107204_ = this.f_107231_ = this.f_107223_.nextFloat() * ((float)Math.PI * 2);
    }

    @Override
    public void render(PoseStack stack, MultiBufferSource buffer, int packedLightIn, float partialTicks) {
        SplittableRandom rand = new SplittableRandom(this.seed);
        float time = (float)this.f_107224_ + partialTicks - (float)rand.nextDouble(0.0, this.fLifetime * 0.25f + 0.001f);
        if (time < 0.0f || time > this.fLifetime) {
            return;
        }
        stack.m_85845_(Vector3f.f_122225_.m_122240_(-this.yRot + 180.0f));
        stack.m_85845_(Vector3f.f_122223_.m_122240_(-this.xRot - 90.0f));
        stack.m_85836_();
        float progress = time / this.fLifetime;
        float easeCub = 1.0f - MathHelper.easeInCubic(progress);
        float easeSin = MathHelper.sin(progress * (float)Math.PI);
        float easePlat = MathHelper.easePlateau(progress);
        float offset = (float)rand.nextDouble(0.0, 0.8f);
        float expand = (progress + offset) * (float)rand.nextDouble(0.3f, 0.5);
        stack.m_85837_(0.0, (double)(expand * (float)rand.nextDouble(1.5, 2.0) - 0.75f), 0.0);
        stack.m_85841_(expand, offset * (float)rand.nextDouble(0.5, 1.0), expand);
        stack.m_85845_(Vector3f.f_122225_.m_122270_(this.f_107231_ + progress * (float)rand.nextDouble(6.0, 9.0)));
        int rgba = VFXHelper.packRGBA(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_ * easeCub);
        int length = (int)(3.0f + easePlat * (float)rand.nextInt(16, 24));
        Vector4f[] poss = new Vector4f[length];
        int half = length / 2;
        for (int i = 0; i < length; ++i) {
            float rot = (float)(i - half) * 0.1309f;
            float r = 1.0f + (float)i * 0.02f;
            poss[i] = new Vector4f(r * MathHelper.cos(rot), (float)i * 0.03f, r * MathHelper.sin(rot), 1.0f);
        }
        VFXHelper.renderStreamLine(stack, buffer.m_6299_(RenderTypes.FLAT_TRANSLUCENT), packedLightIn, poss, rgba, VFXHelper.getWidthFunc((easeSin * 0.08f + 0.01f) * (float)rand.nextDouble(0.3f, 1.0)));
        stack.m_85849_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        public Factory(SpriteSet sprite) {
        }

        @Nullable
        public Particle createParticle(SimpleParticleType data, ClientLevel level, double x, double y, double z, double speed, double yRot, double xRot) {
            return new WindSpiralParticle(level, x, y, z, speed, yRot, xRot);
        }
    }
}

