/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.client.gui;

import cofh.core.client.gui.ContainerScreenCoFH;
import cofh.core.client.gui.element.ElementButton;
import cofh.core.client.gui.element.ElementTexture;
import cofh.core.client.gui.element.SimpleTooltip;
import cofh.core.inventory.container.TileItemFilterContainer;
import cofh.core.network.packet.server.FilterGuiOpenPacket;
import cofh.core.util.helpers.GuiHelper;
import cofh.lib.util.helpers.FilterHelper;
import cofh.lib.util.helpers.SoundHelper;
import java.util.Collections;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;

public class TileItemFilterScreen
extends ContainerScreenCoFH<TileItemFilterContainer> {
    public static final String TEX_PATH = "cofh_core:textures/gui/generic.png";
    public static final ResourceLocation TEXTURE = new ResourceLocation("cofh_core:textures/gui/generic.png");
    public static final String TEX_DENY_LIST = "cofh_core:textures/gui/filters/filter_deny_list.png";
    public static final String TEX_ALLOW_LIST = "cofh_core:textures/gui/filters/filter_allow_list.png";
    public static final String TEX_IGNORE_NBT = "cofh_core:textures/gui/filters/filter_ignore_nbt.png";
    public static final String TEX_USE_NBT = "cofh_core:textures/gui/filters/filter_use_nbt.png";

    public TileItemFilterScreen(TileItemFilterContainer container, Inventory inv, Component titleIn) {
        super(container, inv, titleIn);
        this.texture = TEXTURE;
        this.info = GuiHelper.generatePanelInfo("info.cofh_core.item_filter");
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        for (int i = 0; i < ((TileItemFilterContainer)this.f_97732_).getFilterSize(); ++i) {
            Slot slot = (Slot)((TileItemFilterContainer)this.f_97732_).f_38839_.get(i);
            this.addElement(GuiHelper.createSlot(this, slot.f_40220_, slot.f_40221_));
        }
        this.addButtons();
        this.addElement(new ElementTexture(this, 4, -21).setUV(24, 0).setSize(24, 21).setTexture("cofh_core:textures/gui/elements/tab_top.png", 48, 32).setVisible(() -> FilterHelper.hasFilter(((TileItemFilterContainer)this.f_97732_).getFilterableTile())));
        this.addElement(new ElementTexture(this, 8, -17){

            @Override
            public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
                FilterGuiOpenPacket.openTileGui(((TileItemFilterContainer)TileItemFilterScreen.this.f_97732_).getFilterableTile());
                return true;
            }
        }.setSize(16, 16).setTexture("cofh_core:textures/gui/elements/nav_back.png", 16, 16).setTooltipFactory((element, mouseX, mouseY) -> Collections.singletonList(((TileItemFilterContainer)this.f_97732_).getFilterableTile().m_5446_())).setVisible(() -> FilterHelper.hasFilter(((TileItemFilterContainer)this.f_97732_).getFilterableTile())));
    }

    protected void addButtons() {
        this.addElement(new ElementButton(this, 132, 22){

            @Override
            public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
                ((TileItemFilterContainer)TileItemFilterScreen.this.f_97732_).setAllowList(true);
                SoundHelper.playClickSound(0.7f);
                return true;
            }
        }.setSize(20, 20).setTexture(TEX_DENY_LIST, 40, 20).setTooltipFactory(new SimpleTooltip((Component)new TranslatableComponent("info.cofh.filter.allowlist.0"))).setVisible(() -> !((TileItemFilterContainer)this.f_97732_).getAllowList()));
        this.addElement(new ElementButton(this, 132, 22){

            @Override
            public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
                ((TileItemFilterContainer)TileItemFilterScreen.this.f_97732_).setAllowList(false);
                SoundHelper.playClickSound(0.4f);
                return true;
            }
        }.setSize(20, 20).setTexture(TEX_ALLOW_LIST, 40, 20).setTooltipFactory(new SimpleTooltip((Component)new TranslatableComponent("info.cofh.filter.allowlist.1"))).setVisible(() -> ((TileItemFilterContainer)this.f_97732_).getAllowList()));
        this.addElement(new ElementButton(this, 132, 44){

            @Override
            public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
                ((TileItemFilterContainer)TileItemFilterScreen.this.f_97732_).setCheckNBT(true);
                SoundHelper.playClickSound(0.7f);
                return true;
            }
        }.setSize(20, 20).setTexture(TEX_IGNORE_NBT, 40, 20).setTooltipFactory(new SimpleTooltip((Component)new TranslatableComponent("info.cofh.filter.checkNBT.0"))).setVisible(() -> !((TileItemFilterContainer)this.f_97732_).getCheckNBT()));
        this.addElement(new ElementButton(this, 132, 44){

            @Override
            public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
                ((TileItemFilterContainer)TileItemFilterScreen.this.f_97732_).setCheckNBT(false);
                SoundHelper.playClickSound(0.4f);
                return true;
            }
        }.setSize(20, 20).setTexture(TEX_USE_NBT, 40, 20).setTooltipFactory(new SimpleTooltip((Component)new TranslatableComponent("info.cofh.filter.checkNBT.1"))).setVisible(() -> ((TileItemFilterContainer)this.f_97732_).getCheckNBT()));
    }
}

