/*
 * Decompiled with CFR 0.152.
 */
package mekanism.tools.common.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.common.config.value.CachedValue;
import mekanism.common.lib.attribute.AttributeCache;
import mekanism.common.lib.attribute.IAttributeRefresher;
import mekanism.tools.common.IHasRepairType;
import mekanism.tools.common.material.MaterialCreator;
import mekanism.tools.common.util.ToolsUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class ItemMekanismAxe
extends AxeItem
implements IHasRepairType,
IAttributeRefresher {
    private final MaterialCreator material;
    private final AttributeCache attributeCache;

    public ItemMekanismAxe(MaterialCreator material, Item.Properties properties) {
        super((Tier)material, material.getAxeDamage(), material.getAxeAtkSpeed(), properties);
        this.material = material;
        this.attributeCache = new AttributeCache((IAttributeRefresher)this, new CachedValue[]{material.attackDamage, material.axeDamage, material.axeAtkSpeed});
    }

    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level world, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
        super.m_7373_(stack, world, tooltip, flag);
        ToolsUtils.addDurability(tooltip, stack);
    }

    public float m_41008_() {
        return this.material.getAxeDamage() + this.m_43314_().m_6631_();
    }

    public float m_8102_(@Nonnull ItemStack stack, @Nonnull BlockState state) {
        return super.m_8102_(stack, state) == 1.0f ? 1.0f : this.m_43314_().m_6624_();
    }

    @Override
    @Nonnull
    public Ingredient getRepairMaterial() {
        return this.m_43314_().m_6282_();
    }

    public int getMaxDamage(ItemStack stack) {
        return this.m_43314_().m_6609_();
    }

    public boolean m_41465_() {
        return this.m_43314_().m_6609_() > 0;
    }

    @Nonnull
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(@Nonnull EquipmentSlot slot, @Nonnull ItemStack stack) {
        return slot == EquipmentSlot.MAINHAND ? this.attributeCache.getAttributes() : ImmutableMultimap.of();
    }

    public void addToBuilder(ImmutableMultimap.Builder<Attribute, AttributeModifier> builder) {
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Tool modifier", (double)this.m_41008_(), AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Tool modifier", (double)this.material.getAxeAtkSpeed(), AttributeModifier.Operation.ADDITION));
    }
}

