/*
 * Decompiled with CFR 0.152.
 */
package me.hypherionmc.simplerpclib.discordutils;

import java.io.File;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import me.hypherionmc.simplerpclib.configuration.ClientConfig;
import me.hypherionmc.simplerpclib.configuration.ConfigEngine;
import me.hypherionmc.simplerpclib.configuration.ServerConfig;
import me.hypherionmc.simplerpclib.configuration.ServerEntriesConfig;
import me.hypherionmc.simplerpclib.discordutils.DiscordHandler;
import me.hypherionmc.simplerpclib.discordutils.RichPresenceEvents;
import me.hypherionmc.simplerpclib.integrations.launchers.LauncherAssets;
import me.hypherionmc.simplerpclib.integrations.launchers.LauncherUtils;
import me.hypherionmc.simplerpclib.util.FileWatcherService;
import me.hypherionmc.simplerpclib.util.IUtilHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RichPresenceCore
implements FileWatcherService.FileWatcherCallback {
    public static final ScheduledExecutorService taskManager = Executors.newScheduledThreadPool(Runtime.getRuntime().availableProcessors());
    public static final Logger logger = LogManager.getLogger((String)"Simple RPC");
    private static ServerConfig serverConfig;
    private final IUtilHandler utilHandler;
    private final String configPath;
    private final String langCode;
    private ClientConfig clientConfig;
    private ServerEntriesConfig serverEntriesConfig;
    private DiscordHandler discordHandler;
    private RichPresenceEvents events;
    private long lastDiscordID = 0L;
    private FileWatcherService configWatcher;
    private FileWatcherService entriesWatcher;
    private LauncherUtils.LauncherType launcherType;
    private LauncherAssets launcherAssets;

    public RichPresenceCore(IUtilHandler utilHandler, String configPath, String langCode) {
        this.utilHandler = utilHandler;
        this.configPath = configPath;
        this.langCode = langCode;
        this.clientConfig = ConfigEngine.loadConfig(this);
        this.serverEntriesConfig = ConfigEngine.loadServerEntries(this);
        if (this.clientConfig != null) {
            this.discordHandler = new DiscordHandler(this.clientConfig);
            this.events = new RichPresenceEvents(this);
            this.lastDiscordID = this.clientConfig.general.discordid;
            this.launcherType = LauncherUtils.getLauncherType(this);
            this.launcherAssets = LauncherUtils.getLauncherInfo(this.launcherType);
            this.configWatcher = new FileWatcherService(new File(this.clientConfig.configPath), this);
            this.entriesWatcher = new FileWatcherService(new File(this.serverEntriesConfig.configPath), new ServerEntriesWatcher(this));
            taskManager.scheduleAtFixedRate(() -> {
                if (this.configWatcher != null && !this.configWatcher.isAlive()) {
                    this.configWatcher.start();
                }
                if (this.entriesWatcher != null && !this.entriesWatcher.isAlive()) {
                    this.entriesWatcher.start();
                }
            }, 0L, 10L, TimeUnit.SECONDS);
            taskManager.scheduleAtFixedRate(() -> {
                if (this.events != null) {
                    this.events.updateRPC();
                }
            }, 1L, 2L, TimeUnit.SECONDS);
        }
    }

    public ClientConfig getClientConfig() {
        return this.clientConfig;
    }

    public RichPresenceEvents getEvents() {
        return this.events;
    }

    public DiscordHandler getDiscordHandler() {
        return this.discordHandler;
    }

    public IUtilHandler getUtilHandler() {
        return this.utilHandler;
    }

    public String getConfigPath() {
        return this.configPath;
    }

    public String getLangCode() {
        return this.langCode;
    }

    public LauncherUtils.LauncherType getLauncherType() {
        return this.launcherType;
    }

    public LauncherAssets getLauncherAssets() {
        return this.launcherAssets;
    }

    public ServerEntriesConfig getServerEntriesConfig() {
        return this.serverEntriesConfig;
    }

    public ServerConfig getServerConfig() {
        return serverConfig;
    }

    public static void setServerConfig(ServerConfig serverConfig) {
        RichPresenceCore.serverConfig = serverConfig;
    }

    @Override
    public void onConfigChanged() {
        this.clientConfig = ConfigEngine.loadConfig(this);
        if (this.clientConfig != null && this.lastDiscordID != this.clientConfig.general.discordid) {
            this.discordHandler.shutdownRichPresence();
            this.discordHandler = new DiscordHandler(this.clientConfig);
            this.lastDiscordID = this.clientConfig.general.discordid;
            this.events.updateRPC();
        }
    }

    public static class ServerEntriesWatcher
    implements FileWatcherService.FileWatcherCallback {
        private final RichPresenceCore core;

        public ServerEntriesWatcher(RichPresenceCore core) {
            this.core = core;
        }

        @Override
        public void onConfigChanged() {
            this.core.serverEntriesConfig = ConfigEngine.loadServerEntries(this.core);
            this.core.getEvents().updateRPC();
        }
    }
}

