/*
 * Decompiled with CFR 0.152.
 */
package me.hypherionmc.simplerpclib.configuration.objects;

import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import me.hypherionmc.simplerpclib.configuration.objects.Dimension;
import me.hypherionmc.simplerpclib.configuration.objects.RPCButton;
import me.hypherionmc.simplerpclib.configuration.objects.ServerEntry;
import me.hypherionmc.simplerpclib.discordutils.RichPresenceBuilder;
import me.hypherionmc.simplerpclib.discordutils.RichPresenceCore;
import me.hypherionmc.simplerpclib.integrations.launchers.LauncherUtils;
import me.hypherionmc.simplerpclib.util.APIUtils;
import me.hypherionmc.simplerpclib.util.IRPCContainer;
import me.hypherionmc.simplerpclib.util.helpers.KnownServerHelpers;
import me.hypherionmc.simplerpclib.util.helpers.ServerInfo;
import shadow.hypherionmc.nightconfig.core.conversion.Path;
import shadow.hypherionmc.nightconfig.core.conversion.SpecComment;

public class MultiPlayerSection
implements IRPCContainer,
Serializable {
    @Path(value="enabled")
    @SpecComment(value="Enable/Disable the Multi Player Event")
    public boolean enabled = true;
    @Path(value="description")
    @SpecComment(value="The first line of text under the app name")
    public String description = "Playing on %servername% with %players% players";
    @Path(value="state")
    @SpecComment(value="The second line of text under the app name")
    public String state = "Playing online";
    @Path(value="largeImageKey")
    @SpecComment(value="The Asset ID of the image to display as the large image")
    public String largeImageKey = "mclogonew";
    @Path(value="largeImageText")
    @SpecComment(value="The text that gets displayed when the large image is hovered")
    public String largeImageText = "It's Minecraft %mcver%, but modded";
    @Path(value="smallImageKey")
    @SpecComment(value="The Asset ID of the image to display as the small image")
    public String smallImageKey = "mclogo";
    @Path(value="smallImageText")
    @SpecComment(value="The text that gets displayed when the small image is hovered")
    public String smallImageText = "%mods% mods installed";
    @Path(value="buttons")
    @SpecComment(value="The buttons to display on Discord")
    public List<RPCButton> buttonsList = new ArrayList<RPCButton>();

    @Override
    public RichPresenceBuilder getPresence(RichPresenceCore core) {
        Dimension dim;
        Optional<Dimension> dimension;
        RichPresenceBuilder finalBuild;
        RichPresenceBuilder build = new RichPresenceBuilder().setDetails(core.getUtilHandler().parseVars(this.description)).setLargeImage(core.getUtilHandler().parseVars(this.largeImageKey)).setLargeImageText(core.getUtilHandler().parseVars(this.largeImageText)).setSmallImage(core.getUtilHandler().parseVars(this.smallImageKey)).setSmallImageText(core.getUtilHandler().parseVars(this.smallImageText)).setTimeStamp(OffsetDateTime.now()).setButtons(APIUtils.parseButtons(this.buttonsList, core.getUtilHandler())).setState(core.getUtilHandler().parseVars(this.state));
        build = LauncherUtils.getLauncherOverrides(build, core);
        if (core.getClientConfig().dimension_overrides.enabled) {
            finalBuild = build;
            dimension = APIUtils.findDimension(core.getClientConfig().dimension_overrides.dimensions, core.getUtilHandler().getWorld());
            if (dimension.isPresent()) {
                dim = dimension.get();
                if (dim.description != null && !dim.description.isEmpty()) {
                    finalBuild.setDetails(core.getUtilHandler().parseVars(dim.description));
                }
                if (dim.state != null && !dim.state.isEmpty()) {
                    finalBuild.setState(core.getUtilHandler().parseVars(dim.state));
                }
                if (dim.largeImageKey != null && !dim.largeImageKey.isEmpty()) {
                    finalBuild.setLargeImage(core.getUtilHandler().parseVars(dim.largeImageKey));
                }
                if (dim.largeImageText != null && !dim.largeImageText.isEmpty()) {
                    finalBuild.setLargeImageText(core.getUtilHandler().parseVars(dim.largeImageText));
                }
                if (dim.smallImageKey != null && !dim.smallImageKey.isEmpty()) {
                    finalBuild.setSmallImage(core.getUtilHandler().parseVars(dim.smallImageKey));
                }
                if (dim.smallImageText != null && !dim.smallImageText.isEmpty()) {
                    finalBuild.setSmallImageText(core.getUtilHandler().parseVars(dim.smallImageText));
                }
                build = finalBuild;
            }
        }
        if (core.getClientConfig().general.discordid == 762726289341677668L && KnownServerHelpers.isKnownServer(core.getUtilHandler().parseVars("%serverip%"))) {
            ServerInfo info = KnownServerHelpers.getKnownServer(core.getUtilHandler().parseVars("%serverip%"));
            build.setLargeImage(info.serverIcon);
            build.setLargeImageText(core.getUtilHandler().parseVars("Playing on " + info.severName + " with %players% players"));
        }
        if (core.getServerConfig() != null && core.getServerConfig().enabled && core.getServerConfig().multi_player.enabled) {
            if (core.getServerConfig().multi_player.description != null && !core.getServerConfig().multi_player.description.isEmpty()) {
                build.setDetails(core.getUtilHandler().parseVars(core.getServerConfig().multi_player.description));
            }
            if (core.getServerConfig().multi_player.largeImageKey != null && !core.getServerConfig().multi_player.largeImageKey.isEmpty()) {
                build.setLargeImage(core.getUtilHandler().parseVars(core.getServerConfig().multi_player.largeImageKey));
            }
            if (core.getServerConfig().multi_player.largeImageText != null && !core.getServerConfig().multi_player.largeImageText.isEmpty()) {
                build.setLargeImageText(core.getUtilHandler().parseVars(core.getServerConfig().multi_player.largeImageText));
            }
            if (core.getServerConfig().multi_player.smallImageKey != null && !core.getServerConfig().multi_player.smallImageKey.isEmpty()) {
                build.setSmallImage(core.getUtilHandler().parseVars(core.getServerConfig().multi_player.smallImageKey));
            }
            if (core.getServerConfig().multi_player.smallImageText != null && !core.getServerConfig().multi_player.smallImageText.isEmpty()) {
                build.setSmallImageText(core.getUtilHandler().parseVars(core.getServerConfig().multi_player.smallImageText));
            }
            if (core.getServerConfig().multi_player.state != null && !core.getServerConfig().multi_player.state.isEmpty()) {
                build.setState(core.getUtilHandler().parseVars(core.getServerConfig().multi_player.state));
            }
            if (core.getServerConfig().multi_player.buttonsList != null && !core.getServerConfig().multi_player.buttonsList.isEmpty()) {
                build.setButtons(APIUtils.parseButtons(core.getServerConfig().multi_player.buttonsList, core.getUtilHandler()));
            }
        }
        if (core.getServerConfig() != null && core.getServerConfig().enabled && core.getServerConfig().dimension_overrides.enabled) {
            finalBuild = build;
            dimension = APIUtils.findDimension(core.getServerConfig().dimension_overrides.dimensions, core.getUtilHandler().getWorld());
            if (dimension.isPresent()) {
                dim = dimension.get();
                if (dim.description != null && !dim.description.isEmpty()) {
                    finalBuild.setDetails(core.getUtilHandler().parseVars(dim.description));
                }
                if (dim.state != null && !dim.state.isEmpty()) {
                    finalBuild.setState(core.getUtilHandler().parseVars(dim.state));
                }
                if (dim.largeImageKey != null && !dim.largeImageKey.isEmpty()) {
                    finalBuild.setLargeImage(core.getUtilHandler().parseVars(dim.largeImageKey));
                }
                if (dim.largeImageText != null && !dim.largeImageText.isEmpty()) {
                    finalBuild.setLargeImageText(core.getUtilHandler().parseVars(dim.largeImageText));
                }
                if (dim.smallImageKey != null && !dim.smallImageKey.isEmpty()) {
                    finalBuild.setSmallImage(core.getUtilHandler().parseVars(dim.smallImageKey));
                }
                if (dim.smallImageText != null && !dim.smallImageText.isEmpty()) {
                    finalBuild.setSmallImageText(core.getUtilHandler().parseVars(dim.smallImageText));
                }
                build = finalBuild;
            }
        }
        if (core.getServerEntriesConfig() != null && core.getServerEntriesConfig().enabled) {
            finalBuild = build;
            String address = core.getUtilHandler().parseVars("%serverip%");
            Optional<ServerEntry> serverEntry = APIUtils.findServer(core.getServerEntriesConfig().serverEntries, address);
            serverEntry.ifPresent(entry -> {
                if (entry.description != null && !entry.description.isEmpty()) {
                    finalBuild.setDetails(core.getUtilHandler().parseVars(entry.description));
                }
                if (entry.largeImageKey != null && !entry.largeImageKey.isEmpty()) {
                    finalBuild.setLargeImage(core.getUtilHandler().parseVars(entry.largeImageKey));
                }
                if (entry.largeImageText != null && !entry.largeImageText.isEmpty()) {
                    finalBuild.setLargeImageText(core.getUtilHandler().parseVars(entry.largeImageText));
                }
                if (entry.smallImageKey != null && !entry.smallImageKey.isEmpty()) {
                    finalBuild.setSmallImage(core.getUtilHandler().parseVars(entry.smallImageKey));
                }
                if (entry.smallImageText != null && !entry.smallImageText.isEmpty()) {
                    finalBuild.setSmallImageText(core.getUtilHandler().parseVars(entry.smallImageText));
                }
                if (entry.state != null && !entry.state.isEmpty()) {
                    finalBuild.setState(core.getUtilHandler().parseVars(entry.state));
                }
            });
        }
        return this.enabled ? build : null;
    }
}

