/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat;

import blusunrize.immersiveengineering.common.config.CachedConfig;
import blusunrize.immersiveengineering.common.config.IECommonConfig;
import blusunrize.immersiveengineering.common.util.IELogger;
import blusunrize.immersiveengineering.common.util.compat.CuriosCompatModule;
import blusunrize.immersiveengineering.common.util.compat.OneProbeCompatModule;
import blusunrize.immersiveengineering.common.util.compat.computers.cctweaked.ComputerCraftCompatModule;
import blusunrize.immersiveengineering.common.util.compat.computers.oc2.OC2CompatModule;
import com.google.common.collect.Sets;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraftforge.fml.ModList;

public final class IECompatModules {
    private static final Map<String, Class<? extends StandardIECompatModule>> STANDARD_MODULE_CLASSES = new HashMap<String, Class<? extends StandardIECompatModule>>();
    private static final Map<String, Class<? extends EarlyIECompatModule>> EARLY_MODULE_CLASSES = new HashMap<String, Class<? extends EarlyIECompatModule>>();
    private static final Set<IECompatModule> LOADED_MODULES = new HashSet<IECompatModule>();

    public static void onModConstruction() {
        IECompatModules.constructModules(EARLY_MODULE_CLASSES, $ -> true);
    }

    private static <T extends IECompatModule> void constructModules(Map<String, Class<? extends T>> modules, Predicate<CachedConfig.BooleanValue> shouldLoad) {
        for (Map.Entry<String, Class<T>> e : modules.entrySet()) {
            if (!ModList.get().isLoaded(e.getKey())) continue;
            try {
                CachedConfig.BooleanValue enabled = Objects.requireNonNull(IECommonConfig.compat.get(e.getKey()));
                if (!shouldLoad.test(enabled)) continue;
                Constructor<T> configConstructor = IECompatModules.getConstructorIfExists(e.getValue(), CachedConfig.BooleanValue.class);
                IECompatModule module = configConstructor != null ? (IECompatModule)configConstructor.newInstance(enabled) : (IECompatModule)e.getValue().getConstructor(new Class[0]).newInstance(new Object[0]);
                LOADED_MODULES.add(module);
            }
            catch (Exception exception) {
                IELogger.logger.error("Compat module for " + e.getKey() + " could not be preInitialized. Report this and include the error message below!", (Throwable)exception);
            }
        }
    }

    public static void onCommonSetup() {
        IECompatModules.constructModules(STANDARD_MODULE_CLASSES, CachedConfig.ConfigValue::get);
        for (IECompatModule compat : LOADED_MODULES) {
            try {
                compat.init();
            }
            catch (Exception exception) {
                IELogger.logger.error("Compat module for " + compat + " could not be initialized. Report this and include the error message below!", (Throwable)exception);
            }
        }
    }

    public static void doModulesIMCs() {
        for (IECompatModule compat : LOADED_MODULES) {
            try {
                compat.sendIMCs();
            }
            catch (Exception exception) {
                IELogger.logger.error("Compat module for " + compat + " could not send IMCs. Report this and include the error message below!", (Throwable)exception);
            }
        }
    }

    public static Collection<String> getAvailableModules() {
        return Sets.union(STANDARD_MODULE_CLASSES.keySet(), EARLY_MODULE_CLASSES.keySet());
    }

    @Nullable
    private static <T> Constructor<T> getConstructorIfExists(Class<T> toConstruct, Class<?> ... args) {
        try {
            return toConstruct.getConstructor(args);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    static {
        STANDARD_MODULE_CLASSES.put("computercraft", ComputerCraftCompatModule.class);
        STANDARD_MODULE_CLASSES.put("curios", CuriosCompatModule.class);
        STANDARD_MODULE_CLASSES.put("theoneprobe", OneProbeCompatModule.class);
        EARLY_MODULE_CLASSES.put("oc2", OC2CompatModule.class);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static abstract class IECompatModule {
        public void init() {
        }

        public void sendIMCs() {
        }
    }

    public static abstract class StandardIECompatModule
    extends IECompatModule {
    }

    public static abstract class EarlyIECompatModule
    extends IECompatModule {
    }
}

