/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.utils.CapabilityUtils;
import blusunrize.immersiveengineering.common.items.IEBaseItem;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.ItemGetterList;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.SimpleCapProvider;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class PowerpackItem
extends IEBaseItem {
    public static final ItemGetterList POWERPACK_GETTER = new ItemGetterList(player -> {
        ItemStack chest = player.m_6844_(EquipmentSlot.CHEST);
        if (chest.m_41720_() instanceof PowerpackItem) {
            return chest;
        }
        if (ItemNBTHelper.hasKey(chest, "IE:Powerpack")) {
            return ItemNBTHelper.getItemStack(chest, "IE:Powerpack");
        }
        return ItemStack.f_41583_;
    });

    public PowerpackItem() {
        super(new Item.Properties().m_41487_(1));
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> list, TooltipFlag flag) {
        IEnergyStorage energy = (IEnergyStorage)CapabilityUtils.getPresentCapability((ICapabilityProvider)stack, CapabilityEnergy.ENERGY);
        String stored = energy.getEnergyStored() + "/" + PowerpackItem.getMaxEnergyStored(stack);
        list.add((Component)new TranslatableComponent("desc.immersiveengineering.info.energyStored", new Object[]{stored}).m_130940_(ChatFormatting.GRAY));
    }

    @Nullable
    public EquipmentSlot getEquipmentSlot(ItemStack stack) {
        return EquipmentSlot.CHEST;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack heldItem = player.m_21120_(hand);
        EquipmentSlot slot = Mob.m_147233_((ItemStack)heldItem);
        if (!player.m_6844_(slot).m_41619_()) {
            return InteractionResultHolder.m_19100_((Object)heldItem);
        }
        player.m_8061_(slot, heldItem.m_41777_());
        if (!world.m_5776_()) {
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        }
        heldItem.m_41764_(0);
        return InteractionResultHolder.m_19092_((Object)heldItem, (boolean)world.m_5776_());
    }

    public void onArmorTick(ItemStack itemStack, Level world, Player player) {
        int energy = EnergyHelper.getEnergyStored((ICapabilityProvider)itemStack);
        if (energy > 0) {
            int pre = energy;
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                ItemStack equipped = player.m_6844_(slot);
                if (!EnergyHelper.isFluxReceiver((ICapabilityProvider)equipped) || equipped.m_41720_() instanceof PowerpackItem) continue;
                energy -= EnergyHelper.insertFlux((ICapabilityProvider)equipped, Math.min(energy, 256), false);
            }
            if (pre != energy) {
                EnergyHelper.extractFlux((ICapabilityProvider)itemStack, pre - energy, false);
            }
        }
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int itemSlot, boolean isSelected) {
        if (itemSlot == -1 && entity instanceof Player) {
            this.onArmorTick(stack, world, (Player)entity);
        }
    }

    public static int getMaxEnergyStored(ItemStack container) {
        return 100000;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag nbt) {
        if (!stack.m_41619_()) {
            return new SimpleCapProvider<EnergyHelper.ItemEnergyStorage>(() -> CapabilityEnergy.ENERGY, new EnergyHelper.ItemEnergyStorage(stack, PowerpackItem::getMaxEnergyStored));
        }
        return super.initCapabilities(stack, nbt);
    }
}

