/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.api.shader.CapabilityShader;
import blusunrize.immersiveengineering.api.shader.ShaderRegistry;
import blusunrize.immersiveengineering.api.utils.CapabilityUtils;
import blusunrize.immersiveengineering.common.fluids.IEItemFluidHandler;
import blusunrize.immersiveengineering.common.items.IEItemInterfaces;
import blusunrize.immersiveengineering.common.items.UpgradeableToolItem;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IEItemStackHandler;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.TierSortingRegistry;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public abstract class DieselToolItem
extends UpgradeableToolItem
implements IEItemInterfaces.IAdvancedFluidItem {
    protected static final int CAPACITY = 2000;
    private final Map<UUID, Integer> animationTimer = new HashMap<UUID, Integer>();

    public DieselToolItem(Item.Properties props, String upgradeType) {
        super(props, upgradeType);
    }

    public int m_6473_() {
        return 0;
    }

    @Nullable
    public CompoundTag getShareTag(ItemStack stack) {
        CompoundTag ret = super.getShareTag(stack);
        ret = ret == null ? new CompoundTag() : ret.m_6426_();
        ItemStack head = this.getHead(stack);
        if (!head.m_41619_()) {
            ret.m_128365_("head", (Tag)head.m_41739_(new CompoundTag()));
        }
        return ret;
    }

    public void readShareTag(ItemStack stack, @Nullable CompoundTag nbt) {
        if (nbt != null) {
            this.setHead(stack, ItemStack.m_41712_((CompoundTag)nbt.m_128469_("head")));
            nbt.m_128473_("head");
        }
        super.readShareTag(stack, nbt);
    }

    @Override
    public ICapabilityProvider initCapabilities(final ItemStack stack, CompoundTag nbt) {
        if (!stack.m_41619_()) {
            return new IEItemStackHandler(stack){
                private final LazyOptional<IEItemFluidHandler> fluids;
                private final LazyOptional<CapabilityShader.ShaderWrapper_Item> shaders;
                {
                    super(stack2);
                    this.fluids = CapabilityUtils.constantOptional(new IEItemFluidHandler(stack, 2000));
                    this.shaders = CapabilityUtils.constantOptional(new CapabilityShader.ShaderWrapper_Item(DieselToolItem.this.getRegistryName(), stack));
                }

                @Override
                @Nonnull
                public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, Direction facing) {
                    if (capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY) {
                        return this.fluids.cast();
                    }
                    if (capability == CapabilityShader.SHADER_CAPABILITY) {
                        return this.shaders.cast();
                    }
                    return super.getCapability(capability, facing);
                }
            };
        }
        return null;
    }

    public int m_142158_(@Nonnull ItemStack stack) {
        return Math.round(13.0f * (1.0f - (float)this.getHeadDamage(stack) / (float)this.getMaxHeadDamage(stack)));
    }

    public boolean m_142522_(@Nonnull ItemStack stack) {
        return this.getHeadDamage(stack) > 0;
    }

    @Override
    public boolean canModify(ItemStack stack) {
        return true;
    }

    @Override
    public void finishUpgradeRecalculation(ItemStack stack) {
        super.finishUpgradeRecalculation(stack);
        FluidStack fs = this.getFluid(stack);
        if (fs != null && fs.getAmount() > this.getCapacity(stack, 2000)) {
            fs.setAmount(this.getCapacity(stack, 2000));
            ItemNBTHelper.setFluidStack(stack, "Fluid", fs);
        }
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity player) {
        this.consumeDurability(stack, target.m_20193_(), null, null, player);
        return true;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    @Override
    public int getCapacity(ItemStack container, int baseCapacity) {
        return baseCapacity + this.getUpgrades(container).m_128451_("capacity");
    }

    @Override
    public boolean allowFluid(ItemStack container, FluidStack fluid) {
        return fluid != null && fluid.getFluid().m_205067_(IETags.drillFuel);
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        Tier tier = this.getHarvestLevel(stack, null);
        if (tier == null) {
            return false;
        }
        return this.isEffective(stack, state) && this.canToolBeUsed(stack) && TierSortingRegistry.isCorrectTierForDrops((Tier)tier, (BlockState)state);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        ItemStack head;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        if (slot == EquipmentSlot.MAINHAND && !(head = this.getHead(stack)).m_41619_() && this.canToolBeUsed(stack)) {
            builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Tool modifier", this.getAttackDamage(stack, head), AttributeModifier.Operation.ADDITION));
            builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Tool modifier", -2.5, AttributeModifier.Operation.ADDITION));
        }
        return builder.build();
    }

    @Override
    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        if (slotChanged) {
            return true;
        }
        LazyOptional wrapperOld = oldStack.getCapability(CapabilityShader.SHADER_CAPABILITY);
        Optional sameShader = wrapperOld.map(wOld -> {
            LazyOptional wrapperNew = newStack.getCapability(CapabilityShader.SHADER_CAPABILITY);
            return wrapperNew.map(w -> ItemStack.m_41728_((ItemStack)wOld.getShaderItem(), (ItemStack)w.getShaderItem())).orElse(true);
        });
        if (!sameShader.orElse(true).booleanValue()) {
            return true;
        }
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        if (this.canToolBeUsed(stack)) {
            if (!this.animationTimer.containsKey(entity.m_142081_())) {
                this.animationTimer.put(entity.m_142081_(), 40);
            } else if (this.animationTimer.get(entity.m_142081_()) < 20) {
                this.animationTimer.put(entity.m_142081_(), 20);
            }
        }
        return true;
    }

    protected void consumeDurability(ItemStack stack, Level world, @Nullable BlockState state, @Nullable BlockPos pos, LivingEntity living) {
        Preconditions.checkArgument((pos == null == (state == null) ? 1 : 0) != 0);
        if (state == null || state.m_60800_((BlockGetter)world, pos) != 0.0f) {
            int dmg = state == null || this.isEffective(stack, state) ? 1 : 3;
            ItemStack head = this.getHead(stack);
            if (!head.m_41619_()) {
                if (!this.getUpgrades(stack).m_128471_("oiled") || Utils.RAND.nextInt(4) == 0) {
                    this.damageHead(head, dmg, living);
                }
                this.setHead(stack, head);
                IFluidHandler handler = (IFluidHandler)FluidUtil.getFluidHandler((ItemStack)stack).orElseThrow(RuntimeException::new);
                handler.drain(1, IFluidHandler.FluidAction.EXECUTE);
                ShaderRegistry.ShaderAndCase shader = ShaderRegistry.getStoredShaderAndCase(stack);
                if (shader != null) {
                    Vec3 particlePos = pos != null ? Vec3.m_82512_((Vec3i)pos) : living.m_20182_();
                    shader.registryEntry().getEffectFunction().execute(world, shader.shader(), stack, shader.sCase().getShaderType().toString(), particlePos, null, 0.375f);
                }
            }
        }
    }

    protected abstract void damageHead(ItemStack var1, int var2, LivingEntity var3);

    protected abstract double getAttackDamage(ItemStack var1, ItemStack var2);

    public abstract boolean isEffective(ItemStack var1, BlockState var2);

    public abstract Tier getHarvestLevel(ItemStack var1, @Nullable Player var2);

    public abstract boolean canToolBeUsed(ItemStack var1);

    protected abstract ItemStack getHead(ItemStack var1);

    protected abstract void setHead(ItemStack var1, ItemStack var2);

    public abstract int getMaxHeadDamage(ItemStack var1);

    public abstract int getHeadDamage(ItemStack var1);
}

