/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.config;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.common.config.CachedConfig;
import blusunrize.immersiveengineering.common.wires.IEWireTypes;
import com.google.common.collect.ImmutableList;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="immersiveengineering", bus=Mod.EventBusSubscriber.Bus.MOD)
public class IEClientConfig {
    public static final CachedConfig.BooleanValue showUpdateNews;
    public static final CachedConfig.BooleanValue fancyItemHolding;
    public static final CachedConfig.BooleanValue stencilBufferEnabled;
    public static final CachedConfig.ConfigValue<List<? extends String>> earDefenders_SoundBlacklist;
    public static final CachedConfig.BooleanValue enableVBOs;
    public static final CachedConfig.BooleanValue disableFancyTESR;
    public static final CachedConfig.BooleanValue showTextOverlay;
    public static final CachedConfig.BooleanValue nixietubeFont;
    public static final CachedConfig.IntValue manualGuiScale;
    public static final CachedConfig.BooleanValue badEyesight;
    public static boolean lastBadEyesight;
    public static final CachedConfig.BooleanValue tagTooltips;
    public static final CachedConfig.DoubleValue increasedTileRenderdistance;
    public static final Map<IEWireTypes.IEWireType, CachedConfig.IntValue> wireColors;
    public static final CachedConfig CONFIG_SPEC;

    private static void addColor(CachedConfig.Builder builder, IEWireTypes.IEWireType type, int defaultColor) {
        wireColors.put(type, builder.defineInRange(type.name().toLowerCase(Locale.ENGLISH), defaultColor, Integer.MIN_VALUE, Integer.MAX_VALUE));
    }

    @SubscribeEvent
    public static void onConfigChange(ModConfigEvent ev) {
        if (CONFIG_SPEC.reloadIfMatched(ev, ModConfig.Type.CLIENT) && lastBadEyesight != (Boolean)badEyesight.get()) {
            lastBadEyesight = (Boolean)badEyesight.get();
            ImmersiveEngineering.proxy.resetManual();
        }
    }

    static {
        wireColors = new EnumMap<IEWireTypes.IEWireType, CachedConfig.IntValue>(IEWireTypes.IEWireType.class);
        CachedConfig.Builder builder = new CachedConfig.Builder();
        disableFancyTESR = builder.comment("Disables most lighting code for certain models that are rendered dynamically (TESR). May improve FPS.", "Affects turrets and garden cloches").define("disableFancyTESR", false);
        showTextOverlay = builder.comment("Show the text overlay for various blocks, such as the configuration of capacitors or pumps").define("showTextOverlay", true);
        nixietubeFont = builder.comment("Set this to false to disable the super awesome looking nixie tube front for the voltmeter and other things").define("nixietubeFont", true);
        manualGuiScale = builder.comment("Set the GUI scale of the Engineer's Manual. This uses the same numbers as Vanilla's GUI Scale and is therefor limited to the maximum value available ingame.").defineInRange("manualGuiScale", 4, 1, 32);
        badEyesight = builder.comment("Set this to true if you suffer from bad eyesight. The Engineer's manual will be switched to a bold and darker text to improve readability.").define("badEyesight", false);
        tagTooltips = builder.comment("Controls if item tooltips should contain the tags names of items. These tooltips are only visible in advanced tooltip mode (F3+H)").define("tagTooltips", true);
        increasedTileRenderdistance = builder.comment("Increase the distance at which certain TileEntities (specifically windmills) are still visible. This is a modifier, so set it to 1 for default render distance, to 2 for doubled distance and so on.").defineInRange("increasedTileRenderdistance", 1.5, 0.0, Double.MAX_VALUE);
        showUpdateNews = builder.comment("Set this to false to hide the update news in the manual").define("showUpdateNews", true);
        fancyItemHolding = builder.comment("Allows revolvers and other IE items to look properly held in 3rd person. This uses a coremod. Can be disabled in case of conflicts with other animation mods.").define("fancyItemHolding", true);
        stencilBufferEnabled = builder.comment("Set to false to disable the stencil buffer. This may be necessary on older GPUs.").define("stencilBufferEnabled", true);
        earDefenders_SoundBlacklist = builder.comment("A list of sounds that should not be muffled by the Ear Defenders. Adding to this list requires knowledge of the correct sound resource names.").defineList("earDefenders_SoundBlacklist", ImmutableList.of(), obj -> true);
        enableVBOs = builder.comment("Use VBOs to render certain blocks. This is significantly faster than the usual rendering,", "but may not work correctly with visual effects from other mods").define("enableVBO", true);
        builder.comment("Options to set the RGB color of all IE wire types").push("wire_colors");
        IEClientConfig.addColor(builder, IEWireTypes.IEWireType.COPPER, 11758655);
        IEClientConfig.addColor(builder, IEWireTypes.IEWireType.ELECTRUM, 15573061);
        IEClientConfig.addColor(builder, IEWireTypes.IEWireType.STEEL, 0x6F6F6F);
        IEClientConfig.addColor(builder, IEWireTypes.IEWireType.STRUCTURE_ROPE, 9862765);
        IEClientConfig.addColor(builder, IEWireTypes.IEWireType.STRUCTURE_STEEL, 0x6F6F6F);
        IEClientConfig.addColor(builder, IEWireTypes.IEWireType.REDSTONE, 0xFF2F2F);
        IEClientConfig.addColor(builder, IEWireTypes.IEWireType.COPPER_INSULATED, 16445918);
        IEClientConfig.addColor(builder, IEWireTypes.IEWireType.ELECTRUM_INSULATED, 10323322);
        builder.pop();
        CONFIG_SPEC = builder.build();
    }
}

