/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEEnums;
import blusunrize.immersiveengineering.api.energy.MutableEnergyStorage;
import blusunrize.immersiveengineering.api.energy.WrappingEnergyStorage;
import blusunrize.immersiveengineering.api.utils.DirectionUtils;
import blusunrize.immersiveengineering.client.utils.TextUtils;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlockEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.ticking.IEServerTickableBE;
import blusunrize.immersiveengineering.common.config.IEClientConfig;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.ResettableCapability;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.ImmutableList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;

public class CapacitorBlockEntity
extends IEBaseBlockEntity
implements IEServerTickableBE,
IEBlockInterfaces.IBlockOverlayText,
IEBlockInterfaces.IConfigurableSides,
IEBlockInterfaces.IComparatorOverride,
IEBlockInterfaces.IBlockEntityDrop {
    public EnumMap<Direction, IEEnums.IOSideConfig> sideConfig = new EnumMap(Direction.class);
    private final IEServerConfig.Machines.CapacitorConfig configValues;
    private final IEnergyStorage energyStorage;
    private final Map<Direction, ResettableCapability<IEnergyStorage>> energyCaps = new EnumMap<Direction, ResettableCapability<IEnergyStorage>>(Direction.class);
    private final ResettableCapability<IEnergyStorage> nullEnergyCap;
    public int comparatorOutput = 0;

    public CapacitorBlockEntity(IEServerConfig.Machines.CapacitorConfig configValues, BlockPos pos, BlockState state) {
        super(configValues.tileType.get(), pos, state);
        this.configValues = configValues;
        this.energyStorage = this.makeMainEnergyStorage();
        for (Direction f : DirectionUtils.VALUES) {
            if (f == Direction.UP) {
                this.sideConfig.put(f, IEEnums.IOSideConfig.INPUT);
            } else {
                this.sideConfig.put(f, IEEnums.IOSideConfig.NONE);
            }
            this.energyCaps.put(f, this.registerCapability(new CapacitorEnergyHandler(f, this.sideConfig, this.energyStorage)));
        }
        this.nullEnergyCap = this.registerCapability(new WrappingEnergyStorage(this.energyStorage, false, false));
    }

    @Override
    public void tickServer() {
        int i;
        for (Direction f : DirectionUtils.VALUES) {
            this.transferEnergy(f);
        }
        if (this.f_58857_.m_46467_() % 32L == (long)((this.m_58899_().m_123341_() ^ this.m_58899_().m_123343_()) & 0x1F) && (i = this.scaleStoredEnergyTo(15)) != this.comparatorOutput) {
            this.comparatorOutput = i;
            this.f_58857_.m_46717_(this.m_58899_(), this.m_58900_().m_60734_());
        }
    }

    public int scaleStoredEnergyTo(int scale) {
        return (int)((float)scale * ((float)this.energyStorage.getEnergyStored() / (float)this.energyStorage.getMaxEnergyStored()));
    }

    protected void transferEnergy(Direction side) {
        if (this.sideConfig.get(side) != IEEnums.IOSideConfig.OUTPUT) {
            return;
        }
        BlockPos outPos = this.m_58899_().m_142300_(side);
        BlockEntity tileEntity = Utils.getExistingTileEntity(this.f_58857_, outPos);
        int out = Math.min(this.getMaxOutput(), this.energyStorage.getEnergyStored());
        this.energyStorage.extractEnergy(EnergyHelper.insertFlux((ICapabilityProvider)tileEntity, side.m_122424_(), out, false), false);
    }

    @Override
    public IEEnums.IOSideConfig getSideConfig(Direction side) {
        return this.sideConfig.get(side);
    }

    @Override
    public boolean toggleSide(Direction side, Player player) {
        this.sideConfig.put(side, IEEnums.IOSideConfig.next(this.sideConfig.get(side)));
        this.m_6596_();
        this.markContainingBlockForUpdate(null);
        this.f_58857_.m_7696_(this.m_58899_(), this.m_58900_().m_60734_(), 0, 0);
        return true;
    }

    @Override
    public boolean m_7531_(int id, int arg) {
        if (id == 0) {
            this.markContainingBlockForUpdate(null);
            return true;
        }
        return false;
    }

    public final int getMaxStorage() {
        return this.configValues.storage.getAsInt();
    }

    public final int getMaxInput() {
        return this.configValues.input.getAsInt();
    }

    public final int getMaxOutput() {
        return this.configValues.output.getAsInt();
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket) {
        for (Direction f : DirectionUtils.VALUES) {
            nbt.m_128405_("sideConfig_" + f.ordinal(), this.sideConfig.get(f).ordinal());
        }
        IEnergyStorage iEnergyStorage = this.energyStorage;
        if (iEnergyStorage instanceof EnergyStorage) {
            EnergyStorage forgeStorage = (EnergyStorage)iEnergyStorage;
            EnergyHelper.serializeTo(forgeStorage, nbt);
        }
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean descPacket) {
        for (Direction f : DirectionUtils.VALUES) {
            this.sideConfig.put(f, IEEnums.IOSideConfig.values()[nbt.m_128451_("sideConfig_" + f.ordinal())]);
        }
        IEnergyStorage iEnergyStorage = this.energyStorage;
        if (iEnergyStorage instanceof EnergyStorage) {
            EnergyStorage forgeStorage = (EnergyStorage)iEnergyStorage;
            EnergyHelper.deserializeFrom(forgeStorage, nbt);
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityEnergy.ENERGY) {
            return (side == null ? this.nullEnergyCap : this.energyCaps.get(side)).cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public Component[] getOverlayText(Player player, HitResult mop, boolean hammer) {
        if (hammer && ((Boolean)IEClientConfig.showTextOverlay.get()).booleanValue() && mop instanceof BlockHitResult) {
            BlockHitResult bmop = (BlockHitResult)mop;
            IEEnums.IOSideConfig here = this.sideConfig.get(bmop.m_82434_());
            IEEnums.IOSideConfig opposite = this.sideConfig.get(bmop.m_82434_().m_122424_());
            return TextUtils.sideConfigWithOpposite("desc.immersiveengineering.info.blockSide.connectEnergy.", here, opposite);
        }
        return null;
    }

    @Override
    public boolean useNixieFont(Player player, HitResult mop) {
        return false;
    }

    @Override
    public int getComparatorInputOverride() {
        return this.comparatorOutput;
    }

    @Override
    public List<ItemStack> getBlockEntityDrop(LootContext context) {
        ItemStack stack = new ItemStack((ItemLike)this.m_58900_().m_60734_(), 1);
        this.writeCustomNBT(stack.m_41784_(), false);
        return ImmutableList.of((Object)stack);
    }

    @Override
    public void readOnPlacement(@Nullable LivingEntity placer, ItemStack stack) {
        if (stack.m_41782_()) {
            this.readCustomNBT(stack.m_41784_(), false);
        }
    }

    protected IEnergyStorage makeMainEnergyStorage() {
        return new MutableEnergyStorage(this.getMaxStorage(), this.getMaxInput(), this.getMaxOutput());
    }

    private record CapacitorEnergyHandler(Direction side, Map<Direction, IEEnums.IOSideConfig> sideConfigs, IEnergyStorage base) implements IEnergyStorage
    {
        public int receiveEnergy(int maxReceive, boolean simulate) {
            if (this.canReceive()) {
                return this.base.receiveEnergy(maxReceive, simulate);
            }
            return 0;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            if (this.canExtract()) {
                return this.base.extractEnergy(maxExtract, simulate);
            }
            return 0;
        }

        public int getEnergyStored() {
            return this.base.getEnergyStored();
        }

        public int getMaxEnergyStored() {
            return this.base.getMaxEnergyStored();
        }

        public boolean canExtract() {
            return this.sideConfigs.get(this.side) == IEEnums.IOSideConfig.OUTPUT;
        }

        public boolean canReceive() {
            return this.sideConfigs.get(this.side) == IEEnums.IOSideConfig.INPUT;
        }
    }
}

