/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks;

import blusunrize.immersiveengineering.common.blocks.IIEBlock;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;

public class BlockIESlab<T extends Block>
extends SlabBlock
implements IIEBlock {
    private final Supplier<T> base;

    public BlockIESlab(BlockBehaviour.Properties props, Supplier<T> base) {
        super(props.m_60960_(BlockIESlab.causesSuffocation(base)).m_60924_(BlockIESlab.isNormalCube(base)));
        this.base = base;
    }

    public boolean isLadder(BlockState state, LevelReader world, BlockPos pos, LivingEntity entity) {
        double relativeEntityPosition = entity.m_20182_().m_7098_() - (double)pos.m_123342_();
        switch ((SlabType)state.m_61143_((Property)SlabBlock.f_56353_)) {
            case TOP: {
                return 0.5 < relativeEntityPosition && relativeEntityPosition < 1.0;
            }
            case BOTTOM: {
                return 0.0 < relativeEntityPosition && relativeEntityPosition < 0.5;
            }
            case DOUBLE: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasFlavour() {
        return ((IIEBlock)((Block)this.base.get())).hasFlavour();
    }

    @Override
    public String getNameForFlavour() {
        return ((IIEBlock)((Block)this.base.get())).getNameForFlavour();
    }

    public int m_7753_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return Math.min(((Block)this.base.get()).m_7753_(state, worldIn, pos), super.m_7753_(state, worldIn, pos));
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return super.m_7420_(state, reader, pos) || ((Block)this.base.get()).m_7420_(state, reader, pos);
    }

    public static BlockBehaviour.StatePredicate causesSuffocation(Supplier<? extends Block> base) {
        return (state, world, pos) -> ((Block)base.get()).m_49966_().m_60828_(world, pos) && state.m_61143_((Property)f_56353_) == SlabType.DOUBLE;
    }

    public static BlockBehaviour.StatePredicate isNormalCube(Supplier<? extends Block> base) {
        return (state, world, pos) -> ((Block)base.get()).m_49966_().m_60796_(world, pos) && state.m_61143_((Property)f_56353_) == SlabType.DOUBLE;
    }
}

