/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render.tile;

import blusunrize.immersiveengineering.api.shader.IShaderItem;
import blusunrize.immersiveengineering.api.shader.ShaderCase;
import blusunrize.immersiveengineering.api.shader.ShaderLayer;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.render.IEShaderLayerCompositeTexture;
import blusunrize.immersiveengineering.client.render.tile.IEBlockEntityRenderer;
import blusunrize.immersiveengineering.common.blocks.cloth.ShaderBannerBlockEntity;
import blusunrize.immersiveengineering.common.blocks.cloth.ShaderBannerStandingBlock;
import blusunrize.immersiveengineering.common.blocks.cloth.ShaderBannerWallBlock;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.properties.Property;

public class ShaderBannerRenderer
extends IEBlockEntityRenderer<ShaderBannerBlockEntity> {
    private final ModelPart clothModel;
    private final ModelPart standingModel;
    private final ModelPart crossbar;
    private static final ResourceLocation BASE_TEXTURE = new ResourceLocation("textures/entity/banner_base.png");
    private static final HashMap<ResourceLocation, ResourceLocation> CACHE = new HashMap();

    public ShaderBannerRenderer(BlockEntityRendererProvider.Context ctx) {
        ModelPart modelpart = ctx.m_173582_(ModelLayers.f_171264_);
        this.clothModel = modelpart.m_171324_("flag");
        this.standingModel = modelpart.m_171324_("pole");
        this.crossbar = modelpart.m_171324_("bar");
    }

    public void render(ShaderBannerBlockEntity te, float partialTicks, PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        long time = te.getLevelNonnull().m_46467_();
        matrixStack.m_85836_();
        if (te.getState().m_60734_() == IEBlocks.Cloth.SHADER_BANNER.get()) {
            int orientation = (Integer)te.getState().m_61143_((Property)ShaderBannerStandingBlock.ROTATION);
            matrixStack.m_85837_(0.5, 0.5, 0.5);
            float f1 = (float)(orientation * 360) / 16.0f;
            matrixStack.m_85845_(new Quaternion(new Vector3f(0.0f, 1.0f, 0.0f), -f1, true));
            this.standingModel.f_104207_ = true;
        } else {
            assert (te.getState().m_60734_() == IEBlocks.Cloth.SHADER_BANNER_WALL.get());
            Direction facing = (Direction)te.getState().m_61143_(ShaderBannerWallBlock.FACING);
            float rotation = facing.m_122435_();
            matrixStack.m_85837_(0.5, -0.1666666716337204, 0.5);
            matrixStack.m_85845_(new Quaternion(new Vector3f(0.0f, 1.0f, 0.0f), -rotation, true));
            matrixStack.m_85837_(0.0, -0.3125, -0.4375);
            this.standingModel.f_104207_ = false;
        }
        BlockPos blockpos = te.m_58899_();
        float f3 = (float)(blockpos.m_123341_() * 7 + blockpos.m_123342_() * 9 + blockpos.m_123343_() * 13) + (float)time + partialTicks;
        this.clothModel.f_104203_ = (-0.0125f + 0.01f * Mth.m_14089_((float)(f3 * (float)Math.PI * 0.02f))) * (float)Math.PI;
        this.clothModel.f_104201_ = -32.0f;
        ResourceLocation resourcelocation = this.getBannerResourceLocation(te);
        if (resourcelocation != null) {
            matrixStack.m_85836_();
            matrixStack.m_85841_(0.6666667f, -0.6666667f, -0.6666667f);
            VertexConsumer builder = bufferIn.m_6299_(RenderType.m_110446_((ResourceLocation)resourcelocation));
            this.clothModel.m_104301_(matrixStack, builder, combinedLightIn, combinedOverlayIn);
            builder = ModelBakery.f_119224_.m_119194_(bufferIn, RenderType::m_110446_);
            this.crossbar.m_104301_(matrixStack, builder, combinedLightIn, combinedOverlayIn);
            this.standingModel.m_104301_(matrixStack, builder, combinedLightIn, combinedOverlayIn);
            matrixStack.m_85849_();
        }
        matrixStack.m_85849_();
    }

    @Nullable
    private ResourceLocation getBannerResourceLocation(ShaderBannerBlockEntity bannerObj) {
        ResourceLocation name = null;
        ShaderCase sCase = null;
        ItemStack shader = bannerObj.shader.getShaderItem();
        if (!shader.m_41619_() && shader.m_41720_() instanceof IShaderItem) {
            IShaderItem iShaderItem = (IShaderItem)shader.m_41720_();
            name = iShaderItem.getShaderName(shader);
            if (CACHE.containsKey(name)) {
                return CACHE.get(name);
            }
            sCase = iShaderItem.getShaderCase(shader, bannerObj.shader.getShaderType());
        }
        if (sCase != null) {
            ShaderLayer[] layers = sCase.getLayers();
            ResourceLocation textureLocation = new ResourceLocation(name.m_135827_(), "bannershader/" + name.m_135815_());
            ClientUtils.mc().m_91097_().m_118495_(textureLocation, (AbstractTexture)new IEShaderLayerCompositeTexture(BASE_TEXTURE, layers));
            CACHE.put(name, textureLocation);
            return textureLocation;
        }
        return null;
    }
}

