/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models.obj;

import blusunrize.immersiveengineering.api.shader.ShaderCase;
import blusunrize.immersiveengineering.client.models.obj.callback.IEOBJCallback;
import com.mojang.math.Vector4f;
import java.util.function.BiFunction;

public class MaterialColorGetter<T>
implements BiFunction<String, Vector4f, Vector4f> {
    private final String groupName;
    private final IEOBJCallback<T> callback;
    private final T callbackObject;
    private final ShaderCase shaderCase;
    private int renderPass = 0;

    public MaterialColorGetter(String groupName, IEOBJCallback<T> callback, T callbackObject, ShaderCase shaderCase) {
        this.groupName = groupName;
        this.callback = callback;
        this.callbackObject = callbackObject;
        this.shaderCase = shaderCase;
    }

    public void setRenderPass(int pass) {
        this.renderPass = pass;
    }

    @Override
    public Vector4f apply(String material, Vector4f originalColor) {
        Vector4f color = originalColor;
        if (this.callback != null) {
            color = this.callback.getRenderColor(this.callbackObject, this.groupName, material, this.shaderCase, color);
        }
        if (this.shaderCase != null) {
            color = this.shaderCase.getRenderColor(this.groupName, this.renderPass, color);
        }
        return color;
    }
}

