/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.manual;

import blusunrize.immersiveengineering.api.crafting.BlueprintCraftingRecipe;
import blusunrize.lib.manual.ManualInstance;
import blusunrize.lib.manual.ManualUtils;
import blusunrize.lib.manual.PositionedItemStack;
import blusunrize.lib.manual.SpecialManualElements;
import blusunrize.lib.manual.gui.GuiButtonManualNavigation;
import blusunrize.lib.manual.gui.ManualScreen;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Button;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ManualElementBlueprint
extends SpecialManualElements {
    private final ItemStack[] stacks;
    private final List<PositionedItemStack[]> recipes = new ArrayList<PositionedItemStack[]>();
    private int recipePage;
    private int yOff;

    public ManualElementBlueprint(ManualInstance manual, ItemStack ... stacks) {
        super(manual);
        this.stacks = stacks;
        this.recalculateCraftingRecipes();
    }

    @Override
    public void recalculateCraftingRecipes() {
        this.recipes.clear();
        for (String category : BlueprintCraftingRecipe.recipeCategories) {
            for (BlueprintCraftingRecipe recipe : BlueprintCraftingRecipe.findRecipes((Level)Minecraft.m_91087_().f_91073_, category)) {
                for (int iStack = 0; iStack < this.stacks.length; ++iStack) {
                    ItemStack output = this.stacks[iStack];
                    if (((ItemStack)recipe.output.get()).m_41619_() || !ManualUtils.stackMatchesObject((ItemStack)recipe.output.get(), output) || recipe.inputs == null || recipe.inputs.length <= 0) continue;
                    int h = (int)Math.ceil((float)recipe.inputs.length / 2.0f);
                    PositionedItemStack[] pIngredients = new PositionedItemStack[recipe.inputs.length + 2];
                    for (int i = 0; i < recipe.inputs.length; ++i) {
                        pIngredients[i] = new PositionedItemStack(recipe.inputs[i].getMatchingStacks(), 32 + i % 2 * 18, i / 2 * 18);
                    }
                    int middle = (int)((float)h / 2.0f * 18.0f) - 8;
                    pIngredients[pIngredients.length - 2] = new PositionedItemStack((ItemStack)recipe.output.get(), 86, middle);
                    pIngredients[pIngredients.length - 1] = new PositionedItemStack(BlueprintCraftingRecipe.getTypedBlueprint(category), 8, middle);
                    if (iStack < this.recipes.size()) {
                        this.recipes.add(iStack, pIngredients);
                    } else {
                        this.recipes.add(pIngredients);
                    }
                    if (h * 18 <= this.yOff) continue;
                    this.yOff = h * 18;
                }
            }
        }
        if (this.providedItems != null) {
            this.providedItems.clear();
        }
        for (ItemStack stack : this.stacks) {
            this.addProvidedItem(stack);
        }
    }

    @Override
    public void onOpened(ManualScreen gui, int x, int y, List<Button> pageButtons) {
        if (this.recipes.size() > 1) {
            pageButtons.add(new GuiButtonManualNavigation(gui, x - 2, y + this.yOff / 2 - 3, 8, 10, 0, btn -> {
                --this.recipePage;
                if (this.recipePage < 0) {
                    this.recipePage = this.recipes.size() - 1;
                }
            }));
            pageButtons.add(new GuiButtonManualNavigation(gui, x + 122 - 16, y + this.yOff / 2 - 3, 8, 10, 1, btn -> {
                ++this.recipePage;
                if (this.recipePage >= this.recipes.size()) {
                    this.recipePage = 0;
                }
            }));
        }
        super.onOpened(gui, x, y + this.yOff + 2, pageButtons);
    }

    @Override
    public void render(PoseStack transform, ManualScreen gui, int x, int y, int mouseX, int mouseY) {
        this.highlighted = ItemStack.f_41583_;
        if (!this.recipes.isEmpty() && this.recipePage >= 0 && this.recipePage < this.recipes.size()) {
            int maxX = 0;
            PositionedItemStack[] positionedItemStackArray = this.recipes.get(this.recipePage);
            int n = positionedItemStackArray.length;
            for (int i = 0; i < n; ++i) {
                PositionedItemStack pstack = positionedItemStackArray[i];
                if (pstack == null) continue;
                if (pstack.x() > maxX) {
                    maxX = pstack.x();
                }
                GuiComponent.m_93172_((PoseStack)transform, (int)(x + pstack.x()), (int)(y + pstack.y()), (int)(x + pstack.x() + 16), (int)(y + pstack.y() + 16), (int)0x33666666);
            }
            ManualUtils.drawTexturedRect(this.manual.texture, x + maxX - 17, y + this.yOff / 2 - 5, 16, 10, 0.0f, 0.0625f, 0.8828125f, 0.921875f);
        }
        if (!this.recipes.isEmpty() && this.recipePage >= 0 && this.recipePage < this.recipes.size()) {
            for (PositionedItemStack pstack : this.recipes.get(this.recipePage)) {
                if (pstack == null || pstack.getStackAtCurrentTime().m_41619_()) continue;
                ManualUtils.renderItemStack(transform, pstack.getStackAtCurrentTime(), x + pstack.x(), y + pstack.y(), true);
                if (mouseX < x + pstack.x() || mouseX >= x + pstack.x() + 16 || mouseY < y + pstack.y() || mouseY >= y + pstack.y() + 16) continue;
                this.highlighted = pstack.getStackAtCurrentTime();
            }
        }
        this.renderHighlightedTooltip(transform, gui, mouseX, mouseY);
    }

    @Override
    public boolean listForSearch(String searchTag) {
        for (PositionedItemStack[] recipe : this.recipes) {
            for (PositionedItemStack pStack : recipe) {
                for (ItemStack stack : pStack.displayList()) {
                    if (!ManualUtils.listStack(searchTag, stack)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public int getPixelsTaken() {
        int maxY = 0;
        for (PositionedItemStack[] recipe : this.recipes) {
            for (PositionedItemStack pstack : recipe) {
                maxY = Math.max(maxY, pstack.y());
            }
        }
        return maxY + 18;
    }
}

