/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.gui;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.client.TextUtils;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.gui.IEContainerScreen;
import blusunrize.immersiveengineering.client.gui.elements.ITooltipWidget;
import blusunrize.immersiveengineering.common.blocks.wooden.SorterBlockEntity;
import blusunrize.immersiveengineering.common.gui.SorterContainer;
import blusunrize.immersiveengineering.common.network.MessageBlockEntitySync;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class SorterScreen
extends IEContainerScreen<SorterContainer> {
    private static final ResourceLocation TEXTURE = SorterScreen.makeTextureLocation("sorter");
    private final SorterBlockEntity tile;

    public SorterScreen(SorterContainer container, Inventory inventoryPlayer, Component title) {
        super(container, inventoryPlayer, title, TEXTURE);
        this.tile = (SorterBlockEntity)container.tile;
        this.f_97727_ = 244;
    }

    @Override
    protected void drawContainerBackgroundPre(@Nonnull PoseStack transform, float f, int mx, int my) {
        for (int side = 0; side < 6; ++side) {
            int x = this.f_97735_ + 30 + side / 2 * 58;
            int y = this.f_97736_ + 44 + side % 2 * 76;
            String s = I18n.m_118938_((String)("desc.immersiveengineering.info.blockSide." + Direction.m_122376_((int)side).toString()), (Object[])new Object[0]).substring(0, 1);
            RenderSystem.m_69478_();
            ClientUtils.font().m_92750_(transform, s, (float)(x - ClientUtils.font().m_92895_(s) / 2), (float)y, -1429418804);
        }
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.m_169413_();
        for (int side = 0; side < 6; ++side) {
            for (int bit = 0; bit < 3; ++bit) {
                int x = this.f_97735_ + 3 + side / 2 * 58 + bit * 18;
                int y = this.f_97736_ + 3 + side % 2 * 76;
                int bitFinal = bit;
                int sideFinal = side;
                ButtonSorter b = new ButtonSorter(x, y, bit, btn -> {
                    int mask = 1 << bitFinal;
                    this.tile.sideFilter[sideFinal] = this.tile.sideFilter[sideFinal] ^ mask;
                    CompoundTag tag = new CompoundTag();
                    tag.m_128385_("sideConfig", this.tile.sideFilter);
                    ImmersiveEngineering.packetHandler.sendToServer((Object)new MessageBlockEntitySync(this.tile, tag));
                    this.fullInit();
                });
                b.f_93623_ = bit == 0 ? this.tile.doOredict(side) : (bit == 1 ? this.tile.doNBT(side) : this.tile.doFuzzy(side));
                this.m_142416_((GuiEventListener)b);
            }
        }
    }

    public static class ButtonSorter
    extends Button
    implements ITooltipWidget {
        int type;
        boolean f_93623_ = false;

        public ButtonSorter(int x, int y, int type, Button.OnPress handler) {
            super(x, y, 18, 18, TextComponent.f_131282_, handler);
            this.type = type;
        }

        public void m_6305_(PoseStack transform, int mx, int my, float partialTicks) {
            if (this.f_93624_) {
                ClientUtils.bindTexture(TEXTURE);
                this.f_93622_ = mx >= this.f_93620_ && my >= this.f_93621_ && mx < this.f_93620_ + this.f_93618_ && my < this.f_93621_ + this.f_93619_;
                RenderSystem.m_69478_();
                RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                this.m_93228_(transform, this.f_93620_, this.f_93621_, 176 + this.type * 18, this.f_93623_ ? 3 : 21, this.f_93618_, this.f_93619_);
            }
        }

        @Override
        public void gatherTooltip(int mouseX, int mouseY, List<Component> tooltip) {
            String[] split = I18n.m_118938_((String)("desc.immersiveengineering.info.filter." + (this.type == 0 ? "tag" : (this.type == 1 ? "nbt" : "damage"))), (Object[])new Object[0]).split("<br>");
            for (int i = 0; i < split.length; ++i) {
                if (i == 0) {
                    tooltip.add((Component)new TextComponent(split[i]));
                    continue;
                }
                tooltip.add((Component)TextUtils.applyFormat((Component)new TextComponent(split[i]), ChatFormatting.GRAY));
            }
        }
    }
}

