/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.menuhandler.custom;

import com.google.common.util.concurrent.Runnables;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.menu.button.ButtonCachedEvent;
import de.keksuccino.fancymenu.menu.fancy.MenuCustomization;
import de.keksuccino.fancymenu.menu.fancy.helper.MenuReloadedEvent;
import de.keksuccino.fancymenu.menu.fancy.menuhandler.MenuHandlerBase;
import de.keksuccino.konkrete.file.FileUtils;
import de.keksuccino.konkrete.gui.screens.popup.PopupHandler;
import de.keksuccino.konkrete.input.MouseInput;
import de.keksuccino.konkrete.math.MathUtils;
import de.keksuccino.konkrete.reflection.ReflectionHelper;
import de.keksuccino.konkrete.rendering.CurrentScreenHandler;
import de.keksuccino.konkrete.rendering.RenderUtils;
import java.awt.Color;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.WinScreen;
import net.minecraft.client.renderer.CubeMap;
import net.minecraft.client.renderer.PanoramaRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.internal.BrandingControl;

public class MainMenuHandler
extends MenuHandlerBase {
    private static final CubeMap PANORAMA_CUBE_MAP = new CubeMap(new ResourceLocation("textures/gui/title/background/panorama"));
    private static final ResourceLocation PANORAMA_OVERLAY = new ResourceLocation("textures/gui/title/background/panorama_overlay.png");
    private static final ResourceLocation MINECRAFT_TITLE_TEXTURE = new ResourceLocation("textures/gui/title/minecraft.png");
    private static final ResourceLocation EDITION_TITLE_TEXTURE = new ResourceLocation("textures/gui/title/edition.png");
    private static final Random RANDOM = new Random();
    private PanoramaRenderer panorama = new PanoramaRenderer(PANORAMA_CUBE_MAP);
    private String splash;

    public MainMenuHandler() {
        super(TitleScreen.class.getName());
    }

    @Override
    public void onMenuReloaded(MenuReloadedEvent e) {
        super.onMenuReloaded(e);
        this.splash = MainMenuHandler.getRandomSplashText();
    }

    @Override
    public void onInitPre(ScreenEvent.InitScreenEvent.Pre e) {
        if (this.shouldCustomize(e.getScreen()) && MenuCustomization.isMenuCustomizable(e.getScreen()) && e.getScreen() instanceof TitleScreen) {
            MainMenuHandler.setShowFadeInAnimation(false, (TitleScreen)e.getScreen());
        }
        super.onInitPre(e);
    }

    @Override
    public void onButtonsCached(ButtonCachedEvent e) {
        if (this.shouldCustomize(e.getScreen()) && MenuCustomization.isMenuCustomizable(e.getScreen())) {
            if (this.splash == null) {
                this.splash = MainMenuHandler.getRandomSplashText();
            }
            if (FancyMenu.getMinecraftVersion().equals("1.18") || FancyMenu.getMinecraftVersion().equals("1.18.1")) {
                this.setWidthCopyrightRest(Integer.MAX_VALUE);
            }
            super.onButtonsCached(e);
        }
    }

    @SubscribeEvent
    public void onRender(ScreenEvent.DrawScreenEvent.Pre e) {
        if (this.shouldCustomize(e.getScreen()) && MenuCustomization.isMenuCustomizable(e.getScreen())) {
            e.setCanceled(true);
            e.getScreen().m_7333_(e.getPoseStack());
        }
    }

    @Override
    public void drawToBackground(ScreenEvent.BackgroundDrawnEvent e) {
        if (this.shouldCustomize(e.getScreen())) {
            Font font = Minecraft.m_91087_().f_91062_;
            int width = e.getScreen().f_96543_;
            int height = e.getScreen().f_96544_;
            int j = width / 2 - 137;
            float minecraftLogoSpelling = RANDOM.nextFloat();
            int mouseX = MouseInput.getMouseX();
            int mouseY = MouseInput.getMouseY();
            PoseStack matrix = CurrentScreenHandler.getPoseStack();
            RenderSystem.m_69478_();
            if (!this.canRenderBackground()) {
                this.panorama.m_110003_(Minecraft.m_91087_().m_91297_(), 1.0f);
                RenderUtils.bindTexture((ResourceLocation)PANORAMA_OVERLAY);
                RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                MainMenuHandler.m_93160_((PoseStack)matrix, (int)0, (int)0, (int)e.getScreen().f_96543_, (int)e.getScreen().f_96544_, (float)0.0f, (float)0.0f, (int)16, (int)128, (int)16, (int)128);
            }
            super.drawToBackground(e);
            if (!((Boolean)FancyMenu.config.getOrDefault("hidelogo", (Object)true)).booleanValue()) {
                RenderUtils.bindTexture((ResourceLocation)MINECRAFT_TITLE_TEXTURE);
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                if ((double)minecraftLogoSpelling < 1.0E-4) {
                    this.m_93228_(matrix, j + 0, 30, 0, 0, 99, 44);
                    this.m_93228_(matrix, j + 99, 30, 129, 0, 27, 44);
                    this.m_93228_(matrix, j + 99 + 26, 30, 126, 0, 3, 44);
                    this.m_93228_(matrix, j + 99 + 26 + 3, 30, 99, 0, 26, 44);
                    this.m_93228_(matrix, j + 155, 30, 0, 45, 155, 44);
                } else {
                    this.m_93228_(matrix, j + 0, 30, 0, 0, 155, 44);
                    this.m_93228_(matrix, j + 155, 30, 0, 45, 155, 44);
                }
                RenderSystem.m_157456_((int)0, (ResourceLocation)EDITION_TITLE_TEXTURE);
                MainMenuHandler.m_93133_((PoseStack)matrix, (int)(j + 88), (int)67, (float)0.0f, (float)0.0f, (int)98, (int)14, (int)128, (int)16);
            }
            if (!((Boolean)FancyMenu.config.getOrDefault("hidebranding", (Object)true)).booleanValue()) {
                BrandingControl.forEachLine((boolean)true, (boolean)true, (brdline, brd) -> {
                    int n = e.getScreen().f_96544_;
                    int n2 = brdline;
                    Objects.requireNonNull(font);
                    GuiComponent.m_93236_((PoseStack)matrix, (Font)font, (String)brd, (int)2, (int)(n - (10 + n2 * (9 + 1))), (int)0xFFFFFF);
                });
            }
            if (!((Boolean)FancyMenu.config.getOrDefault("hideforgenotifications", (Object)false)).booleanValue()) {
                ForgeHooksClient.renderMainMenu((TitleScreen)((TitleScreen)e.getScreen()), (PoseStack)matrix, (Font)Minecraft.m_91087_().f_91062_, (int)e.getScreen().f_96543_, (int)e.getScreen().f_96544_, (int)255);
                BrandingControl.forEachAboveCopyrightLine((brdline, brd) -> {
                    int n = e.getScreen().f_96543_ - font.m_92895_(brd) - 1;
                    int n2 = e.getScreen().f_96544_;
                    int n3 = brdline + 1;
                    Objects.requireNonNull(font);
                    GuiComponent.m_93236_((PoseStack)matrix, (Font)font, (String)brd, (int)n, (int)(n2 - (11 + n3 * (9 + 1))), (int)0xFFFFFF);
                });
            }
            if (FancyMenu.getMinecraftVersion().equals("1.18") || FancyMenu.getMinecraftVersion().equals("1.18.1")) {
                String c = "Copyright Mojang AB. Do not distribute!";
                String cPos = (String)FancyMenu.config.getOrDefault("copyrightposition", (Object)"bottom-right");
                int cX = 0;
                int cY = 0;
                int cW = Minecraft.m_91087_().f_91062_.m_92895_(c);
                int cH = 10;
                if (cPos.equalsIgnoreCase("top-left")) {
                    cX = 2;
                    cY = 2;
                } else if (cPos.equalsIgnoreCase("top-centered")) {
                    cX = width / 2 - cW / 2;
                    cY = 2;
                } else if (cPos.equalsIgnoreCase("top-right")) {
                    cX = width - cW - 2;
                    cY = 2;
                } else if (cPos.equalsIgnoreCase("bottom-left")) {
                    cX = 2;
                    cY = height - cH - 2;
                } else if (cPos.equalsIgnoreCase("bottom-centered")) {
                    cX = width / 2 - cW / 2;
                    cY = height - cH - 2;
                } else {
                    cX = width - cW - 2;
                    cY = height - cH - 2;
                }
                Color copyrightcolor = RenderUtils.getColorFromHexString((String)((String)FancyMenu.config.getOrDefault("copyrightcolor", (Object)"#ffffff")));
                if (copyrightcolor == null) {
                    copyrightcolor = new Color(255, 255, 255);
                }
                GuiComponent.m_93236_((PoseStack)matrix, (Font)font, (String)c, (int)cX, (int)cY, (int)(copyrightcolor.getRGB() | 0xFF000000));
                if (mouseX >= cX && mouseX <= cX + cW && mouseY >= cY && mouseY <= cY + cH) {
                    GuiComponent.m_93172_((PoseStack)matrix, (int)cX, (int)(cY + cH - 1), (int)(cX + cW), (int)(cY + cH), (int)-1);
                    if (MouseInput.isLeftMouseDown()) {
                        Minecraft.m_91087_().m_91152_((Screen)new WinScreen(false, Runnables.doNothing()));
                    }
                }
            }
            if (!PopupHandler.isPopupActive()) {
                this.renderButtons(e, mouseX, mouseY);
            }
            if (!((Boolean)FancyMenu.config.getOrDefault("hiderealmsnotifications", (Object)false)).booleanValue()) {
                this.drawRealmsNotification(matrix, e.getScreen());
            }
            this.renderSplash(matrix, font, e.getScreen());
        }
    }

    protected void renderSplash(PoseStack matrix, Font font, Screen s) {
        if (!((Boolean)FancyMenu.config.getOrDefault("hidesplashtext", (Object)true)).booleanValue()) {
            float finalPosX = s.f_96543_ / 2 + 90;
            float finalPosY = 70.0f;
            int rotation = (Integer)FancyMenu.config.getOrDefault("splashrotation", (Object)-20);
            int posX = (Integer)FancyMenu.config.getOrDefault("splashx", (Object)0);
            int posY = (Integer)FancyMenu.config.getOrDefault("splashy", (Object)0);
            String orientation = (String)FancyMenu.config.getOrDefault("splashorientation", (Object)"original");
            int originX = 0;
            int originY = 0;
            boolean setpos = true;
            if (orientation.equalsIgnoreCase("original")) {
                originX = (int)finalPosX;
                originY = (int)finalPosY;
            } else if (!orientation.equalsIgnoreCase("top-left")) {
                if (orientation.equalsIgnoreCase("mid-left")) {
                    originY = s.f_96544_ / 2;
                } else if (orientation.equalsIgnoreCase("bottom-left")) {
                    originY = s.f_96544_;
                } else if (orientation.equalsIgnoreCase("top-centered")) {
                    originX = s.f_96543_ / 2;
                } else if (orientation.equalsIgnoreCase("mid-centered")) {
                    originX = s.f_96543_ / 2;
                    originY = s.f_96544_ / 2;
                } else if (orientation.equalsIgnoreCase("bottom-centered")) {
                    originX = s.f_96543_ / 2;
                    originY = s.f_96544_;
                } else if (orientation.equalsIgnoreCase("top-right")) {
                    originX = s.f_96543_;
                } else if (orientation.equalsIgnoreCase("mid-right")) {
                    originX = s.f_96543_;
                    originY = s.f_96544_ / 2;
                } else if (orientation.equalsIgnoreCase("bottom-right")) {
                    originX = s.f_96543_;
                    originY = s.f_96544_;
                } else {
                    setpos = false;
                }
            }
            if (setpos) {
                finalPosX = originX + posX;
                finalPosY = originY + posY;
            }
            if (this.splash == null) {
                this.splash = "";
            }
            matrix.m_85836_();
            matrix.m_85837_((double)finalPosX, (double)finalPosY, 0.0);
            matrix.m_85845_(Vector3f.f_122227_.m_122240_((float)rotation));
            float f = 1.8f - Mth.m_14154_((float)(Mth.m_14031_((float)((float)(System.currentTimeMillis() % 1000L) / 1000.0f * ((float)Math.PI * 2))) * 0.1f));
            f = f * 100.0f / (float)(font.m_92895_(this.splash) + 32);
            matrix.m_85841_(f, f, f);
            Color c = RenderUtils.getColorFromHexString((String)((String)FancyMenu.config.getOrDefault("splashcolor", (Object)"#ffff00")));
            if (c == null) {
                c = new Color(255, 255, 0);
            }
            MainMenuHandler.m_93215_((PoseStack)matrix, (Font)font, (Component)new TextComponent(this.splash), (int)0, (int)-8, (int)c.getRGB());
            matrix.m_85849_();
        }
    }

    private void renderButtons(ScreenEvent.BackgroundDrawnEvent e, int mouseX, int mouseY) {
        List<Widget> buttons = this.getButtonList(e.getScreen());
        float partial = Minecraft.m_91087_().m_91296_();
        if (buttons != null) {
            for (int i = 0; i < buttons.size(); ++i) {
                buttons.get(i).m_6305_(CurrentScreenHandler.getPoseStack(), mouseX, mouseY, partial);
            }
        }
    }

    private void drawRealmsNotification(PoseStack matrix, Screen gui) {
        if (Minecraft.m_91087_().f_91066_.f_92046_) {
            Field f = ReflectionHelper.findField(TitleScreen.class, (String)"f_96726_");
            Screen realms = null;
            try {
                realms = (Screen)f.get(gui);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (realms != null) {
                realms.m_6305_(matrix, (int)Minecraft.m_91087_().f_91067_.m_91589_(), (int)Minecraft.m_91087_().f_91067_.m_91594_(), Minecraft.m_91087_().m_91296_());
            }
        }
    }

    private List<Widget> getButtonList(Screen gui) {
        List<Object> buttons = new ArrayList<Widget>();
        try {
            Field f = ReflectionHelper.findField(Screen.class, (String)"f_169369_");
            try {
                buttons = (List)f.get(gui);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return buttons;
    }

    private void setWidthCopyrightRest(int i) {
        try {
            if (Minecraft.m_91087_().f_91080_ instanceof TitleScreen) {
                Field f = ReflectionHelper.findField(TitleScreen.class, (String)"f_96728_");
                f.set(Minecraft.m_91087_().f_91080_, i);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected static void setShowFadeInAnimation(boolean showFadeIn, TitleScreen s) {
        try {
            Field f = ReflectionHelper.findField(TitleScreen.class, (String)"f_96714_");
            f.setBoolean(s, showFadeIn);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected static String getRandomSplashText() {
        List l;
        File f;
        String customSplashPath = (String)FancyMenu.config.getOrDefault("splashtextfile", (Object)"");
        if (customSplashPath != null && !customSplashPath.equals("") && (f = new File(customSplashPath)).exists() && f.isFile() && f.getPath().toLowerCase().endsWith(".txt") && (l = FileUtils.getFileLines((File)f)) != null && !l.isEmpty()) {
            int random = MathUtils.getRandomNumberInRange((int)0, (int)(l.size() - 1));
            return (String)l.get(random);
        }
        return Minecraft.m_91087_().m_91310_().m_118867_();
    }
}

