/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.menuhandler;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.api.background.MenuBackground;
import de.keksuccino.fancymenu.api.background.MenuBackgroundType;
import de.keksuccino.fancymenu.api.background.MenuBackgroundTypeRegistry;
import de.keksuccino.fancymenu.api.item.CustomizationItem;
import de.keksuccino.fancymenu.api.item.CustomizationItemContainer;
import de.keksuccino.fancymenu.api.item.CustomizationItemRegistry;
import de.keksuccino.fancymenu.events.PlayWidgetClickSoundEvent;
import de.keksuccino.fancymenu.events.RenderGuiListBackgroundEvent;
import de.keksuccino.fancymenu.events.RenderWidgetBackgroundEvent;
import de.keksuccino.fancymenu.events.SoftMenuReloadEvent;
import de.keksuccino.fancymenu.mainwindow.MainWindowHandler;
import de.keksuccino.fancymenu.menu.animation.AdvancedAnimation;
import de.keksuccino.fancymenu.menu.animation.AnimationHandler;
import de.keksuccino.fancymenu.menu.button.ButtonCache;
import de.keksuccino.fancymenu.menu.button.ButtonCachedEvent;
import de.keksuccino.fancymenu.menu.button.ButtonData;
import de.keksuccino.fancymenu.menu.button.VanillaButtonDescriptionHandler;
import de.keksuccino.fancymenu.menu.fancy.DynamicValueHelper;
import de.keksuccino.fancymenu.menu.fancy.MenuCustomization;
import de.keksuccino.fancymenu.menu.fancy.MenuCustomizationProperties;
import de.keksuccino.fancymenu.menu.fancy.gameintro.GameIntroHandler;
import de.keksuccino.fancymenu.menu.fancy.guicreator.CustomGuiBase;
import de.keksuccino.fancymenu.menu.fancy.guicreator.CustomGuiLoader;
import de.keksuccino.fancymenu.menu.fancy.helper.MenuReloadedEvent;
import de.keksuccino.fancymenu.menu.fancy.helper.layoutcreator.LayoutEditorScreen;
import de.keksuccino.fancymenu.menu.fancy.item.AnimationCustomizationItem;
import de.keksuccino.fancymenu.menu.fancy.item.ButtonCustomizationItem;
import de.keksuccino.fancymenu.menu.fancy.item.CustomizationItemBase;
import de.keksuccino.fancymenu.menu.fancy.item.ShapeCustomizationItem;
import de.keksuccino.fancymenu.menu.fancy.item.SlideshowCustomizationItem;
import de.keksuccino.fancymenu.menu.fancy.item.SplashTextCustomizationItem;
import de.keksuccino.fancymenu.menu.fancy.item.StringCustomizationItem;
import de.keksuccino.fancymenu.menu.fancy.item.TextureCustomizationItem;
import de.keksuccino.fancymenu.menu.fancy.item.VanillaButtonCustomizationItem;
import de.keksuccino.fancymenu.menu.fancy.item.WebStringCustomizationItem;
import de.keksuccino.fancymenu.menu.fancy.item.WebTextureCustomizationItem;
import de.keksuccino.fancymenu.menu.fancy.item.playerentity.PlayerEntityCustomizationItem;
import de.keksuccino.fancymenu.menu.fancy.item.visibilityrequirements.VisibilityRequirementContainer;
import de.keksuccino.fancymenu.menu.fancy.menuhandler.MenuHandlerRegistry;
import de.keksuccino.fancymenu.menu.panorama.ExternalTexturePanoramaRenderer;
import de.keksuccino.fancymenu.menu.panorama.PanoramaHandler;
import de.keksuccino.fancymenu.menu.slideshow.ExternalTextureSlideshowRenderer;
import de.keksuccino.fancymenu.menu.slideshow.SlideshowHandler;
import de.keksuccino.konkrete.gui.screens.popup.PopupHandler;
import de.keksuccino.konkrete.input.MouseInput;
import de.keksuccino.konkrete.math.MathUtils;
import de.keksuccino.konkrete.properties.PropertiesSection;
import de.keksuccino.konkrete.properties.PropertiesSet;
import de.keksuccino.konkrete.rendering.CurrentScreenHandler;
import de.keksuccino.konkrete.rendering.RenderUtils;
import de.keksuccino.konkrete.rendering.animation.ExternalGifAnimationRenderer;
import de.keksuccino.konkrete.rendering.animation.IAnimationRenderer;
import de.keksuccino.konkrete.resources.ExternalTextureResourceLocation;
import de.keksuccino.konkrete.resources.TextureHandler;
import de.keksuccino.konkrete.sound.SoundHandler;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class MenuHandlerBase
extends GuiComponent {
    protected List<CustomizationItemBase> frontRenderItems = new ArrayList<CustomizationItemBase>();
    protected List<CustomizationItemBase> backgroundRenderItems = new ArrayList<CustomizationItemBase>();
    protected Map<String, Boolean> audio = new HashMap<String, Boolean>();
    protected IAnimationRenderer backgroundAnimation = null;
    protected IAnimationRenderer lastBackgroundAnimation = null;
    protected List<IAnimationRenderer> backgroundAnimations = new ArrayList<IAnimationRenderer>();
    protected int backgroundAnimationId = 0;
    protected ExternalTextureResourceLocation backgroundTexture = null;
    protected String identifier;
    protected boolean backgroundDrawable;
    protected boolean panoramaback = false;
    protected int panoTick = 0;
    protected double panoPos = 0.0;
    protected boolean panoMoveBack = false;
    protected boolean panoStop = false;
    protected boolean keepBackgroundAspectRatio = false;
    protected ExternalTexturePanoramaRenderer panoramacube;
    protected ExternalTextureSlideshowRenderer slideshow;
    protected MenuBackground customMenuBackground = null;
    protected List<ButtonData> hidden = new ArrayList<ButtonData>();
    protected Map<AbstractWidget, ButtonCustomizationContainer> vanillaButtonCustomizations = new HashMap<AbstractWidget, ButtonCustomizationContainer>();
    protected Map<AbstractWidget, VisibilityRequirementContainer> vanillaButtonVisibilityRequirementContainers = new HashMap<AbstractWidget, VisibilityRequirementContainer>();
    protected volatile Map<ButtonData, Float> delayAppearanceVanilla = new HashMap<ButtonData, Float>();
    protected Map<ButtonData, Float> fadeInVanilla = new HashMap<ButtonData, Float>();
    protected List<String> delayAppearanceFirstTime = new ArrayList<String>();
    protected List<Long> delayAppearanceFirstTimeVanilla = new ArrayList<Long>();
    protected List<ThreadCaller> delayThreads = new ArrayList<ThreadCaller>();
    protected boolean preinit = false;
    protected Map<String, RandomLayoutContainer> randomLayoutGroups = new HashMap<String, RandomLayoutContainer>();
    protected List<PropertiesSet> normalLayouts = new ArrayList<PropertiesSet>();
    protected SharedLayoutProperties sharedLayoutProps = new SharedLayoutProperties();
    protected String closeAudio;
    protected String openAudio;
    protected static Screen scaleChangedIn = null;

    public MenuHandlerBase(@Nonnull String identifier) {
        this.identifier = identifier;
    }

    public String getMenuIdentifier() {
        return this.identifier;
    }

    @SubscribeEvent
    public void onSoftReload(SoftMenuReloadEvent e) {
        if (this.shouldCustomize(e.screen)) {
            this.delayAppearanceFirstTimeVanilla.clear();
            this.delayAppearanceFirstTime.clear();
            this.delayAppearanceVanilla.clear();
            this.fadeInVanilla.clear();
            for (RandomLayoutContainer c : this.randomLayoutGroups.values()) {
                c.lastLayoutPath = null;
            }
            if (this.lastBackgroundAnimation != null) {
                this.lastBackgroundAnimation.resetAnimation();
            }
        }
    }

    @SubscribeEvent
    public void onMenuReloaded(MenuReloadedEvent e) {
        this.delayAppearanceFirstTimeVanilla.clear();
        this.delayAppearanceFirstTime.clear();
        this.delayAppearanceVanilla.clear();
        this.fadeInVanilla.clear();
        for (RandomLayoutContainer c : this.randomLayoutGroups.values()) {
            c.lastLayoutPath = null;
        }
        if (this.lastBackgroundAnimation != null) {
            this.lastBackgroundAnimation.resetAnimation();
        }
    }

    /*
     * WARNING - void declaration
     */
    @SubscribeEvent
    public void onInitPre(ScreenEvent.InitScreenEvent.Pre e) {
        for (ThreadCaller t : this.delayThreads) {
            t.running.set(false);
        }
        this.delayThreads.clear();
        int mcscale = Minecraft.m_91087_().m_91268_().m_85385_(Minecraft.m_91087_().f_91066_.f_92072_, Minecraft.m_91087_().m_91390_());
        if (e.getScreen() != Minecraft.m_91087_().f_91080_) {
            return;
        }
        if (scaleChangedIn != null && scaleChangedIn != e.getScreen()) {
            scaleChangedIn = null;
            Window m2 = Minecraft.m_91087_().m_91268_();
            m2.m_85378_((double)mcscale);
            e.getScreen().f_96543_ = m2.m_85445_();
            e.getScreen().f_96544_ = m2.m_85446_();
        }
        if (!MenuCustomization.isValidScreen(e.getScreen())) {
            return;
        }
        if (!this.shouldCustomize(e.getScreen())) {
            return;
        }
        if (!AnimationHandler.isReady()) {
            return;
        }
        if (!GameIntroHandler.introDisplayed) {
            return;
        }
        if (LayoutEditorScreen.isActive) {
            return;
        }
        if (ButtonCache.isCaching()) {
            return;
        }
        if (!MenuCustomization.isMenuCustomizable(e.getScreen())) {
            return;
        }
        this.preinit = true;
        List<PropertiesSet> rawLayouts = MenuCustomizationProperties.getPropertiesWithIdentifier(this.getMenuIdentifier());
        String defaultGroup = "-100397";
        this.normalLayouts.clear();
        for (RandomLayoutContainer randomLayoutContainer : this.randomLayoutGroups.values()) {
            randomLayoutContainer.onlyFirstTime = false;
            randomLayoutContainer.clearLayouts();
        }
        this.sharedLayoutProps = new SharedLayoutProperties();
        for (PropertiesSet propertiesSet : rawLayouts) {
            String randomMode;
            String smallerthanheight;
            String smallerthanwidth;
            String biggerthanheight;
            void var7_17;
            List list = propertiesSet.getPropertiesOfType("customization-meta");
            if (list.isEmpty()) {
                List list2 = propertiesSet.getPropertiesOfType("type-meta");
            }
            if (var7_17.isEmpty()) continue;
            Object biggerthanwidth = ((PropertiesSection)var7_17.get(0)).getEntryValue("biggerthanwidth");
            if (biggerthanwidth != null && MathUtils.isInteger((String)(biggerthanwidth = ((String)biggerthanwidth).replace(" ", "")))) {
                int i = Integer.parseInt((String)biggerthanwidth);
                if (MainWindowHandler.getWindowGuiWidth() < i) continue;
            }
            if ((biggerthanheight = ((PropertiesSection)var7_17.get(0)).getEntryValue("biggerthanheight")) != null && MathUtils.isInteger((String)(biggerthanheight = biggerthanheight.replace(" ", "")))) {
                int i = Integer.parseInt(biggerthanheight);
                if (MainWindowHandler.getWindowGuiHeight() < i) continue;
            }
            if ((smallerthanwidth = ((PropertiesSection)var7_17.get(0)).getEntryValue("smallerthanwidth")) != null && MathUtils.isInteger((String)(smallerthanwidth = smallerthanwidth.replace(" ", "")))) {
                int i = Integer.parseInt(smallerthanwidth);
                if (MainWindowHandler.getWindowGuiWidth() > i) continue;
            }
            if ((smallerthanheight = ((PropertiesSection)var7_17.get(0)).getEntryValue("smallerthanheight")) != null && MathUtils.isInteger((String)(smallerthanheight = smallerthanheight.replace(" ", "")))) {
                int i = Integer.parseInt(smallerthanheight);
                if (MainWindowHandler.getWindowGuiHeight() > i) continue;
            }
            if ((randomMode = ((PropertiesSection)var7_17.get(0)).getEntryValue("randommode")) != null && randomMode.equalsIgnoreCase("true")) {
                RandomLayoutContainer c;
                String group = ((PropertiesSection)var7_17.get(0)).getEntryValue("randomgroup");
                if (group == null) {
                    group = defaultGroup;
                }
                if (!this.randomLayoutGroups.containsKey(group)) {
                    this.randomLayoutGroups.put(group, new RandomLayoutContainer(group, this));
                }
                if ((c = this.randomLayoutGroups.get(group)) == null) continue;
                String randomOnlyFirstTime = ((PropertiesSection)var7_17.get(0)).getEntryValue("randomonlyfirsttime");
                if (randomOnlyFirstTime != null && randomOnlyFirstTime.equalsIgnoreCase("true")) {
                    c.setOnlyFirstTime(true);
                }
                c.addLayout(propertiesSet);
                continue;
            }
            this.normalLayouts.add(propertiesSet);
        }
        ArrayList<String> trashLayoutGroups = new ArrayList<String>();
        for (Map.Entry<String, RandomLayoutContainer> entry : this.randomLayoutGroups.entrySet()) {
            if (!entry.getValue().getLayouts().isEmpty()) continue;
            trashLayoutGroups.add(entry.getKey());
        }
        for (String string : trashLayoutGroups) {
            this.randomLayoutGroups.remove(string);
        }
        for (PropertiesSet propertiesSet : this.normalLayouts) {
            for (PropertiesSection sec : propertiesSet.getPropertiesOfType("customization")) {
                this.applyLayoutPre(sec, e);
            }
        }
        for (RandomLayoutContainer randomLayoutContainer : this.randomLayoutGroups.values()) {
            PropertiesSet s = randomLayoutContainer.getRandomLayout();
            if (s == null) continue;
            for (PropertiesSection sec : s.getPropertiesOfType("customization")) {
                this.applyLayoutPre(sec, e);
            }
        }
        if (!this.sharedLayoutProps.scaled && scaleChangedIn != null) {
            scaleChangedIn = null;
            Window window = Minecraft.m_91087_().m_91268_();
            window.m_85378_((double)mcscale);
            e.getScreen().f_96543_ = window.m_85445_();
            e.getScreen().f_96544_ = window.m_85446_();
        }
        if (this.sharedLayoutProps.autoScaleBaseWidth != 0 && this.sharedLayoutProps.autoScaleBaseHeight != 0) {
            Window window = Minecraft.m_91087_().m_91268_();
            double d = (double)e.getScreen().f_96543_ * window.m_85449_();
            double guiHeight = (double)e.getScreen().f_96544_ * window.m_85449_();
            double percentX = d / (double)this.sharedLayoutProps.autoScaleBaseWidth * 100.0;
            double percentY = guiHeight / (double)this.sharedLayoutProps.autoScaleBaseHeight * 100.0;
            double newScaleX = percentX / 100.0 * window.m_85449_();
            double newScaleY = percentY / 100.0 * window.m_85449_();
            double newScale = Math.min(newScaleX, newScaleY);
            window.m_85378_(newScale);
            e.getScreen().f_96543_ = window.m_85445_();
            e.getScreen().f_96544_ = window.m_85446_();
            this.sharedLayoutProps.scaled = true;
            scaleChangedIn = e.getScreen();
        }
    }

    protected void applyLayoutPre(PropertiesSection sec, ScreenEvent.InitScreenEvent.Pre e) {
        String action = sec.getEntryValue("action");
        if (action != null) {
            String scale;
            String identifier = sec.getEntryValue("identifier");
            if (action.equalsIgnoreCase("overridemenu") && identifier != null && CustomGuiLoader.guiExists(identifier)) {
                CustomGuiBase cus = CustomGuiLoader.getGui(identifier, null, e.getScreen(), onClose -> e.getScreen().m_7861_());
                Minecraft.m_91087_().m_91152_((Screen)cus);
            }
            if (action.contentEquals("setscale") && (scale = sec.getEntryValue("scale")) != null && (MathUtils.isInteger((String)scale.replace(" ", "")) || MathUtils.isDouble((String)scale.replace(" ", "")))) {
                scaleChangedIn = e.getScreen();
                int newscale = (int)Double.parseDouble(scale.replace(" ", ""));
                if (newscale <= 0) {
                    newscale = 1;
                }
                Window m = Minecraft.m_91087_().m_91268_();
                m.m_85378_((double)newscale);
                e.getScreen().f_96543_ = m.m_85445_();
                e.getScreen().f_96544_ = m.m_85446_();
                this.sharedLayoutProps.scaled = true;
            }
            if (action.equalsIgnoreCase("autoscale")) {
                String baseHeight;
                String baseWidth = sec.getEntryValue("basewidth");
                if (MathUtils.isInteger((String)baseWidth)) {
                    this.sharedLayoutProps.autoScaleBaseWidth = Integer.parseInt(baseWidth);
                }
                if (MathUtils.isInteger((String)(baseHeight = sec.getEntryValue("baseheight")))) {
                    this.sharedLayoutProps.autoScaleBaseHeight = Integer.parseInt(baseHeight);
                }
            }
        }
    }

    @SubscribeEvent
    public void onButtonsCached(ButtonCachedEvent e) {
        if (e.getScreen() != Minecraft.m_91087_().f_91080_) {
            return;
        }
        if (!MenuCustomization.isValidScreen(e.getScreen())) {
            return;
        }
        if (!this.shouldCustomize(e.getScreen())) {
            return;
        }
        if (!AnimationHandler.isReady()) {
            return;
        }
        if (!GameIntroHandler.introDisplayed) {
            return;
        }
        if (LayoutEditorScreen.isActive) {
            return;
        }
        if (ButtonCache.isCaching()) {
            return;
        }
        if (!MenuCustomization.isMenuCustomizable(e.getScreen())) {
            return;
        }
        if (!this.preinit) {
            System.out.println("################ WARNING [FANCYMENU] ################");
            System.out.println("MenuHandler pre-init skipped! Trying to re-initialize menu!");
            System.out.println("Menu Type: " + e.getScreen().getClass().getName());
            System.out.println("Menu Handler: " + ((Object)((Object)this)).getClass().getName());
            System.out.println("This probably happened because a mod has overridden a menu with this one.");
            System.out.println("#####################################################");
            e.getScreen().m_6575_(Minecraft.m_91087_(), e.getScreen().f_96543_, e.getScreen().f_96544_);
            return;
        }
        this.hidden.clear();
        this.delayAppearanceVanilla.clear();
        this.fadeInVanilla.clear();
        this.vanillaButtonCustomizations.clear();
        this.vanillaButtonVisibilityRequirementContainers.clear();
        this.audio.clear();
        this.frontRenderItems.clear();
        this.backgroundRenderItems.clear();
        this.panoramacube = null;
        this.slideshow = null;
        this.customMenuBackground = null;
        this.backgroundAnimation = null;
        this.backgroundAnimations.clear();
        if (this.backgroundAnimation != null && this.backgroundAnimation instanceof AdvancedAnimation) {
            ((AdvancedAnimation)this.backgroundAnimation).stopAudio();
        }
        this.backgroundDrawable = false;
        for (PropertiesSet propertiesSet : this.normalLayouts) {
            List metas = propertiesSet.getPropertiesOfType("customization-meta");
            if (metas.isEmpty()) {
                metas = propertiesSet.getPropertiesOfType("type-meta");
            }
            String renderOrder = ((PropertiesSection)metas.get(0)).getEntryValue("renderorder");
            for (Object sec : propertiesSet.getPropertiesOfType("customization")) {
                this.applyLayout((PropertiesSection)sec, renderOrder, e);
            }
        }
        for (RandomLayoutContainer randomLayoutContainer : this.randomLayoutGroups.values()) {
            PropertiesSet s = randomLayoutContainer.getRandomLayout();
            if (s == null) continue;
            Object metas = s.getPropertiesOfType("customization-meta");
            if (metas.isEmpty()) {
                metas = s.getPropertiesOfType("type-meta");
            }
            String renderOrder = ((PropertiesSection)metas.get(0)).getEntryValue("renderorder");
            for (PropertiesSection sec : s.getPropertiesOfType("customization")) {
                this.applyLayout(sec, renderOrder, e);
            }
        }
        MenuHandlerRegistry.setActiveHandler(this.getMenuIdentifier());
        for (Map.Entry entry : this.sharedLayoutProps.descriptions.entrySet()) {
            AbstractWidget w = ((ButtonData)entry.getKey()).getButton();
            if (w == null) continue;
            VanillaButtonDescriptionHandler.setDescriptionFor(w, (String)entry.getValue());
        }
        for (String string : MenuCustomization.getSounds()) {
            if (this.audio.containsKey(string) || string.equals(this.openAudio) || string.equals(this.closeAudio)) continue;
            SoundHandler.stopSound((String)string);
            SoundHandler.resetSound((String)string);
        }
        if (!this.sharedLayoutProps.closeAudioSet && this.closeAudio != null) {
            MenuCustomization.unregisterSound(this.closeAudio);
            this.closeAudio = null;
        }
        if (!this.sharedLayoutProps.openAudioSet && this.openAudio != null) {
            MenuCustomization.unregisterSound(this.openAudio);
            this.openAudio = null;
        }
        for (Map.Entry entry : this.audio.entrySet()) {
            SoundHandler.playSound((String)((String)entry.getKey()));
            if (!((Boolean)entry.getValue()).booleanValue()) continue;
            SoundHandler.setLooped((String)((String)entry.getKey()), (boolean)true);
        }
        if (!this.sharedLayoutProps.backgroundTextureSet) {
            this.backgroundTexture = null;
        }
        for (ButtonData buttonData : this.hidden) {
            buttonData.getButton().f_93624_ = false;
        }
        for (CustomizationItemBase customizationItemBase : this.frontRenderItems) {
            if (MenuCustomization.isNewMenu()) {
                this.handleAppearanceDelayFor(customizationItemBase);
            }
            if (!customizationItemBase.orientation.equals("element") || customizationItemBase.orientationElementIdentifier == null) continue;
            customizationItemBase.orientationElement = this.getItemByActionId(customizationItemBase.orientationElementIdentifier);
        }
        for (CustomizationItemBase customizationItemBase : this.backgroundRenderItems) {
            if (MenuCustomization.isNewMenu()) {
                this.handleAppearanceDelayFor(customizationItemBase);
            }
            if (!customizationItemBase.orientation.equals("element") || customizationItemBase.orientationElementIdentifier == null) continue;
            customizationItemBase.orientationElement = this.getItemByActionId(customizationItemBase.orientationElementIdentifier);
        }
        for (Map.Entry entry : this.vanillaButtonVisibilityRequirementContainers.entrySet()) {
            boolean isBtnHidden = false;
            for (ButtonData d : this.hidden) {
                if (d.getButton() != entry.getKey()) continue;
                isBtnHidden = true;
                break;
            }
            if (isBtnHidden) continue;
            PropertiesSection dummySec = new PropertiesSection("customization");
            dummySec.addEntry("action", "vanilla_button_visibility_requirements");
            ButtonData btn = null;
            for (ButtonData d : ButtonCache.getButtons()) {
                if (d.getButton() != entry.getKey()) continue;
                btn = d;
                break;
            }
            if (btn == null) continue;
            VanillaButtonCustomizationItem i = new VanillaButtonCustomizationItem(dummySec, btn, this);
            i.visibilityRequirements = (VisibilityRequirementContainer)entry.getValue();
            this.backgroundRenderItems.add(i);
        }
        for (Map.Entry entry : this.delayAppearanceVanilla.entrySet()) {
            if (this.hidden.contains(entry.getKey()) || !this.visibilityRequirementsMet(((ButtonData)entry.getKey()).getButton())) continue;
            this.handleVanillaAppearanceDelayFor((ButtonData)entry.getKey());
        }
        ButtonCache.clearCustomButtonCache();
        for (CustomizationItemBase customizationItemBase : this.backgroundRenderItems) {
            if (!(customizationItemBase instanceof ButtonCustomizationItem)) continue;
            ButtonCache.cacheCustomButton(customizationItemBase.getActionId(), (AbstractWidget)((ButtonCustomizationItem)customizationItemBase).button);
        }
        for (CustomizationItemBase customizationItemBase : this.frontRenderItems) {
            if (!(customizationItemBase instanceof ButtonCustomizationItem)) continue;
            ButtonCache.cacheCustomButton(customizationItemBase.getActionId(), (AbstractWidget)((ButtonCustomizationItem)customizationItemBase).button);
        }
    }

    protected void applyLayout(PropertiesSection sec, String renderOrder, ButtonCachedEvent e) {
        String action = sec.getEntryValue("action");
        if (action != null) {
            String cusId;
            CustomizationItemContainer cusItem;
            String desc;
            File f;
            File f2;
            String clicks;
            String path;
            String value;
            String name;
            String keepAspect;
            String identifier = sec.getEntryValue("identifier");
            AbstractWidget b = null;
            ButtonData bd = null;
            if (identifier != null && (bd = MenuHandlerBase.getButton(identifier)) != null) {
                b = bd.getButton();
            }
            if (action.equalsIgnoreCase("backgroundoptions") && (keepAspect = sec.getEntryValue("keepaspectratio")) != null && keepAspect.equalsIgnoreCase("true")) {
                this.keepBackgroundAspectRatio = true;
            }
            if (action.equalsIgnoreCase("setbackgroundslideshow") && (name = sec.getEntryValue("name")) != null && SlideshowHandler.slideshowExists(name)) {
                this.slideshow = SlideshowHandler.getSlideshow(name);
            }
            if (action.equalsIgnoreCase("setbackgroundpanorama") && (name = sec.getEntryValue("name")) != null && PanoramaHandler.panoramaExists(name)) {
                this.panoramacube = PanoramaHandler.getPanorama(name);
            }
            if (action.equalsIgnoreCase("texturizebackground")) {
                File f3;
                value = CustomizationItemBase.fixBackslashPath(sec.getEntryValue("path"));
                String pano = sec.getEntryValue("wideformat");
                if (pano == null) {
                    pano = sec.getEntryValue("panorama");
                }
                if (value != null && (f3 = new File(value.replace("\\", "/"))).exists() && f3.isFile() && (f3.getName().toLowerCase().endsWith(".jpg") || f3.getName().toLowerCase().endsWith(".jpeg") || f3.getName().toLowerCase().endsWith(".png"))) {
                    if (this.backgroundTexture == null || !this.backgroundTexture.getPath().equals(value)) {
                        this.backgroundTexture = TextureHandler.getResource((String)value);
                    }
                    this.panoramaback = pano != null && pano.equalsIgnoreCase("true");
                    this.sharedLayoutProps.backgroundTextureSet = true;
                }
            }
            if (action.equalsIgnoreCase("animatebackground")) {
                value = sec.getEntryValue("name");
                String random = sec.getEntryValue("random");
                boolean ran = false;
                if (random != null && random.equalsIgnoreCase("true")) {
                    ran = true;
                }
                if (value != null) {
                    if (value.contains(",")) {
                        for (String s2 : value.split("[,]")) {
                            int i = 0;
                            for (char c : s2.toCharArray()) {
                                if (c != " ".charAt(0)) break;
                                ++i;
                            }
                            if (i > s2.length()) continue;
                            String temp = new StringBuilder(s2.substring(i)).reverse().toString();
                            int i2 = 0;
                            for (char c : temp.toCharArray()) {
                                if (c != " ".charAt(0)) break;
                                ++i2;
                            }
                            String name2 = new StringBuilder(temp.substring(i2)).reverse().toString();
                            if (!AnimationHandler.animationExists(name2)) continue;
                            this.backgroundAnimations.add(AnimationHandler.getAnimation(name2));
                        }
                    } else if (AnimationHandler.animationExists(value)) {
                        this.backgroundAnimations.add(AnimationHandler.getAnimation(value));
                    }
                    if (!this.backgroundAnimations.isEmpty()) {
                        if (ran) {
                            if (MenuCustomization.isNewMenu()) {
                                this.backgroundAnimationId = MathUtils.getRandomNumberInRange((int)0, (int)(this.backgroundAnimations.size() - 1));
                            }
                            this.backgroundAnimation = this.backgroundAnimations.get(this.backgroundAnimationId);
                        } else {
                            if (this.lastBackgroundAnimation != null && this.backgroundAnimations.contains(this.lastBackgroundAnimation)) {
                                this.backgroundAnimation = this.lastBackgroundAnimation;
                            } else {
                                this.backgroundAnimationId = 0;
                                this.backgroundAnimation = this.backgroundAnimations.get(0);
                            }
                            this.lastBackgroundAnimation = this.backgroundAnimation;
                        }
                    }
                }
            }
            if (action.equalsIgnoreCase("api:custombackground")) {
                MenuBackgroundType type;
                String typeId = sec.getEntryValue("type_identifier");
                String backId = sec.getEntryValue("background_identifier");
                String inputString = sec.getEntryValue("input_string");
                if (typeId != null && (type = MenuBackgroundTypeRegistry.getBackgroundTypeByIdentifier(typeId)) != null) {
                    if (type.needsInputString() && inputString != null) {
                        try {
                            this.customMenuBackground = type.createInstanceFromInputString(inputString);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                        if (this.customMenuBackground != null && MenuCustomization.isNewMenu()) {
                            this.customMenuBackground.onOpenMenu();
                        }
                    } else if (backId != null) {
                        this.customMenuBackground = type.getBackgroundByIdentifier(backId);
                        if (this.customMenuBackground != null && MenuCustomization.isNewMenu()) {
                            this.customMenuBackground.onOpenMenu();
                        }
                    }
                }
            }
            if (action.equalsIgnoreCase("hidebuttonfor")) {
                String time = sec.getEntryValue("seconds");
                String onlyfirsttime = sec.getEntryValue("onlyfirsttime");
                String fadein = sec.getEntryValue("fadein");
                String fadeinspeed = sec.getEntryValue("fadeinspeed");
                if (b != null && MenuCustomization.isNewMenu()) {
                    boolean ft = false;
                    if (onlyfirsttime != null && onlyfirsttime.equalsIgnoreCase("true")) {
                        ft = true;
                    }
                    if (!(time == null || !MathUtils.isFloat((String)time) || ft && this.delayAppearanceFirstTimeVanilla.contains(bd.getId()))) {
                        this.delayAppearanceVanilla.put(bd, Float.valueOf(Float.parseFloat(time)));
                    }
                    if (ft && !this.delayAppearanceFirstTimeVanilla.contains(bd.getId())) {
                        this.delayAppearanceFirstTimeVanilla.add(bd.getId());
                    }
                    if (fadein != null && fadein.equalsIgnoreCase("true")) {
                        float speed = 1.0f;
                        if (fadeinspeed != null && MathUtils.isFloat((String)fadeinspeed)) {
                            speed = Float.parseFloat(fadeinspeed);
                        }
                        this.fadeInVanilla.put(bd, Float.valueOf(speed));
                    }
                }
            }
            if (action.equalsIgnoreCase("hidebutton") && b != null) {
                this.hidden.add(bd);
            }
            if ((action.equalsIgnoreCase("renamebutton") || action.equalsIgnoreCase("setbuttonlabel")) && b != null) {
                this.backgroundRenderItems.add(new VanillaButtonCustomizationItem(sec, bd, this));
            }
            if (action.equalsIgnoreCase("resizebutton")) {
                String width = sec.getEntryValue("width");
                String height = sec.getEntryValue("height");
                if (width != null) {
                    width = DynamicValueHelper.convertFromRaw(width);
                }
                if (height != null) {
                    height = DynamicValueHelper.convertFromRaw(height);
                }
                if (width != null && height != null && b != null && MathUtils.isInteger((String)width) && MathUtils.isInteger((String)height)) {
                    b.m_93674_(Integer.parseInt(width));
                    b.setHeight(Integer.parseInt(height));
                }
            }
            if (action.equalsIgnoreCase("movebutton") && b != null) {
                this.backgroundRenderItems.add(new VanillaButtonCustomizationItem(sec, bd, this));
            }
            if (action.equalsIgnoreCase("setbuttontexture") && b != null) {
                String restartBackAnimationsOnHover;
                String loopBackAnimations = sec.getEntryValue("loopbackgroundanimations");
                if (loopBackAnimations != null && loopBackAnimations.equalsIgnoreCase("false")) {
                    this.getContainerForVanillaButton((AbstractWidget)b).loopAnimation = false;
                }
                if ((restartBackAnimationsOnHover = sec.getEntryValue("restartbackgroundanimations")) != null && restartBackAnimationsOnHover.equalsIgnoreCase("false")) {
                    this.getContainerForVanillaButton((AbstractWidget)b).restartAnimationOnHover = false;
                }
                String backNormal = CustomizationItemBase.fixBackslashPath(sec.getEntryValue("backgroundnormal"));
                String backHover = CustomizationItemBase.fixBackslashPath(sec.getEntryValue("backgroundhovered"));
                if (backNormal != null) {
                    this.getContainerForVanillaButton((AbstractWidget)b).normalBackground = backNormal;
                } else {
                    String backAniNormal = sec.getEntryValue("backgroundanimationnormal");
                    if (backAniNormal != null) {
                        this.getContainerForVanillaButton((AbstractWidget)b).normalBackground = "animation:" + backAniNormal;
                    }
                }
                if (backHover != null) {
                    this.getContainerForVanillaButton((AbstractWidget)b).hoverBackground = backHover;
                } else {
                    String backAniHover = sec.getEntryValue("backgroundanimationhovered");
                    if (backAniHover != null) {
                        this.getContainerForVanillaButton((AbstractWidget)b).hoverBackground = "animation:" + backAniHover;
                    }
                }
            }
            if (action.equalsIgnoreCase("setbuttonclicksound") && b != null && (path = CustomizationItemBase.fixBackslashPath(sec.getEntryValue("path"))) != null) {
                this.getContainerForVanillaButton((AbstractWidget)b).clickSound = path;
            }
            if (action.equalsIgnoreCase("vanilla_button_visibility_requirements") && b != null) {
                this.vanillaButtonVisibilityRequirementContainers.put(b, new VanillaButtonCustomizationItem((PropertiesSection)sec, (ButtonData)bd, (MenuHandlerBase)this).visibilityRequirementContainer);
            }
            if (action.equalsIgnoreCase("addhoversound") && b != null) {
                if (renderOrder != null && renderOrder.equalsIgnoreCase("background")) {
                    this.backgroundRenderItems.add(new VanillaButtonCustomizationItem(sec, bd, this));
                } else {
                    this.frontRenderItems.add(new VanillaButtonCustomizationItem(sec, bd, this));
                }
            }
            if (action.equalsIgnoreCase("sethoverlabel") && b != null) {
                if (renderOrder != null && renderOrder.equalsIgnoreCase("background")) {
                    this.backgroundRenderItems.add(new VanillaButtonCustomizationItem(sec, bd, this));
                } else {
                    this.frontRenderItems.add(new VanillaButtonCustomizationItem(sec, bd, this));
                }
            }
            if (action.equalsIgnoreCase("clickbutton") && b != null && (clicks = sec.getEntryValue("clicks")) != null && MathUtils.isInteger((String)clicks)) {
                for (int i = 0; i < Integer.parseInt(clicks); ++i) {
                    b.m_5716_((double)MouseInput.getMouseX(), (double)MouseInput.getMouseY());
                }
            }
            if (action.equalsIgnoreCase("addtext")) {
                if (renderOrder != null && renderOrder.equalsIgnoreCase("background")) {
                    this.backgroundRenderItems.add(new StringCustomizationItem(sec));
                } else {
                    this.frontRenderItems.add(new StringCustomizationItem(sec));
                }
            }
            if (action.equalsIgnoreCase("addwebtext")) {
                if (renderOrder != null && renderOrder.equalsIgnoreCase("background")) {
                    this.backgroundRenderItems.add(new WebStringCustomizationItem(sec));
                } else {
                    this.frontRenderItems.add(new WebStringCustomizationItem(sec));
                }
            }
            if (action.equalsIgnoreCase("addtexture")) {
                if (renderOrder != null && renderOrder.equalsIgnoreCase("background")) {
                    this.backgroundRenderItems.add(new TextureCustomizationItem(sec));
                } else {
                    this.frontRenderItems.add(new TextureCustomizationItem(sec));
                }
            }
            if (action.equalsIgnoreCase("addwebtexture")) {
                if (renderOrder != null && renderOrder.equalsIgnoreCase("background")) {
                    this.backgroundRenderItems.add(new WebTextureCustomizationItem(sec));
                } else {
                    this.frontRenderItems.add(new WebTextureCustomizationItem(sec));
                }
            }
            if (action.equalsIgnoreCase("addanimation")) {
                if (renderOrder != null && renderOrder.equalsIgnoreCase("background")) {
                    this.backgroundRenderItems.add(new AnimationCustomizationItem(sec));
                } else {
                    this.frontRenderItems.add(new AnimationCustomizationItem(sec));
                }
            }
            if (action.equalsIgnoreCase("addshape")) {
                if (renderOrder != null && renderOrder.equalsIgnoreCase("background")) {
                    this.backgroundRenderItems.add(new ShapeCustomizationItem(sec));
                } else {
                    this.frontRenderItems.add(new ShapeCustomizationItem(sec));
                }
            }
            if (action.equalsIgnoreCase("addslideshow")) {
                if (renderOrder != null && renderOrder.equalsIgnoreCase("background")) {
                    this.backgroundRenderItems.add(new SlideshowCustomizationItem(sec));
                } else {
                    this.frontRenderItems.add(new SlideshowCustomizationItem(sec));
                }
            }
            if (action.equalsIgnoreCase("addentity")) {
                if (renderOrder != null && renderOrder.equalsIgnoreCase("background")) {
                    this.backgroundRenderItems.add(new PlayerEntityCustomizationItem(sec));
                } else {
                    this.frontRenderItems.add(new PlayerEntityCustomizationItem(sec));
                }
            }
            if (action.equalsIgnoreCase("addbutton")) {
                ButtonCustomizationItem i = new ButtonCustomizationItem(sec);
                if (renderOrder != null && renderOrder.equalsIgnoreCase("background")) {
                    this.backgroundRenderItems.add(i);
                } else {
                    this.frontRenderItems.add(i);
                }
            }
            if (action.equalsIgnoreCase("addaudio") && ((Boolean)FancyMenu.config.getOrDefault("playbackgroundsounds", (Object)true)).booleanValue() && (Minecraft.m_91087_().f_91073_ == null || ((Boolean)FancyMenu.config.getOrDefault("playbackgroundsoundsinworld", (Object)false)).booleanValue())) {
                File f4;
                path = CustomizationItemBase.fixBackslashPath(sec.getEntryValue("path"));
                String loopString = sec.getEntryValue("loop");
                boolean loop = false;
                if (loopString != null && loopString.equalsIgnoreCase("true")) {
                    loop = true;
                }
                if (path != null && (f4 = new File(path)).isFile() && f4.exists() && f4.getName().endsWith(".wav")) {
                    try {
                        String name3 = path + Files.size(f4.toPath());
                        MenuCustomization.registerSound(name3, path);
                        this.audio.put(name3, loop);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
            if (action.equalsIgnoreCase("setcloseaudio") && (path = CustomizationItemBase.fixBackslashPath(sec.getEntryValue("path"))) != null && (f2 = new File(path)).isFile() && f2.exists() && f2.getName().endsWith(".wav")) {
                try {
                    String name4 = "closesound_" + path + Files.size(f2.toPath());
                    MenuCustomization.registerSound(name4, path);
                    this.closeAudio = name4;
                    this.sharedLayoutProps.closeAudioSet = true;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (action.equalsIgnoreCase("setopenaudio") && (path = CustomizationItemBase.fixBackslashPath(sec.getEntryValue("path"))) != null && (f = new File(path)).isFile() && f.exists() && f.getName().endsWith(".wav")) {
                try {
                    String name5 = "opensound_" + path + Files.size(f.toPath());
                    MenuCustomization.registerSound(name5, path);
                    SoundHandler.resetSound((String)name5);
                    SoundHandler.playSound((String)name5);
                    this.openAudio = name5;
                    this.sharedLayoutProps.openAudioSet = true;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (action.equalsIgnoreCase("setbuttondescription") && b != null && (desc = sec.getEntryValue("description")) != null) {
                this.sharedLayoutProps.descriptions.put(bd, DynamicValueHelper.convertFromRaw(desc));
            }
            if (action.equalsIgnoreCase("addsplash")) {
                String file = CustomizationItemBase.fixBackslashPath(sec.getEntryValue("splashfilepath"));
                String text = sec.getEntryValue("text");
                if (file != null || text != null) {
                    SplashTextCustomizationItem i = new SplashTextCustomizationItem(sec);
                    if (renderOrder != null && renderOrder.equalsIgnoreCase("background")) {
                        this.backgroundRenderItems.add(i);
                    } else {
                        this.frontRenderItems.add(i);
                    }
                }
            }
            if (action.startsWith("custom_layout_element:") && (cusItem = CustomizationItemRegistry.getItem(cusId = action.split("[:]", 2)[1])) != null) {
                CustomizationItem cusItemInstance = cusItem.constructCustomizedItemInstance(sec);
                if (renderOrder != null && renderOrder.equalsIgnoreCase("background")) {
                    this.backgroundRenderItems.add(cusItemInstance);
                } else {
                    this.frontRenderItems.add(cusItemInstance);
                }
            }
        }
    }

    protected void handleAppearanceDelayFor(final CustomizationItemBase i) {
        if (!(i instanceof VanillaButtonCustomizationItem) && i.delayAppearance) {
            if (i.getActionId() == null) {
                return;
            }
            if (!i.delayAppearanceEverytime && this.delayAppearanceFirstTime.contains(i.getActionId())) {
                return;
            }
            if (!i.delayAppearanceEverytime && !this.delayAppearanceFirstTime.contains(i.getActionId())) {
                this.delayAppearanceFirstTime.add(i.getActionId());
            }
            i.visible = false;
            if (i.fadeIn) {
                i.opacity = 0.1f;
            }
            final ThreadCaller c = new ThreadCaller();
            this.delayThreads.add(c);
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    long start = System.currentTimeMillis();
                    float delay = (float)(1000.0 * (double)i.delayAppearanceSec);
                    boolean fade = false;
                    while (c.running.get()) {
                        try {
                            long now = System.currentTimeMillis();
                            if (!fade) {
                                if (now >= start + (long)((int)delay)) {
                                    i.visible = true;
                                    if (!i.fadeIn) {
                                        return;
                                    }
                                    fade = true;
                                }
                            } else {
                                float o = i.opacity + 0.03f * i.fadeInSpeed;
                                if (o > 1.0f) {
                                    o = 1.0f;
                                }
                                if (i.opacity < 1.0f) {
                                    i.opacity = o;
                                } else {
                                    return;
                                }
                            }
                            Thread.sleep(50L);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            });
            t.start();
        }
    }

    protected void handleVanillaAppearanceDelayFor(final ButtonData d) {
        if (this.delayAppearanceVanilla.containsKey(d)) {
            final boolean fadein = this.fadeInVanilla.containsKey(d);
            final float delaysec = this.delayAppearanceVanilla.get(d).floatValue();
            final VisibilityRequirementContainer vis = this.vanillaButtonVisibilityRequirementContainers.get(d.getButton());
            d.getButton().f_93624_ = false;
            if (vis != null) {
                vis.forceHide = true;
            }
            if (fadein) {
                d.getButton().m_93650_(0.1f);
            }
            final ThreadCaller c = new ThreadCaller();
            this.delayThreads.add(c);
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    float fadespeed = 1.0f;
                    if (fadein && MenuHandlerBase.this.fadeInVanilla.containsKey(d)) {
                        fadespeed = MenuHandlerBase.this.fadeInVanilla.get(d).floatValue();
                    }
                    float opacity = 0.1f;
                    long start = System.currentTimeMillis();
                    float delay = (float)(1000.0 * (double)delaysec);
                    boolean fade = false;
                    while (c.running.get()) {
                        try {
                            long now = System.currentTimeMillis();
                            if (!fade) {
                                if (now >= start + (long)((int)delay)) {
                                    d.getButton().f_93624_ = true;
                                    if (vis != null) {
                                        vis.forceHide = false;
                                    }
                                    if (!fadein) {
                                        return;
                                    }
                                    fade = true;
                                }
                            } else {
                                float o = opacity + 0.03f * fadespeed;
                                if (o > 1.0f) {
                                    o = 1.0f;
                                }
                                if (opacity < 1.0f) {
                                    opacity = o;
                                    d.getButton().m_93650_(opacity);
                                } else {
                                    return;
                                }
                            }
                            Thread.sleep(50L);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            });
            t.start();
        }
    }

    @SubscribeEvent
    public void onRenderPost(ScreenEvent.DrawScreenEvent.Post e) {
        if (PopupHandler.isPopupActive()) {
            return;
        }
        if (!this.shouldCustomize(e.getScreen())) {
            return;
        }
        if (!MenuCustomization.isMenuCustomizable(e.getScreen())) {
            return;
        }
        if (!this.backgroundDrawable) {
            ArrayList<CustomizationItemBase> backItems = new ArrayList<CustomizationItemBase>();
            backItems.addAll(this.backgroundRenderItems);
            for (CustomizationItemBase i : backItems) {
                try {
                    i.render(e.getPoseStack(), e.getScreen());
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
        ArrayList<CustomizationItemBase> frontItems = new ArrayList<CustomizationItemBase>();
        frontItems.addAll(this.frontRenderItems);
        for (CustomizationItemBase i : frontItems) {
            try {
                i.render(e.getPoseStack(), e.getScreen());
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public void drawToBackground(ScreenEvent.BackgroundDrawnEvent e) {
        if (!MenuCustomization.isCurrentMenuScrollable()) {
            this.renderBackground(e.getPoseStack(), e.getScreen());
        }
    }

    protected void renderBackground(PoseStack matrix, Screen s) {
        if (this.shouldCustomize(s)) {
            if (!MenuCustomization.isMenuCustomizable(s)) {
                return;
            }
            if (this.canRenderBackground()) {
                if (this.backgroundAnimation != null && this.backgroundAnimation.isReady()) {
                    boolean b = this.backgroundAnimation.isStretchedToStreensize();
                    int wOri = this.backgroundAnimation.getWidth();
                    int hOri = this.backgroundAnimation.getHeight();
                    int xOri = this.backgroundAnimation.getPosX();
                    int yOri = this.backgroundAnimation.getPosY();
                    if (!this.keepBackgroundAspectRatio) {
                        this.backgroundAnimation.setStretchImageToScreensize(true);
                    } else {
                        double ratio = (double)wOri / (double)hOri;
                        int wfinal = (int)((double)s.f_96544_ * ratio);
                        int screenCenterX = s.f_96543_ / 2;
                        if (wfinal < s.f_96543_) {
                            this.backgroundAnimation.setStretchImageToScreensize(true);
                        } else {
                            this.backgroundAnimation.setWidth(wfinal + 1);
                            this.backgroundAnimation.setHeight(s.f_96544_ + 1);
                            this.backgroundAnimation.setPosX(screenCenterX - wfinal / 2);
                            this.backgroundAnimation.setPosY(0);
                        }
                    }
                    this.backgroundAnimation.render(CurrentScreenHandler.getPoseStack());
                    this.backgroundAnimation.setWidth(wOri);
                    this.backgroundAnimation.setHeight(hOri);
                    this.backgroundAnimation.setPosX(xOri);
                    this.backgroundAnimation.setPosY(yOri);
                    this.backgroundAnimation.setStretchImageToScreensize(b);
                } else if (this.backgroundTexture != null) {
                    RenderSystem.m_69478_();
                    RenderUtils.bindTexture((ResourceLocation)this.backgroundTexture.getResourceLocation());
                    if (!this.panoramaback) {
                        if (!this.keepBackgroundAspectRatio) {
                            GuiComponent.m_93133_((PoseStack)CurrentScreenHandler.getPoseStack(), (int)0, (int)0, (float)1.0f, (float)1.0f, (int)(s.f_96543_ + 1), (int)(s.f_96544_ + 1), (int)(s.f_96543_ + 1), (int)(s.f_96544_ + 1));
                        } else {
                            w = this.backgroundTexture.getWidth();
                            h = this.backgroundTexture.getHeight();
                            ratio = (double)w / (double)h;
                            wfinal = (int)((double)s.f_96544_ * ratio);
                            int screenCenterX = s.f_96543_ / 2;
                            if (wfinal < s.f_96543_) {
                                GuiComponent.m_93133_((PoseStack)CurrentScreenHandler.getPoseStack(), (int)0, (int)0, (float)1.0f, (float)1.0f, (int)(s.f_96543_ + 1), (int)(s.f_96544_ + 1), (int)(s.f_96543_ + 1), (int)(s.f_96544_ + 1));
                            } else {
                                GuiComponent.m_93133_((PoseStack)CurrentScreenHandler.getPoseStack(), (int)(screenCenterX - wfinal / 2), (int)0, (float)1.0f, (float)1.0f, (int)(wfinal + 1), (int)(s.f_96544_ + 1), (int)(wfinal + 1), (int)(s.f_96544_ + 1));
                            }
                        }
                    } else {
                        w = this.backgroundTexture.getWidth();
                        ratio = (double)w / (double)(h = this.backgroundTexture.getHeight());
                        wfinal = (int)((double)s.f_96544_ * ratio);
                        if (this.panoPos + (double)(wfinal - s.f_96543_) <= 0.0) {
                            this.panoMoveBack = true;
                        }
                        if (this.panoPos >= 0.0) {
                            this.panoMoveBack = false;
                        }
                        if (this.panoPos + (double)(wfinal - s.f_96543_) < 0.0) {
                            this.panoPos = 0 - (wfinal - s.f_96543_);
                        }
                        if (this.panoPos > 0.0) {
                            this.panoPos = 0.0;
                        }
                        if (!this.panoStop) {
                            if (this.panoTick >= 1) {
                                this.panoTick = 0;
                                this.panoPos = this.panoMoveBack ? (this.panoPos += 0.5) : (this.panoPos -= 0.5);
                                if (this.panoPos + (double)(wfinal - s.f_96543_) == 0.0) {
                                    this.panoStop = true;
                                }
                                if (this.panoPos == 0.0) {
                                    this.panoStop = true;
                                }
                            } else {
                                ++this.panoTick;
                            }
                        } else if (this.panoTick >= 300) {
                            this.panoStop = false;
                            this.panoTick = 0;
                        } else {
                            ++this.panoTick;
                        }
                        if (wfinal <= s.f_96543_) {
                            GuiComponent.m_93133_((PoseStack)CurrentScreenHandler.getPoseStack(), (int)0, (int)0, (float)1.0f, (float)1.0f, (int)(s.f_96543_ + 1), (int)(s.f_96544_ + 1), (int)(s.f_96543_ + 1), (int)(s.f_96544_ + 1));
                        } else {
                            RenderUtils.doubleBlit((double)this.panoPos, (double)0.0, (float)1.0f, (float)1.0f, (int)wfinal, (int)(s.f_96544_ + 1));
                        }
                    }
                    RenderSystem.m_69461_();
                } else if (this.panoramacube != null) {
                    this.panoramacube.render();
                } else if (this.slideshow != null) {
                    int sw = this.slideshow.width;
                    int sh = this.slideshow.height;
                    int sx = this.slideshow.x;
                    int sy = this.slideshow.y;
                    if (!this.keepBackgroundAspectRatio) {
                        this.slideshow.width = s.f_96543_ + 1;
                        this.slideshow.height = s.f_96544_ + 1;
                        this.slideshow.x = 0;
                    } else {
                        double ratio = (double)sw / (double)sh;
                        int wfinal = (int)((double)s.f_96544_ * ratio);
                        int screenCenterX = s.f_96543_ / 2;
                        if (wfinal < s.f_96543_) {
                            this.slideshow.width = s.f_96543_ + 1;
                            this.slideshow.height = s.f_96544_ + 1;
                            this.slideshow.x = 0;
                        } else {
                            this.slideshow.width = wfinal + 1;
                            this.slideshow.height = s.f_96544_ + 1;
                            this.slideshow.x = screenCenterX - wfinal / 2;
                        }
                    }
                    this.slideshow.y = 0;
                    this.slideshow.render(matrix);
                    this.slideshow.width = sw;
                    this.slideshow.height = sh;
                    this.slideshow.x = sx;
                    this.slideshow.y = sy;
                } else if (this.customMenuBackground != null) {
                    this.customMenuBackground.render(matrix, s, this.keepBackgroundAspectRatio);
                }
            }
            if (PopupHandler.isPopupActive()) {
                return;
            }
            ArrayList<CustomizationItemBase> backItems = new ArrayList<CustomizationItemBase>();
            backItems.addAll(this.backgroundRenderItems);
            for (CustomizationItemBase i : backItems) {
                try {
                    i.render(CurrentScreenHandler.getPoseStack(), s);
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            this.backgroundDrawable = true;
        }
    }

    @SubscribeEvent
    public void onButtonClickSound(PlayWidgetClickSoundEvent.Pre e) {
        File f;
        ButtonCustomizationContainer c;
        if (this.shouldCustomize(Minecraft.m_91087_().f_91080_) && MenuCustomization.isMenuCustomizable(Minecraft.m_91087_().f_91080_) && (c = this.vanillaButtonCustomizations.get(e.getWidget())) != null && c.clickSound != null && (f = new File(c.clickSound)).exists() && f.isFile() && f.getPath().toLowerCase().endsWith(".wav")) {
            SoundHandler.registerSound((String)f.getPath(), (String)f.getPath());
            SoundHandler.resetSound((String)f.getPath());
            SoundHandler.playSound((String)f.getPath());
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onButtonRenderBackground(RenderWidgetBackgroundEvent.Pre e) {
        AbstractWidget w;
        ButtonCustomizationContainer c;
        if (this.shouldCustomize(Minecraft.m_91087_().f_91080_) && MenuCustomization.isMenuCustomizable(Minecraft.m_91087_().f_91080_) && (c = this.vanillaButtonCustomizations.get(w = e.getWidget())) != null) {
            String normalBack = c.normalBackground;
            String hoverBack = c.hoverBackground;
            boolean hasCustomBackground = false;
            if (c.lastHoverState != w.m_198029_() && w.m_198029_() && c.restartAnimationOnHover) {
                for (IAnimationRenderer i : c.cachedAnimations) {
                    if (i == null) continue;
                    i.resetAnimation();
                }
            }
            c.lastHoverState = w.m_198029_();
            if (!w.m_198029_() && normalBack != null && this.renderCustomButtomBackground(e, normalBack)) {
                hasCustomBackground = true;
            }
            if (w.m_198029_()) {
                if (w.f_93623_) {
                    if (hoverBack != null && this.renderCustomButtomBackground(e, hoverBack)) {
                        hasCustomBackground = true;
                    }
                } else if (normalBack != null && this.renderCustomButtomBackground(e, normalBack)) {
                    hasCustomBackground = true;
                }
            }
            if (hasCustomBackground) {
                Component msg;
                if (w instanceof ImageButton && (msg = w.m_6035_()) != null) {
                    GuiComponent.m_93215_((PoseStack)e.getPoseStack(), (Font)Minecraft.m_91087_().f_91062_, (Component)msg, (int)(w.f_93620_ + w.m_5711_() / 2), (int)(w.f_93621_ + (w.m_93694_() - 8) / 2), (int)(w.getFGColor() | Mth.m_14167_((float)(e.getAlpha() * 255.0f)) << 24));
                }
                e.setCanceled(true);
            }
        }
    }

    protected boolean renderCustomButtomBackground(RenderWidgetBackgroundEvent e, String background) {
        AbstractWidget w = e.getWidget();
        PoseStack matrix = e.getPoseStack();
        ButtonCustomizationContainer c = this.vanillaButtonCustomizations.get(w);
        if (c != null && w != null && background != null) {
            if (background.startsWith("animation:")) {
                String aniName = background.split("[:]", 2)[1];
                if (AnimationHandler.animationExists(aniName)) {
                    IAnimationRenderer a = AnimationHandler.getAnimation(aniName);
                    this.renderBackgroundAnimation(e, a);
                    if (!c.cachedAnimations.contains(a)) {
                        c.cachedAnimations.add(a);
                    }
                    return true;
                }
            } else {
                File f = new File(background);
                if (f.isFile()) {
                    ExternalTextureResourceLocation back;
                    if (f.getPath().toLowerCase().endsWith(".gif")) {
                        ExternalGifAnimationRenderer a = TextureHandler.getGifResource((String)f.getPath());
                        this.renderBackgroundAnimation(e, (IAnimationRenderer)a);
                        if (!c.cachedAnimations.contains(a)) {
                            c.cachedAnimations.add((IAnimationRenderer)a);
                        }
                        return true;
                    }
                    if ((f.getPath().toLowerCase().endsWith(".jpg") || f.getPath().toLowerCase().endsWith(".jpeg") || f.getPath().toLowerCase().endsWith(".png")) && (back = TextureHandler.getResource((String)f.getPath())) != null) {
                        RenderUtils.bindTexture((ResourceLocation)back.getResourceLocation());
                        RenderSystem.m_69478_();
                        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)e.getAlpha());
                        GuiComponent.m_93133_((PoseStack)matrix, (int)w.f_93620_, (int)w.f_93621_, (float)0.0f, (float)0.0f, (int)w.m_5711_(), (int)w.m_93694_(), (int)w.m_5711_(), (int)w.m_93694_());
                        return true;
                    }
                }
            }
        }
        return false;
    }

    protected void renderBackgroundAnimation(RenderWidgetBackgroundEvent e, IAnimationRenderer ani) {
        AbstractWidget w = e.getWidget();
        ButtonCustomizationContainer c = this.vanillaButtonCustomizations.get(w);
        if (c != null && ani != null) {
            if (!ani.isReady()) {
                ani.prepareAnimation();
            }
            int aniX = ani.getPosX();
            int aniY = ani.getPosY();
            int aniWidth = ani.getWidth();
            int aniHeight = ani.getHeight();
            boolean aniLoop = ani.isGettingLooped();
            ani.setPosX(w.f_93620_);
            ani.setPosY(w.f_93621_);
            ani.setWidth(w.m_5711_());
            ani.setHeight(w.m_93694_());
            ani.setLooped(c.loopAnimation);
            ani.setOpacity(e.getAlpha());
            if (ani instanceof AdvancedAnimation) {
                ((AdvancedAnimation)ani).setMuteAudio(true);
            }
            ani.render(e.getPoseStack());
            ani.setPosX(aniX);
            ani.setPosY(aniY);
            ani.setWidth(aniWidth);
            ani.setHeight(aniHeight);
            ani.setLooped(aniLoop);
            ani.setOpacity(1.0f);
            if (ani instanceof AdvancedAnimation) {
                ((AdvancedAnimation)ani).setMuteAudio(false);
            }
        }
    }

    protected ButtonCustomizationContainer getContainerForVanillaButton(AbstractWidget w) {
        if (!this.vanillaButtonCustomizations.containsKey(w)) {
            ButtonCustomizationContainer c = new ButtonCustomizationContainer();
            this.vanillaButtonCustomizations.put(w, c);
            return c;
        }
        return this.vanillaButtonCustomizations.get(w);
    }

    protected CustomizationItemBase getItemByActionId(String actionId) {
        String idRaw;
        ButtonData d;
        String id;
        for (CustomizationItemBase c : this.backgroundRenderItems) {
            if (!(c instanceof VanillaButtonCustomizationItem ? (id = "vanillabtn:" + ((VanillaButtonCustomizationItem)c).getButtonId()).equals(actionId) : c.getActionId().equals(actionId))) continue;
            return c;
        }
        for (CustomizationItemBase c : this.frontRenderItems) {
            if (!(c instanceof VanillaButtonCustomizationItem ? (id = "vanillabtn:" + ((VanillaButtonCustomizationItem)c).getButtonId()).equals(actionId) : c.getActionId().equals(actionId))) continue;
            return c;
        }
        if (actionId.startsWith("vanillabtn:") && (d = MathUtils.isLong((String)(idRaw = actionId.split("[:]", 2)[1])) ? ButtonCache.getButtonForId(Long.parseLong(idRaw)) : ButtonCache.getButtonForCompatibilityId(idRaw)) != null && d.getButton() != null) {
            VanillaButtonCustomizationItem vb = new VanillaButtonCustomizationItem(new PropertiesSection("customization"), d, this);
            vb.orientation = "top-left";
            vb.posX = d.getButton().f_93620_;
            vb.posY = d.getButton().f_93621_;
            vb.width = d.getButton().m_5711_();
            vb.height = d.getButton().m_93694_();
            return vb;
        }
        return null;
    }

    protected boolean visibilityRequirementsMet(AbstractWidget b) {
        VisibilityRequirementContainer c = this.vanillaButtonVisibilityRequirementContainers.get(b);
        if (c != null) {
            return c.isVisible();
        }
        return true;
    }

    @SubscribeEvent
    public void onRenderListBackground(RenderGuiListBackgroundEvent.Post e) {
        Screen s = Minecraft.m_91087_().f_91080_;
        if (this.shouldCustomize(s) && MenuCustomization.isMenuCustomizable(s) && Minecraft.m_91087_().f_91080_ != null) {
            this.renderBackground(e.getPoseStack(), s);
        }
    }

    private static ButtonData getButton(String identifier) {
        if (identifier.startsWith("%id=")) {
            String p = identifier.split("[=]")[1].replace("%", "");
            if (MathUtils.isLong((String)p)) {
                return ButtonCache.getButtonForId(Long.parseLong(p));
            }
            if (p.startsWith("button_compatibility_id:")) {
                return ButtonCache.getButtonForCompatibilityId(p);
            }
        } else {
            ButtonData b = I18n.m_118936_((String)identifier) ? ButtonCache.getButtonForKey(identifier) : ButtonCache.getButtonForName(identifier);
            return b;
        }
        return null;
    }

    protected boolean shouldCustomize(Screen menu) {
        if (menu == null) {
            return false;
        }
        return this.getMenuIdentifier() == null || this.getMenuIdentifier().equals(menu.getClass().getName());
    }

    public boolean canRenderBackground() {
        return this.backgroundAnimation != null || this.backgroundTexture != null || this.panoramacube != null || this.slideshow != null || this.customMenuBackground != null;
    }

    public boolean setBackgroundAnimation(int id) {
        if (id < this.backgroundAnimations.size()) {
            this.backgroundAnimationId = id;
            this.lastBackgroundAnimation = this.backgroundAnimation = this.backgroundAnimations.get(id);
            return true;
        }
        return false;
    }

    public int getCurrentBackgroundAnimationId() {
        return this.backgroundAnimationId;
    }

    public List<IAnimationRenderer> backgroundAnimations() {
        return this.backgroundAnimations;
    }

    public boolean isVanillaButtonDelayed(AbstractWidget w) {
        for (ButtonData d : this.delayAppearanceVanilla.keySet()) {
            if (d.getButton() != w) continue;
            return true;
        }
        return false;
    }

    public boolean isVanillaButtonHidden(AbstractWidget w) {
        for (ButtonData d : this.hidden) {
            if (d.getButton() != w) continue;
            return true;
        }
        return false;
    }

    public static class SharedLayoutProperties {
        public boolean scaled = false;
        public int autoScaleBaseWidth = 0;
        public int autoScaleBaseHeight = 0;
        public boolean backgroundTextureSet = false;
        public boolean openAudioSet = false;
        public boolean closeAudioSet = false;
        public Map<ButtonData, String> descriptions = new HashMap<ButtonData, String>();
    }

    public static class RandomLayoutContainer {
        public final String id;
        protected List<PropertiesSet> layouts = new ArrayList<PropertiesSet>();
        protected boolean onlyFirstTime = false;
        protected String lastLayoutPath = null;
        public MenuHandlerBase parent;

        public RandomLayoutContainer(String id, MenuHandlerBase parent) {
            this.id = id;
            this.parent = parent;
        }

        public List<PropertiesSet> getLayouts() {
            return this.layouts;
        }

        public void addLayout(PropertiesSet layout) {
            this.layouts.add(layout);
        }

        public void addLayouts(List<PropertiesSet> layouts) {
            this.layouts.addAll(layouts);
        }

        public void clearLayouts() {
            this.layouts.clear();
        }

        public void setOnlyFirstTime(boolean b) {
            this.onlyFirstTime = b;
        }

        public boolean isOnlyFirstTime() {
            return this.onlyFirstTime;
        }

        public void resetLastLayout() {
            this.lastLayoutPath = null;
        }

        @Nullable
        public PropertiesSet getRandomLayout() {
            if (!this.layouts.isEmpty()) {
                String path;
                int i;
                PropertiesSet s;
                List metas;
                if ((this.onlyFirstTime || !MenuCustomization.isNewMenu()) && this.lastLayoutPath != null) {
                    File f = new File(this.lastLayoutPath);
                    if (f.exists()) {
                        for (PropertiesSet s2 : this.layouts) {
                            String path2;
                            List metas2 = s2.getPropertiesOfType("customization-meta");
                            if (metas2.isEmpty()) {
                                metas2 = s2.getPropertiesOfType("type-meta");
                            }
                            if (metas2.isEmpty() || (path2 = ((PropertiesSection)metas2.get(0)).getEntryValue("path")) == null || !path2.equals(this.lastLayoutPath)) continue;
                            return s2;
                        }
                    } else {
                        MenuCustomization.stopSounds();
                        MenuCustomization.resetSounds();
                        AnimationHandler.resetAnimations();
                        AnimationHandler.resetAnimationSounds();
                        AnimationHandler.stopAnimationSounds();
                    }
                }
                if ((metas = (s = this.layouts.get(i = MathUtils.getRandomNumberInRange((int)0, (int)(this.layouts.size() - 1)))).getPropertiesOfType("customization-meta")).isEmpty()) {
                    metas = s.getPropertiesOfType("type-meta");
                }
                if (!metas.isEmpty() && (path = ((PropertiesSection)metas.get(0)).getEntryValue("path")) != null) {
                    this.lastLayoutPath = path;
                    return s;
                }
            }
            return null;
        }
    }

    private static class ThreadCaller {
        AtomicBoolean running = new AtomicBoolean(true);

        private ThreadCaller() {
        }
    }

    public static class ButtonCustomizationContainer {
        public String normalBackground = null;
        public String hoverBackground = null;
        public boolean loopAnimation = true;
        public boolean restartAnimationOnHover = true;
        public String clickSound = null;
        public String hoverSound = null;
        public String hoverLabel = null;
        public int autoButtonClicks = 0;
        public String customButtonLabel = null;
        public String buttonDescription = null;
        public boolean isButtonHidden = false;
        public VisibilityRequirementContainer visibilityRequirementContainer = null;
        public List<IAnimationRenderer> cachedAnimations = new ArrayList<IAnimationRenderer>();
        public boolean lastHoverState = false;
    }
}

