/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.item.playerentity;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import de.keksuccino.fancymenu.menu.fancy.DynamicValueHelper;
import de.keksuccino.fancymenu.menu.fancy.item.CustomizationItemBase;
import de.keksuccino.fancymenu.menu.fancy.item.playerentity.DummyWorldFactory;
import de.keksuccino.fancymenu.menu.fancy.item.playerentity.PlayerEntityCache;
import de.keksuccino.fancymenu.menu.fancy.item.playerentity.SkinExternalTextureResourceLocation;
import de.keksuccino.fancymenu.menu.fancy.item.playerentity.SkinWebTextureResourceLocation;
import de.keksuccino.konkrete.input.MouseInput;
import de.keksuccino.konkrete.math.MathUtils;
import de.keksuccino.konkrete.properties.PropertiesSection;
import de.keksuccino.konkrete.resources.ExternalTextureResourceLocation;
import de.keksuccino.konkrete.resources.TextureHandler;
import de.keksuccino.konkrete.resources.WebTextureResourceLocation;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Scanner;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.ParrotModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.ParrotRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class PlayerEntityCustomizationItem
extends CustomizationItemBase {
    public MenuPlayerEntity entity;
    public int scale = 30;
    public String playerName = null;
    public boolean autoRotation = true;
    public float bodyRotationX = 0.0f;
    public float bodyRotationY = 0.0f;
    public float headRotationX = 0.0f;
    public float headRotationY = 0.0f;
    private static final Level DUMMY_WORLD = DummyWorldFactory.getDummyWorld();
    private static final ClientLevel DUMMY_CLIENT_WORLD = DummyWorldFactory.getDummyClientWorld();
    private static final BlockPos BLOCK_POS = new BlockPos(0, 0, 0);
    private static final MenuPlayerRenderer PLAYER_RENDERER = new MenuPlayerRenderer(new EntityRendererProvider.Context(Minecraft.m_91087_().m_91290_(), Minecraft.m_91087_().m_91291_(), Minecraft.m_91087_().m_91098_(), Minecraft.m_91087_().m_167973_(), Minecraft.m_91087_().f_91062_), false);
    private static final MenuPlayerRenderer SLIM_PLAYER_RENDERER = new MenuPlayerRenderer(new EntityRendererProvider.Context(Minecraft.m_91087_().m_91290_(), Minecraft.m_91087_().m_91291_(), Minecraft.m_91087_().m_91098_(), Minecraft.m_91087_().m_167973_(), Minecraft.m_91087_().f_91062_), true);

    public PlayerEntityCustomizationItem(PropertiesSection item) {
        super(item);
        String autoRot;
        String bodyrotY;
        String bodyrotX;
        String rotY;
        String rotX;
        String showName;
        String crouching;
        String parrot;
        String slim;
        ExternalTextureResourceLocation r;
        String cape;
        WebTextureResourceLocation wt;
        String capeUrl;
        ExternalTextureResourceLocation r2;
        String skin;
        WebTextureResourceLocation wt2;
        String scaleString = item.getEntryValue("scale");
        if (scaleString != null && MathUtils.isDouble((String)scaleString)) {
            this.scale = (int)Double.parseDouble(scaleString);
        }
        this.playerName = item.getEntryValue("playername");
        if (this.playerName != null) {
            this.playerName = DynamicValueHelper.convertFromRaw(this.playerName);
        }
        this.entity = new MenuPlayerEntity(this.playerName);
        String skinUrl = item.getEntryValue("skinurl");
        if (skinUrl != null && (wt2 = TextureHandler.getWebResource((String)(skinUrl = DynamicValueHelper.convertFromRaw(skinUrl)))) != null) {
            this.entity.skinLocation = wt2.getResourceLocation();
        }
        if ((skin = PlayerEntityCustomizationItem.fixBackslashPath(item.getEntryValue("skinpath"))) != null && this.entity.skinLocation == null && (r2 = TextureHandler.getResource((String)skin)) != null) {
            if (r2.getHeight() < 64) {
                String sha1;
                File f = new File(skin);
                if (f.isFile() && (f.getPath().toLowerCase().endsWith(".jpg") || f.getPath().toLowerCase().endsWith(".jpeg") || f.getPath().toLowerCase().endsWith(".png")) && (sha1 = PlayerEntityCache.calculateSHA1(f)) != null) {
                    if (!PlayerEntityCache.isSkinCached(sha1)) {
                        SkinExternalTextureResourceLocation sr = new SkinExternalTextureResourceLocation(skin);
                        sr.loadTexture();
                        PlayerEntityCache.cacheSkin(sha1, sr.getResourceLocation());
                        this.entity.skinLocation = sr.getResourceLocation();
                    } else {
                        this.entity.skinLocation = PlayerEntityCache.getSkin(sha1);
                    }
                }
            } else {
                this.entity.skinLocation = r2.getResourceLocation();
            }
        }
        if ((capeUrl = item.getEntryValue("capeurl")) != null && (wt = TextureHandler.getWebResource((String)(capeUrl = DynamicValueHelper.convertFromRaw(capeUrl)))) != null) {
            this.entity.capeLocation = wt.getResourceLocation();
        }
        if ((cape = PlayerEntityCustomizationItem.fixBackslashPath(item.getEntryValue("capepath"))) != null && this.entity.capeLocation == null && (r = TextureHandler.getResource((String)cape)) != null) {
            this.entity.capeLocation = r.getResourceLocation();
        }
        if ((slim = item.getEntryValue("slim")) != null && slim.replace(" ", "").equalsIgnoreCase("true")) {
            this.entity.setSlimSkin(true);
        }
        if ((parrot = item.getEntryValue("parrot")) != null && parrot.replace(" ", "").equalsIgnoreCase("true")) {
            this.entity.hasParrot = true;
        }
        if ((crouching = item.getEntryValue("crouching")) != null && crouching.replace(" ", "").equalsIgnoreCase("true")) {
            this.entity.crouching = true;
        }
        if ((showName = item.getEntryValue("showname")) != null && showName.replace(" ", "").equalsIgnoreCase("false")) {
            this.entity.showName = false;
        }
        if ((rotX = item.getEntryValue("headrotationx")) != null && MathUtils.isFloat((String)(rotX = rotX.replace(" ", "")))) {
            this.headRotationX = Float.parseFloat(rotX);
        }
        if ((rotY = item.getEntryValue("headrotationy")) != null && MathUtils.isFloat((String)(rotY = rotY.replace(" ", "")))) {
            this.headRotationY = Float.parseFloat(rotY);
        }
        if ((bodyrotX = item.getEntryValue("bodyrotationx")) != null && MathUtils.isFloat((String)(bodyrotX = bodyrotX.replace(" ", "")))) {
            this.bodyRotationX = Float.parseFloat(bodyrotX);
        }
        if ((bodyrotY = item.getEntryValue("bodyrotationy")) != null && MathUtils.isFloat((String)(bodyrotY = bodyrotY.replace(" ", "")))) {
            this.bodyRotationY = Float.parseFloat(bodyrotY);
        }
        if ((autoRot = item.getEntryValue("autorotation")) != null && autoRot.replace(" ", "").equalsIgnoreCase("false")) {
            this.autoRotation = false;
        }
        this.value = this.playerName != null ? this.playerName : "Player Entity";
        this.setWidth((int)(this.entity.m_20205_() * (float)this.scale));
        this.setHeight((int)(this.entity.m_20206_() * (float)this.scale));
    }

    @Override
    public void render(PoseStack matrix, Screen menu) throws IOException {
        try {
            if (this.shouldRender() && this.entity != null) {
                this.value = this.playerName != null ? this.playerName : "Player Entity";
                this.setWidth((int)(this.entity.m_20205_() * (float)this.scale));
                this.setHeight((int)(this.entity.m_20206_() * (float)this.scale));
                int mX = MouseInput.getMouseX();
                int mY = MouseInput.getMouseY();
                PlayerEntityCustomizationItem.renderPlayerEntity(this.getPosX(menu), this.getPosY(menu), this.scale, mX, mY, this);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void renderPlayerEntity(int posX, int posY, int scale, float mouseX, float mouseY, PlayerEntityCustomizationItem item) {
        float entityHeight = item.entity.m_20206_() * (float)item.scale;
        float rotationX = (float)Math.atan((mouseX - (float)item.getPosX(Minecraft.m_91087_().f_91080_)) / 40.0f);
        float rotationY = (float)Math.atan((mouseY - ((float)item.getPosY(Minecraft.m_91087_().f_91080_) - entityHeight / 2.0f)) / 40.0f);
        PoseStack matrix = RenderSystem.m_157191_();
        matrix.m_85836_();
        matrix.m_85837_((double)posX, (double)posY, 1050.0);
        matrix.m_85841_(1.0f, 1.0f, -1.0f);
        RenderSystem.m_157182_();
        PoseStack matrixIntern = new PoseStack();
        matrixIntern.m_85837_(0.0, 0.0, 1000.0);
        matrixIntern.m_85841_((float)scale, (float)scale, (float)scale);
        if (!item.autoRotation) {
            q = Vector3f.f_122227_.m_122240_(180.0f);
            Quaternion q2 = Vector3f.f_122223_.m_122240_(item.bodyRotationY);
            q.m_80148_(q2);
            matrixIntern.m_85845_(q);
            item.entity.f_20883_ = item.bodyRotationX;
            item.entity.m_5616_(item.headRotationY);
            item.entity.f_20885_ = item.headRotationX;
        } else {
            q = Vector3f.f_122227_.m_122240_(180.0f);
            Quaternion q2 = Vector3f.f_122223_.m_122240_((float)Math.negateExact((long)(rotationY * 20.0f)));
            q.m_80148_(q2);
            matrixIntern.m_85845_(q);
            item.entity.f_20883_ = Math.negateExact((long)(180.0f + rotationX * 20.0f));
            item.entity.m_5616_(Math.negateExact((long)(-rotationY * 20.0f)));
            item.entity.f_20885_ = Math.negateExact((long)(180.0f + rotationX * 40.0f));
        }
        MultiBufferSource.BufferSource rb = Minecraft.m_91087_().m_91269_().m_110104_();
        RenderSystem.m_69890_(() -> item.renderEntityStatic(0.0, 0.0, 0.0, 0.0f, 1.0f, matrixIntern, (MultiBufferSource)rb, 0xF000F0));
        rb.m_109911_();
        matrix.m_85849_();
        RenderSystem.m_157182_();
    }

    public void renderEntityStatic(double xIn, double yIn, double zIn, float rotationYawIn, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        try {
            Vec3 vector3d = this.entity.isSlimSkin() ? SLIM_PLAYER_RENDERER.getRenderOffset(this.entity, partialTicks) : PLAYER_RENDERER.getRenderOffset(this.entity, partialTicks);
            double d2 = xIn + vector3d.m_7096_();
            double d3 = yIn + vector3d.m_7098_();
            double d0 = zIn + vector3d.m_7094_();
            matrixStackIn.m_85836_();
            matrixStackIn.m_85837_(d2, d3, d0);
            if (this.entity.isSlimSkin()) {
                SLIM_PLAYER_RENDERER.render(this.entity, rotationYawIn, partialTicks, matrixStackIn, bufferIn, packedLightIn);
            } else {
                PLAYER_RENDERER.render(this.entity, rotationYawIn, partialTicks, matrixStackIn, bufferIn, packedLightIn);
            }
            matrixStackIn.m_85837_(-vector3d.m_7096_(), -vector3d.m_7098_(), -vector3d.m_7094_());
            matrixStackIn.m_85849_();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String getSkinURL(String playerName) {
        String skinUrl = null;
        try {
            URL url = new URL("https://api.ashcon.app/mojang/v2/user/" + playerName);
            Scanner scanner = new Scanner(new InputStreamReader(url.openStream()));
            boolean b = false;
            boolean b2 = false;
            while (scanner.hasNextLine()) {
                String line = scanner.next();
                if (b) {
                    skinUrl = line.substring(1, line.length() - 2);
                    break;
                }
                if (line.contains("\"skin\":")) {
                    b2 = true;
                }
                if (line.contains("\"code\":")) break;
                if (!line.contains("\"url\":") || !b2) continue;
                b = true;
            }
            scanner.close();
        }
        catch (IOException url) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return skinUrl;
    }

    private static String getCapeURL(String playerName) {
        String capeUrl = null;
        try {
            URL url = new URL("https://api.ashcon.app/mojang/v2/user/" + playerName);
            Scanner scanner = new Scanner(new InputStreamReader(url.openStream()));
            boolean b = false;
            boolean b2 = false;
            while (scanner.hasNextLine()) {
                String line = scanner.next();
                if (b) {
                    capeUrl = line.substring(1, line.length() - 2);
                    break;
                }
                if (line.contains("\"cape\":")) {
                    b2 = true;
                }
                if (line.contains("\"code\":")) break;
                if (!line.contains("\"url\":") || !b2) continue;
                b = true;
            }
            scanner.close();
        }
        catch (IOException url) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return capeUrl;
    }

    private static boolean getIsSlimSkin(String playerName) {
        boolean slim = false;
        try {
            URL url = new URL("https://api.ashcon.app/mojang/v2/user/" + playerName);
            Scanner scanner = new Scanner(new InputStreamReader(url.openStream()));
            boolean b = false;
            boolean b2 = false;
            while (scanner.hasNextLine()) {
                String line = scanner.next();
                if (b) {
                    String slimString = line.substring(1, line.length() - 2);
                    if (!slimString.equalsIgnoreCase("true")) break;
                    slim = true;
                    break;
                }
                if (line.contains("\"textures\":")) {
                    b2 = true;
                }
                if (line.contains("\"code\":")) break;
                if (!line.contains("\"slim\":") || !b2) continue;
                b = true;
            }
            scanner.close();
        }
        catch (IOException url) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return slim;
    }

    public static class MenuPlayerEntity
    extends AbstractClientPlayer {
        public volatile ResourceLocation skinLocation;
        public volatile ResourceLocation capeLocation;
        private volatile boolean capeChecked = false;
        private volatile boolean capeGettingChecked = false;
        private volatile boolean skinChecked = false;
        private volatile boolean skinGettingChecked = false;
        private volatile boolean slimSkin = false;
        private volatile boolean slimSkinChecked = false;
        private volatile boolean slimSkinGettingChecked = false;
        public boolean hasParrot = false;
        public boolean crouching = false;
        public boolean showName = true;
        public volatile String playerName;
        private volatile Runnable getSkinCallback;
        private volatile Runnable getCapeCallback;

        public MenuPlayerEntity(String playerName) {
            super(DUMMY_CLIENT_WORLD, new GameProfile(Player.m_36283_((String)MenuPlayerEntity.getRawPlayerName(playerName)), MenuPlayerEntity.getRawPlayerName(playerName)));
            if (playerName != null) {
                this.playerName = playerName;
            }
        }

        private static String getRawPlayerName(String playerName) {
            if (playerName == null) {
                return "steve";
            }
            return playerName;
        }

        public Vec3 m_20182_() {
            return new Vec3(-100000.0, -100000.0, -100000.0);
        }

        public double m_20280_(Entity p_20281_) {
            return 0.0;
        }

        public boolean m_5833_() {
            return false;
        }

        public boolean m_7500_() {
            return false;
        }

        public boolean m_6047_() {
            return this.crouching;
        }

        public Component m_5446_() {
            if (this.playerName != null) {
                return new TextComponent(this.playerName);
            }
            return null;
        }

        public void setSlimSkin(boolean slim) {
            this.slimSkin = slim;
            this.slimSkinChecked = true;
        }

        public boolean isSlimSkin() {
            if (this.playerName != null && !this.slimSkinChecked) {
                if (!PlayerEntityCache.isSlimSkinInfoCached(this.playerName)) {
                    if (!this.slimSkinGettingChecked) {
                        this.slimSkinGettingChecked = true;
                        new Thread(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    boolean b = PlayerEntityCustomizationItem.getIsSlimSkin(playerName);
                                    if (!slimSkinChecked) {
                                        slimSkin = b;
                                        PlayerEntityCache.cacheIsSlimSkin(playerName, b);
                                    }
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                                slimSkinChecked = true;
                                slimSkinGettingChecked = false;
                            }
                        }).start();
                    }
                } else {
                    this.slimSkin = PlayerEntityCache.getIsSlimSkin(this.playerName);
                    this.slimSkinChecked = true;
                }
            }
            return this.slimSkin;
        }

        public boolean hasNonDefaultSkin() {
            return this.skinLocation != DefaultPlayerSkin.m_118626_();
        }

        public boolean hasCape() {
            return this.getCape() != null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public ResourceLocation getSkin() {
            if (this.getSkinCallback != null) {
                this.getSkinCallback.run();
                this.getSkinCallback = null;
            }
            if (this.playerName != null) {
                if (this.skinLocation != null) return this.skinLocation;
                if (!this.skinChecked) {
                    if (!PlayerEntityCache.isSkinCached(this.playerName)) {
                        if (this.skinGettingChecked) return DefaultPlayerSkin.m_118626_();
                        this.skinGettingChecked = true;
                        new Thread(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    final String skinUrl = PlayerEntityCustomizationItem.getSkinURL(playerName);
                                    if (skinLocation == null) {
                                        if (skinUrl == null) {
                                            skinLocation = DefaultPlayerSkin.m_118626_();
                                            slimSkin = false;
                                            slimSkinChecked = true;
                                        } else if (getSkinCallback == null) {
                                            getSkinCallback = new Runnable(){

                                                @Override
                                                public void run() {
                                                    WebTextureResourceLocation wt = TextureHandler.getWebResource((String)skinUrl);
                                                    if (skinLocation == null) {
                                                        if (wt != null) {
                                                            if (wt.getHeight() < 64) {
                                                                wt = new SkinWebTextureResourceLocation(skinUrl);
                                                                wt.loadTexture();
                                                            }
                                                            skinLocation = wt.getResourceLocation();
                                                            PlayerEntityCache.cacheSkin(playerName, wt.getResourceLocation());
                                                        } else {
                                                            skinLocation = DefaultPlayerSkin.m_118626_();
                                                            slimSkin = false;
                                                            slimSkinChecked = true;
                                                        }
                                                    }
                                                }
                                            };
                                        }
                                    }
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                                skinChecked = true;
                                skinGettingChecked = false;
                            }
                        }).start();
                        return this.skinLocation;
                    } else {
                        this.skinLocation = PlayerEntityCache.getSkin(this.playerName);
                        this.skinChecked = true;
                    }
                    return this.skinLocation;
                } else {
                    this.skinLocation = DefaultPlayerSkin.m_118626_();
                    this.slimSkin = false;
                    this.slimSkinChecked = true;
                }
                return this.skinLocation;
            } else {
                if (this.skinLocation != null) return this.skinLocation;
                this.skinLocation = DefaultPlayerSkin.m_118626_();
                this.slimSkin = false;
                this.slimSkinChecked = true;
            }
            return this.skinLocation;
        }

        public ResourceLocation getCape() {
            if (this.getCapeCallback != null) {
                this.getCapeCallback.run();
                this.getCapeCallback = null;
            }
            if (this.playerName != null && this.capeLocation == null && !this.capeChecked) {
                if (!PlayerEntityCache.isCapeCached(this.playerName)) {
                    if (!this.capeGettingChecked) {
                        this.capeGettingChecked = true;
                        new Thread(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    final String capeUrl = PlayerEntityCustomizationItem.getCapeURL(playerName);
                                    if (!capeChecked && capeUrl != null && getCapeCallback == null) {
                                        getCapeCallback = new Runnable(){

                                            @Override
                                            public void run() {
                                                WebTextureResourceLocation wt = TextureHandler.getWebResource((String)capeUrl);
                                                if (wt != null) {
                                                    capeLocation = wt.getResourceLocation();
                                                    PlayerEntityCache.cacheCape(playerName, wt.getResourceLocation());
                                                }
                                            }
                                        };
                                    }
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                                capeGettingChecked = false;
                                capeChecked = true;
                            }
                        }).start();
                    }
                } else {
                    this.capeLocation = PlayerEntityCache.getCape(this.playerName);
                    this.capeChecked = true;
                }
            }
            return this.capeLocation;
        }
    }

    public static class MenuPlayerRenderer
    extends LivingEntityRenderer<MenuPlayerEntity, PlayerModel<MenuPlayerEntity>> {
        public MenuPlayerRenderer(EntityRendererProvider.Context ctx, boolean slim) {
            super(ctx, (EntityModel)new PlayerModel(ctx.m_174023_(slim ? ModelLayers.f_171166_ : ModelLayers.f_171162_), slim), 0.5f);
            this.m_115326_((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, new HumanoidModel(ctx.m_174023_(slim ? ModelLayers.f_171167_ : ModelLayers.f_171164_)), new HumanoidModel(ctx.m_174023_(slim ? ModelLayers.f_171168_ : ModelLayers.f_171165_))));
            this.m_115326_(new MenuPlayerCapeLayer((RenderLayerParent<MenuPlayerEntity, PlayerModel<MenuPlayerEntity>>)this));
            this.m_115326_((RenderLayer)new CustomHeadLayer((RenderLayerParent)this, ctx.m_174027_()));
            this.m_115326_(new MenuPlayerParrotLayer(ctx, (RenderLayerParent<MenuPlayerEntity, PlayerModel<MenuPlayerEntity>>)this));
        }

        public void render(MenuPlayerEntity entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
            this.setModelVisibilities(entityIn);
            super.m_7392_((LivingEntity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        }

        public Vec3 getRenderOffset(MenuPlayerEntity entityIn, float partialTicks) {
            return entityIn.m_6047_() ? new Vec3(0.0, -0.125, 0.0) : super.m_7860_((Entity)entityIn, partialTicks);
        }

        private void setModelVisibilities(MenuPlayerEntity clientPlayer) {
            PlayerModel playermodel = (PlayerModel)this.m_7200_();
            playermodel.m_8009_(true);
            playermodel.f_102809_.f_104207_ = true;
            playermodel.f_103378_.f_104207_ = true;
            playermodel.f_103376_.f_104207_ = true;
            playermodel.f_103377_.f_104207_ = true;
            playermodel.f_103374_.f_104207_ = true;
            playermodel.f_103375_.f_104207_ = true;
            playermodel.f_102817_ = clientPlayer.m_6047_();
        }

        public ResourceLocation getTextureLocation(MenuPlayerEntity entity) {
            ResourceLocation l = entity.getSkin();
            if (l != null) {
                return l;
            }
            return DefaultPlayerSkin.m_118626_();
        }

        protected boolean shouldShowName(MenuPlayerEntity entity) {
            return entity.showName && entity.m_5446_() != null;
        }

        protected void renderNameTag(MenuPlayerEntity playerEntity, Component displayNameIn, PoseStack matrix, MultiBufferSource bufferIn, int packedLightIn) {
            if (playerEntity.showName) {
                boolean flag = !playerEntity.m_20163_();
                float f = playerEntity.m_20206_() + 0.5f;
                matrix.m_85836_();
                matrix.m_85837_(0.0, (double)f, 0.0);
                matrix.m_85845_(new Quaternion(0.0f, 0.0f, 0.0f, 0.0f));
                matrix.m_85841_(-0.025f, -0.025f, 0.025f);
                Matrix4f matrix4f = matrix.m_85850_().m_85861_();
                float f1 = Minecraft.m_91087_().f_91066_.m_92141_(0.25f);
                int j = (int)(f1 * 255.0f) << 24;
                Font fontrenderer = this.m_114481_();
                float f2 = -fontrenderer.m_92852_((FormattedText)displayNameIn) / 2;
                fontrenderer.m_92841_(displayNameIn, f2, 0.0f, 0x20FFFFFF, false, matrix4f, bufferIn, flag, j, packedLightIn);
                if (flag) {
                    fontrenderer.m_92841_(displayNameIn, f2, 0.0f, -1, false, matrix4f, bufferIn, false, 0, packedLightIn);
                }
                matrix.m_85849_();
            }
        }

        protected void scale(MenuPlayerEntity entitylivingbaseIn, PoseStack matrixStackIn, float partialTickTime) {
            matrixStackIn.m_85841_(0.9375f, 0.9375f, 0.9375f);
        }

        protected void setupRotations(MenuPlayerEntity entityLiving, PoseStack matrixStackIn, float ageInTicks, float rotationYaw, float partialTicks) {
            float f = entityLiving.m_20998_(partialTicks);
            if (entityLiving.m_21255_()) {
                super.m_7523_((LivingEntity)entityLiving, matrixStackIn, ageInTicks, rotationYaw, partialTicks);
                float f1 = (float)entityLiving.m_21256_() + partialTicks;
                float f2 = Mth.m_14036_((float)(f1 * f1 / 100.0f), (float)0.0f, (float)1.0f);
                if (!entityLiving.m_21209_()) {
                    matrixStackIn.m_85845_(Vector3f.f_122223_.m_122240_(f2 * (-90.0f - entityLiving.m_146909_())));
                }
                Vec3 vector3d = entityLiving.m_20252_(partialTicks);
                Vec3 vector3d1 = entityLiving.m_20184_();
                double d0 = vector3d1.m_165925_();
                double d1 = vector3d.m_165925_();
                if (d0 > 0.0 && d1 > 0.0) {
                    double d2 = (vector3d1.f_82479_ * vector3d.f_82479_ + vector3d1.f_82481_ * vector3d.f_82481_) / Math.sqrt(d0 * d1);
                    double d3 = vector3d1.f_82479_ * vector3d.f_82481_ - vector3d1.f_82481_ * vector3d.f_82479_;
                    matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_((float)(Math.signum(d3) * Math.acos(d2))));
                }
            } else if (f > 0.0f) {
                super.m_7523_((LivingEntity)entityLiving, matrixStackIn, ageInTicks, rotationYaw, partialTicks);
                float f3 = entityLiving.m_20069_() ? -90.0f - entityLiving.m_146909_() : -90.0f;
                float f4 = Mth.m_14179_((float)f, (float)0.0f, (float)f3);
                matrixStackIn.m_85845_(Vector3f.f_122223_.m_122240_(f4));
                if (entityLiving.m_6067_()) {
                    matrixStackIn.m_85837_(0.0, -1.0, (double)0.3f);
                }
            } else {
                super.m_7523_((LivingEntity)entityLiving, matrixStackIn, ageInTicks, rotationYaw, partialTicks);
            }
        }
    }

    public static class MenuPlayerParrotLayer
    extends RenderLayer<MenuPlayerEntity, PlayerModel<MenuPlayerEntity>> {
        private final ParrotModel parrotModel;

        public MenuPlayerParrotLayer(EntityRendererProvider.Context context, RenderLayerParent<MenuPlayerEntity, PlayerModel<MenuPlayerEntity>> entityRendererIn) {
            super(entityRendererIn);
            this.parrotModel = new ParrotModel(context.m_174023_(ModelLayers.f_171203_));
        }

        public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, MenuPlayerEntity playerEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            if (playerEntity.hasParrot) {
                this.renderParrot(matrixStackIn, bufferIn, packedLightIn, playerEntity, limbSwing, limbSwingAmount, netHeadYaw, headPitch, 0);
            }
        }

        private void renderParrot(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, MenuPlayerEntity playerEntity, float limbSwing, float limbSwingAmount, float netHeadYaw, float headPitch, int parrotVariant) {
            matrixStackIn.m_85836_();
            matrixStackIn.m_85837_((double)-0.4f, playerEntity.m_6047_() ? (double)-1.3f : -1.5, 0.0);
            VertexConsumer vc = bufferIn.m_6299_(this.parrotModel.m_103119_(ParrotRenderer.f_115648_[parrotVariant]));
            this.parrotModel.m_103223_(matrixStackIn, vc, packedLightIn, OverlayTexture.f_118083_, limbSwing, limbSwingAmount, netHeadYaw, headPitch, playerEntity.f_19797_);
            matrixStackIn.m_85849_();
        }
    }

    public static class MenuPlayerCapeLayer
    extends RenderLayer<MenuPlayerEntity, PlayerModel<MenuPlayerEntity>> {
        public MenuPlayerCapeLayer(RenderLayerParent<MenuPlayerEntity, PlayerModel<MenuPlayerEntity>> entityRendererIn) {
            super(entityRendererIn);
        }

        public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, MenuPlayerEntity playerEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            if (playerEntity.hasCape()) {
                matrixStackIn.m_85836_();
                matrixStackIn.m_85837_(0.0, 0.0, 0.125);
                double d0 = Mth.m_14139_((double)partialTicks, (double)playerEntity.f_36102_, (double)playerEntity.f_36105_) - Mth.m_14139_((double)partialTicks, (double)playerEntity.f_19854_, (double)playerEntity.m_20185_());
                double d1 = Mth.m_14139_((double)partialTicks, (double)playerEntity.f_36103_, (double)playerEntity.f_36106_) - Mth.m_14139_((double)partialTicks, (double)playerEntity.f_19855_, (double)playerEntity.m_20186_());
                double d2 = Mth.m_14139_((double)partialTicks, (double)playerEntity.f_36104_, (double)playerEntity.f_36075_) - Mth.m_14139_((double)partialTicks, (double)playerEntity.f_19856_, (double)playerEntity.m_20189_());
                float f = playerEntity.f_20884_ + (playerEntity.f_20883_ - playerEntity.f_20884_);
                double d3 = Mth.m_14031_((float)(f * ((float)Math.PI / 180)));
                double d4 = -Mth.m_14089_((float)(f * ((float)Math.PI / 180)));
                float f1 = (float)d1 * 10.0f;
                f1 = Mth.m_14036_((float)f1, (float)-6.0f, (float)32.0f);
                float f2 = (float)(d0 * d3 + d2 * d4) * 100.0f;
                f2 = Mth.m_14036_((float)f2, (float)0.0f, (float)150.0f);
                float f4 = Mth.m_14179_((float)partialTicks, (float)playerEntity.f_36099_, (float)playerEntity.f_36100_);
                f1 += Mth.m_14031_((float)(Mth.m_14179_((float)partialTicks, (float)playerEntity.f_19867_, (float)playerEntity.f_19787_) * 6.0f)) * 32.0f * f4;
                if (playerEntity.m_6047_()) {
                    f1 += 25.0f;
                }
                matrixStackIn.m_85845_(Vector3f.f_122223_.m_122240_(6.0f + f2 / 2.0f + f1));
                matrixStackIn.m_85845_(Vector3f.f_122227_.m_122240_(0.0f));
                matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
                VertexConsumer ivertexbuilder = bufferIn.m_6299_(RenderType.m_110446_((ResourceLocation)playerEntity.getCape()));
                ((PlayerModel)this.m_117386_()).m_103411_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.f_118083_);
                matrixStackIn.m_85849_();
            }
        }
    }
}

