/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.item;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import de.keksuccino.fancymenu.menu.fancy.DynamicValueHelper;
import de.keksuccino.fancymenu.menu.fancy.helper.MenuReloadedEvent;
import de.keksuccino.fancymenu.menu.fancy.item.CustomizationItemBase;
import de.keksuccino.konkrete.file.FileUtils;
import de.keksuccino.konkrete.input.StringUtils;
import de.keksuccino.konkrete.math.MathUtils;
import de.keksuccino.konkrete.properties.PropertiesSection;
import de.keksuccino.konkrete.rendering.RenderUtils;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.util.Mth;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class SplashTextCustomizationItem
extends CustomizationItemBase {
    protected static Map<String, String> splashCache = new HashMap<String, String>();
    protected static boolean init = false;
    public float scale = 1.0f;
    public boolean shadow = true;
    public boolean bounce = true;
    public float rotation = 20.0f;
    public Color basecolor = new Color(255, 255, 0);
    public String basecolorString = "#ffff00";
    public boolean refreshOnMenuReload = false;
    public File splashfile;
    public String text = null;
    protected float basescale = 1.8f;
    protected static boolean isNewMenu = false;
    protected boolean isNewMenuThis = false;
    protected static Screen lastScreen = null;

    public SplashTextCustomizationItem(PropertiesSection item) {
        super(item);
        if (!init) {
            MinecraftForge.EVENT_BUS.register(SplashTextCustomizationItem.class);
            init = true;
        }
        if (this.action != null && this.action.equalsIgnoreCase("addsplash")) {
            String b;
            String sc;
            String sh;
            Color c;
            String co;
            String re;
            String filepath = SplashTextCustomizationItem.fixBackslashPath(item.getEntryValue("splashfilepath"));
            if (filepath != null) {
                this.splashfile = new File(filepath);
                if (!this.splashfile.exists() || !this.splashfile.getPath().toLowerCase().endsWith(".txt")) {
                    this.splashfile = null;
                }
            }
            this.text = item.getEntryValue("text");
            String ro = item.getEntryValue("rotation");
            if (ro != null && MathUtils.isFloat((String)ro)) {
                this.rotation = Float.parseFloat(ro);
            }
            if ((re = item.getEntryValue("refresh")) != null && re.equalsIgnoreCase("true")) {
                this.refreshOnMenuReload = true;
            }
            if ((co = item.getEntryValue("basecolor")) != null && (c = RenderUtils.getColorFromHexString((String)co)) != null) {
                this.basecolor = c;
                this.basecolorString = co;
            }
            if ((sh = item.getEntryValue("shadow")) != null && sh.equalsIgnoreCase("false")) {
                this.shadow = false;
            }
            if ((sc = item.getEntryValue("scale")) != null && MathUtils.isFloat((String)sc)) {
                this.scale = Float.parseFloat(sc);
            }
            if ((b = item.getEntryValue("bouncing")) != null && b.equalsIgnoreCase("false")) {
                this.bounce = false;
            }
            this.value = "splash text";
            this.setWidth((int)(30.0f * this.basescale * this.scale));
            this.setHeight((int)(10.0f * this.basescale * this.scale));
        }
    }

    @Override
    public void render(PoseStack matrix, Screen menu) throws IOException {
        if (this.isNewMenuThis) {
            isNewMenu = false;
        }
        this.isNewMenuThis = isNewMenu;
        this.setWidth((int)(30.0f * this.basescale * this.scale));
        this.setHeight((int)(10.0f * this.basescale * this.scale));
        if (this.shouldRender()) {
            this.renderSplash(matrix, Minecraft.m_91087_().f_91062_, menu);
        }
    }

    protected void renderSplash(PoseStack matrix, Font font, Screen s) {
        String splash = null;
        if (this.splashfile != null && this.text == null) {
            List l;
            if (isNewMenu && this.refreshOnMenuReload) {
                splashCache.remove(this.getActionId());
            }
            if (!splashCache.containsKey(this.getActionId()) && !(l = FileUtils.getFileLines((File)this.splashfile)).isEmpty()) {
                int i = MathUtils.getRandomNumberInRange((int)0, (int)(l.size() - 1));
                splashCache.put(this.getActionId(), (String)l.get(i));
            }
            if (splashCache.containsKey(this.getActionId())) {
                splash = splashCache.get(this.getActionId());
            }
        }
        if (this.text != null) {
            splash = this.text;
        }
        if (splash != null) {
            if (this.value != null) {
                splash = !SplashTextCustomizationItem.isEditorActive() ? DynamicValueHelper.convertFromRaw(splash) : StringUtils.convertFormatCodes((String)splash, (String)"&", (String)"\u00a7");
            }
            this.value = splash;
            float f = this.basescale;
            if (this.bounce) {
                f -= Mth.m_14154_((float)(Mth.m_14031_((float)((float)(System.currentTimeMillis() % 1000L) / 1000.0f * ((float)Math.PI * 2))) * 0.1f));
            }
            f = f * 100.0f / (float)(font.m_92895_(splash) + 32);
            RenderSystem.m_69478_();
            matrix.m_85836_();
            matrix.m_85841_(this.scale, this.scale, this.scale);
            matrix.m_85836_();
            matrix.m_85837_((double)((float)(this.getPosX(s) + this.width / 2) / this.scale), (double)((float)this.getPosY(s) / this.scale), 0.0);
            matrix.m_85845_(Vector3f.f_122227_.m_122240_(this.rotation));
            matrix.m_85841_(f, f, f);
            int alpha = this.basecolor.getAlpha();
            int i = Mth.m_14167_((float)(this.opacity * 255.0f));
            if (i < alpha) {
                alpha = i;
            }
            Color c = new Color(this.basecolor.getRed(), this.basecolor.getGreen(), this.basecolor.getBlue(), alpha);
            if (this.shadow) {
                font.m_92750_(matrix, splash, (float)(-(font.m_92895_(splash) / 2)), 0.0f, c.getRGB());
            } else {
                font.m_92883_(matrix, splash, (float)(-(font.m_92895_(splash) / 2)), 0.0f, c.getRGB());
            }
            matrix.m_85849_();
            matrix.m_85849_();
        }
    }

    @SubscribeEvent
    public static void onInitScreenPre(ScreenEvent.InitScreenEvent.Pre e) {
        Screen s = Minecraft.m_91087_().f_91080_;
        if (!(s == null || lastScreen != null && lastScreen.getClass().getName().equals(s.getClass().getName()))) {
            isNewMenu = true;
        }
        lastScreen = s;
    }

    @SubscribeEvent
    public static void onMenuReloaded(MenuReloadedEvent e) {
        splashCache.clear();
    }
}

