/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy;

import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.events.RenderGuiListBackgroundEvent;
import de.keksuccino.fancymenu.events.SoftMenuReloadEvent;
import de.keksuccino.fancymenu.mainwindow.MainWindowHandler;
import de.keksuccino.fancymenu.menu.button.ButtonCache;
import de.keksuccino.fancymenu.menu.button.ButtonMimeHandler;
import de.keksuccino.fancymenu.menu.fancy.MenuCustomization;
import de.keksuccino.fancymenu.menu.fancy.helper.MenuReloadedEvent;
import de.keksuccino.fancymenu.menu.fancy.helper.layoutcreator.LayoutEditorScreen;
import java.io.File;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MenuCustomizationEvents {
    private static final Logger LOGGER = LogManager.getLogger((String)"fancymenu/MenuCustomizationEvents");
    private boolean idle = false;
    private boolean iconSetAfterFullscreen = false;
    private boolean scaleChecked = false;
    private boolean resumeWorldMusic = false;
    protected Screen lastScreen = null;

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onInitPrePre(ScreenEvent.InitScreenEvent.Pre e) {
        if (!ButtonCache.isCaching() && MenuCustomization.isValidScreen(e.getScreen())) {
            Screen current = Minecraft.m_91087_().f_91080_;
            MenuCustomization.isNewMenu = current != null ? (this.lastScreen != null ? !this.lastScreen.getClass().getName().equals(current.getClass().getName()) : true) : true;
            this.lastScreen = current;
            if (MenuCustomization.isNewMenu) {
                ButtonMimeHandler.clearCache();
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onMenuReloaded(MenuReloadedEvent e) {
        ButtonMimeHandler.clearCache();
        MenuCustomization.isNewMenu = true;
        this.lastScreen = null;
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onSoftReload(SoftMenuReloadEvent e) {
        ButtonMimeHandler.clearCache();
        MenuCustomization.isNewMenu = true;
        this.lastScreen = null;
    }

    @SubscribeEvent
    public void onInitPre(ScreenEvent.InitScreenEvent.Pre e) {
        MenuCustomization.isCurrentScrollable = false;
        if (MenuCustomization.isValidScreen(e.getScreen()) && !LayoutEditorScreen.isActive) {
            this.idle = false;
        }
        if (MenuCustomization.isValidScreen(e.getScreen()) && !MenuCustomization.isMenuCustomizable(e.getScreen()) && !(e.getScreen() instanceof LayoutEditorScreen)) {
            MenuCustomization.stopSounds();
            MenuCustomization.resetSounds();
        }
        if (Minecraft.m_91087_().f_91073_ == null && !((Boolean)FancyMenu.config.getOrDefault("playmenumusic", (Object)true)).booleanValue()) {
            Minecraft.m_91087_().m_91397_().m_120186_();
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent e) {
        if (Minecraft.m_91087_().f_91080_ == null && !this.idle) {
            MenuCustomization.stopSounds();
            MenuCustomization.resetSounds();
            this.idle = true;
        }
        if (Minecraft.m_91087_().f_91073_ != null && Minecraft.m_91087_().f_91080_ == null && this.resumeWorldMusic) {
            Minecraft.m_91087_().m_91106_().m_120407_();
            this.resumeWorldMusic = false;
        }
        if (Minecraft.m_91087_().m_91268_().m_85440_()) {
            this.iconSetAfterFullscreen = false;
        } else if (!this.iconSetAfterFullscreen) {
            MainWindowHandler.updateWindowIcon();
            this.iconSetAfterFullscreen = true;
        }
        if (!this.scaleChecked && Minecraft.m_91087_().f_91066_ != null) {
            this.scaleChecked = true;
            int scale = (Integer)FancyMenu.config.getOrDefault("defaultguiscale", (Object)-1);
            if (scale != -1) {
                File f2;
                File f = new File("mods/fancymenu");
                if (!f.exists()) {
                    f.mkdirs();
                }
                if (!(f2 = new File(f.getPath() + "/defaultscaleset.fancymenu")).exists()) {
                    try {
                        f2.createNewFile();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                    Minecraft.m_91087_().f_91066_.f_92072_ = scale;
                    Minecraft.m_91087_().f_91066_.m_92169_();
                    Minecraft.m_91087_().m_5741_();
                }
            }
        }
        if (Minecraft.m_91087_().f_91080_ == null) {
            MenuCustomization.isCurrentScrollable = false;
        }
    }

    @SubscribeEvent
    public void onRenderListBackground(RenderGuiListBackgroundEvent.Pre e) {
        MenuCustomization.isCurrentScrollable = true;
    }
}

