/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.api.item;

import com.mojang.blaze3d.vertex.PoseStack;
import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.api.item.CustomizationItem;
import de.keksuccino.fancymenu.api.item.CustomizationItemContainer;
import de.keksuccino.fancymenu.menu.fancy.helper.layoutcreator.LayoutEditorScreen;
import de.keksuccino.fancymenu.menu.fancy.helper.layoutcreator.content.LayoutElement;
import de.keksuccino.konkrete.properties.PropertiesSection;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public abstract class LayoutEditorElement
extends LayoutElement {
    public final CustomizationItemContainer parentItemContainer;

    public LayoutEditorElement(@Nonnull CustomizationItemContainer parentContainer, @Nonnull CustomizationItem customizationItemInstance, boolean destroyable, @Nonnull LayoutEditorScreen handler, boolean doInit) {
        super(customizationItemInstance, destroyable, handler, doInit);
        this.parentItemContainer = parentContainer;
    }

    public LayoutEditorElement(@Nonnull CustomizationItemContainer parentContainer, @Nonnull CustomizationItem customizationItemInstance, boolean destroyable, @Nonnull LayoutEditorScreen handler) {
        super(customizationItemInstance, destroyable, handler);
        this.parentItemContainer = parentContainer;
    }

    @Override
    public void init() {
        super.init();
    }

    @Override
    public void render(PoseStack matrix, int mouseX, int mouseY) {
        super.render(matrix, mouseX, mouseY);
    }

    public abstract SimplePropertiesSection serializeItem();

    @Override
    public List<PropertiesSection> getProperties() {
        ArrayList<PropertiesSection> l = new ArrayList<PropertiesSection>();
        SimplePropertiesSection sec = this.serializeItem();
        if (sec == null) {
            sec = new SimplePropertiesSection();
        }
        if (sec.hasEntry("action")) {
            FancyMenu.LOGGER.warn("[FANCYMENU] WARNING! Entry key 'action' for serialized customization item instances is reserved by the system. Overriding entry!");
            sec.removeEntry("action");
        }
        sec.addEntry("action", "custom_layout_element:" + this.parentItemContainer.getIdentifier());
        sec.addEntry("actionid", this.object.getActionId());
        if (this.object.delayAppearance) {
            sec.addEntry("delayappearance", "true");
            sec.addEntry("delayappearanceeverytime", "" + this.object.delayAppearanceEverytime);
            sec.addEntry("delayappearanceseconds", "" + this.object.delayAppearanceSec);
            if (this.object.fadeIn) {
                sec.addEntry("fadein", "true");
                sec.addEntry("fadeinspeed", "" + this.object.fadeInSpeed);
            }
        }
        sec.addEntry("x", "" + this.object.posX);
        sec.addEntry("y", "" + this.object.posY);
        sec.addEntry("orientation", this.object.orientation);
        if (this.object.orientation.equals("element") && this.object.orientationElementIdentifier != null) {
            sec.addEntry("orientation_element", this.object.orientationElementIdentifier);
        }
        if (this.stretchX) {
            sec.addEntry("x", "0");
            sec.addEntry("width", "%guiwidth%");
        } else {
            sec.addEntry("x", "" + this.object.posX);
            sec.addEntry("width", "" + this.object.getWidth());
        }
        if (this.stretchY) {
            sec.addEntry("y", "0");
            sec.addEntry("height", "%guiheight%");
        } else {
            sec.addEntry("y", "" + this.object.posY);
            sec.addEntry("height", "" + this.object.getHeight());
        }
        this.addVisibilityPropertiesTo(sec);
        l.add(sec);
        return l;
    }

    public class SimplePropertiesSection
    extends PropertiesSection {
        public SimplePropertiesSection() {
            super("customization");
        }
    }
}

