/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.api.item;

import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.api.item.CustomizationItemContainer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CustomizationItemRegistry {
    protected static Map<String, CustomizationItemContainer> customizationItems = new HashMap<String, CustomizationItemContainer>();

    public static void registerItem(CustomizationItemContainer item) {
        if (item != null) {
            if (item.getIdentifier() != null) {
                if (customizationItems.containsKey(item.getIdentifier())) {
                    FancyMenu.LOGGER.warn("[FANCYMENU] WARNING! A customization item with the identifier '" + item.getIdentifier() + "' is already registered! Overriding item!");
                }
                customizationItems.put(item.getIdentifier(), item);
            } else {
                FancyMenu.LOGGER.error("[FANCYMENU] ERROR! Item identifier cannot be null for CustomizationItemContainers!");
            }
        }
    }

    public static void unregisterItem(String itemIdentifier) {
        customizationItems.remove(itemIdentifier);
    }

    public static List<CustomizationItemContainer> getItems() {
        ArrayList<CustomizationItemContainer> l = new ArrayList<CustomizationItemContainer>();
        l.addAll(customizationItems.values());
        return l;
    }

    public static CustomizationItemContainer getItem(String itemIdentifier) {
        return customizationItems.get(itemIdentifier);
    }
}

