/*
 * Decompiled with CFR 0.152.
 */
package lazy.baubles.event;

import java.util.Collection;
import java.util.Collections;
import lazy.baubles.api.BaublesAPI;
import lazy.baubles.api.bauble.IBauble;
import lazy.baubles.api.bauble.IBaublesItemHandler;
import lazy.baubles.api.cap.CapabilityBaubles;
import lazy.baubles.capability.BaublesContainer;
import lazy.baubles.capability.BaublesContainerProvider;
import lazy.baubles.network.PacketHandler;
import lazy.baubles.network.msg.SyncPacket;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class EventHandlerEntity {
    @SubscribeEvent
    public static void cloneCapabilitiesEvent(PlayerEvent.Clone event) {
        try {
            event.getOriginal().getCapability(CapabilityBaubles.BAUBLES).ifPresent(bco -> {
                CompoundTag nbt = ((BaublesContainer)bco).serializeNBT();
                event.getOriginal().getCapability(CapabilityBaubles.BAUBLES).ifPresent(bcn -> ((BaublesContainer)bcn).deserializeNBT(nbt));
            });
        }
        catch (Exception e) {
            System.out.println("Could not clone player [" + event.getOriginal().m_7755_() + "] baubles when changing dimensions");
        }
    }

    @SubscribeEvent
    public static void attachCapabilitiesPlayer(AttachCapabilitiesEvent<Entity> event) {
        Object object = event.getObject();
        if (object instanceof Player) {
            Player player = (Player)object;
            event.addCapability(new ResourceLocation("baubles", "container"), (ICapabilityProvider)new BaublesContainerProvider(player));
        }
    }

    @SubscribeEvent
    public static void playerJoin(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            EventHandlerEntity.syncSlots((Player)serverPlayer, Collections.singletonList(serverPlayer));
        }
    }

    @SubscribeEvent
    public static void onStartTracking(PlayerEvent.StartTracking event) {
        Entity target = event.getTarget();
        if (target instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)target;
            EventHandlerEntity.syncSlots((Player)serverPlayer, Collections.singletonList(event.getPlayer()));
        }
    }

    @SubscribeEvent
    public static void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            Player player = event.player;
            player.getCapability(CapabilityBaubles.BAUBLES).ifPresent(IBaublesItemHandler::tick);
        }
    }

    @SubscribeEvent
    public static void rightClickItem(PlayerInteractEvent.RightClickItem event) {
        ItemStack itemStack = event.getPlayer().m_21120_(event.getHand());
        Item item = itemStack.m_41720_();
        if (item instanceof IBauble) {
            IBauble bauble = (IBauble)item;
            IBaublesItemHandler itemHandler = (IBaublesItemHandler)BaublesAPI.getBaublesHandler(event.getPlayer()).orElseThrow(NullPointerException::new);
            int emptySlot = BaublesAPI.getEmptySlotForBaubleType(event.getPlayer(), bauble.getBaubleType(itemStack));
            if (emptySlot != -1) {
                itemHandler.setStackInSlot(emptySlot, itemStack.m_41777_());
                itemStack.m_41764_(0);
            }
        } else if (itemStack.getCapability(CapabilityBaubles.ITEM_BAUBLE).isPresent()) {
            IBauble bauble = (IBauble)itemStack.getCapability(CapabilityBaubles.ITEM_BAUBLE).orElseThrow(NullPointerException::new);
            IBaublesItemHandler itemHandler = (IBaublesItemHandler)BaublesAPI.getBaublesHandler(event.getPlayer()).orElseThrow(NullPointerException::new);
            int emptySlot = BaublesAPI.getEmptySlotForBaubleType(event.getPlayer(), bauble.getBaubleType(itemStack));
            if (emptySlot != -1) {
                itemHandler.setStackInSlot(emptySlot, itemStack.m_41777_());
                itemStack.m_41764_(0);
            }
        }
    }

    @SubscribeEvent
    public static void playerDeath(LivingDropsEvent event) {
        Level level = event.getEntity().f_19853_;
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player p = (Player)entity;
            if (!level.f_46443_ && !level.m_46469_().m_46207_(GameRules.f_46133_)) {
                EventHandlerEntity.dropItemsAt(p, event.getDrops());
            }
        }
    }

    private static void syncSlots(Player player, Collection<? extends Player> receivers) {
        player.getCapability(CapabilityBaubles.BAUBLES).ifPresent(baubles -> {
            for (byte i = 0; i < baubles.getSlots(); i = (byte)(i + 1)) {
                EventHandlerEntity.syncSlot(player, i, baubles.getStackInSlot(i), receivers);
            }
        });
    }

    public static void syncSlot(Player player, byte slot, ItemStack stack, Collection<? extends Player> receivers) {
        SyncPacket pkt = new SyncPacket(player.m_142049_(), slot, stack);
        for (Player player2 : receivers) {
            if (!(player2 instanceof ServerPlayer)) continue;
            ServerPlayer s = (ServerPlayer)player2;
            PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> s), (Object)pkt);
        }
    }

    private static void dropItemsAt(Player player, Collection<ItemEntity> drops) {
        player.getCapability(CapabilityBaubles.BAUBLES).ifPresent(baubles -> {
            for (int i = 0; i < baubles.getSlots(); ++i) {
                if (baubles.getStackInSlot(i).m_41619_()) continue;
                Vec3 pos = player.m_20182_();
                ItemEntity bauble = new ItemEntity(player.f_19853_, pos.f_82479_, pos.f_82480_ + (double)player.m_20192_(), pos.f_82481_, baubles.getStackInSlot(i).m_41777_());
                bauble.m_32010_(40);
                drops.add(bauble);
                baubles.setStackInSlot(i, ItemStack.f_41583_);
            }
        });
    }
}

