/*
 * Decompiled with CFR 0.152.
 */
package lazy.baubles.event;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lazy.baubles.api.bauble.IBauble;
import lazy.baubles.api.cap.CapabilityBaubles;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, modid="baubles")
public class AttachCapability {
    private static final ResourceLocation CAP = new ResourceLocation("baubles", "bauble_cap");

    @SubscribeEvent
    public static void attachCaps(AttachCapabilitiesEvent<ItemStack> event) {
        ItemStack stack = (ItemStack)event.getObject();
        Item item = stack.m_41720_();
        if (item instanceof IBauble) {
            final IBauble bauble = (IBauble)item;
            event.addCapability(CAP, new ICapabilityProvider(){
                private final LazyOptional<IBauble> opt = LazyOptional.of(() -> bauble);

                @Nonnull
                public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                    return CapabilityBaubles.ITEM_BAUBLE.orEmpty(cap, this.opt);
                }
            });
        }
    }
}

