/*
 * Decompiled with CFR 0.152.
 */
package lazy.baubles.client.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import lazy.baubles.api.bauble.IBaublesItemHandler;
import lazy.baubles.api.cap.CapabilityBaubles;
import lazy.baubles.api.render.IRenderBauble;
import lazy.baubles.setup.ModConfigs;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

public class BaublesRenderLayer<T extends Player, M extends PlayerModel<T>>
extends RenderLayer<T, M> {
    public BaublesRenderLayer(RenderLayerParent<T, M> entityRendererIn) {
        super(entityRendererIn);
    }

    public void render(PoseStack matrixStack, MultiBufferSource iRenderTypeBuffer, int i, Player player, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        if (!((Boolean)ModConfigs.RENDER_BAUBLE.get()).booleanValue() || player.m_21124_(MobEffects.f_19609_) != null) {
            return;
        }
        player.getCapability(CapabilityBaubles.BAUBLES).ifPresent(inv -> {
            this.dispatchRenders(matrixStack, (IBaublesItemHandler)inv, player, IRenderBauble.RenderType.BODY, partialTicks);
            float yaw = player.f_20886_ + (player.f_20885_ - player.f_20886_) * partialTicks;
            float yawOffset = player.f_20884_ + (player.f_20883_ - player.f_20884_) * partialTicks;
            float xRot = ((Float)ObfuscationReflectionHelper.getPrivateValue(Entity.class, (Object)player, (String)"f_19858_")).floatValue();
            float pitch = player.f_19860_ + (xRot - player.f_19860_) * partialTicks;
            matrixStack.m_85836_();
            matrixStack.m_85845_(Vector3f.f_122224_.m_122240_(yawOffset));
            matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(yaw - 270.0f));
            matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(pitch));
            this.dispatchRenders(matrixStack, (IBaublesItemHandler)inv, player, IRenderBauble.RenderType.HEAD, partialTicks);
            matrixStack.m_85849_();
        });
    }

    private void dispatchRenders(PoseStack poseStack, IBaublesItemHandler inv, Player player, IRenderBauble.RenderType type, float partialTicks) {
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            stack.getCapability(CapabilityBaubles.ITEM_BAUBLE).ifPresent(bauble -> {
                if (bauble instanceof IRenderBauble) {
                    IRenderBauble rb = (IRenderBauble)bauble;
                    poseStack.m_85836_();
                    RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    rb.onPlayerBaubleRender(poseStack, player, type, partialTicks);
                    poseStack.m_85849_();
                }
            });
        }
    }
}

