/*
 * Decompiled with CFR 0.152.
 */
package lazy.baubles.capability;

import javax.annotation.Nonnull;
import lazy.baubles.api.bauble.IBaublesItemHandler;
import lazy.baubles.api.cap.CapabilityBaubles;
import lazy.baubles.capability.BaublesContainer;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;

public class BaublesContainerProvider
implements INBTSerializable<CompoundTag>,
ICapabilityProvider {
    private final BaublesContainer inner;
    private final LazyOptional<IBaublesItemHandler> baublesHandlerCap;

    public BaublesContainerProvider(Player player) {
        this.inner = new BaublesContainer((LivingEntity)player);
        this.baublesHandlerCap = LazyOptional.of(() -> this.inner);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, Direction facing) {
        return CapabilityBaubles.BAUBLES.orEmpty(capability, this.baublesHandlerCap);
    }

    public CompoundTag serializeNBT() {
        return this.inner.serializeNBT();
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.inner.deserializeNBT(nbt);
    }
}

